/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.LogRecord;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.uihandler.Bundle;
import org.netbeans.modules.uihandler.Installer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.io.NbObjectInputStream;
import org.openide.windows.WindowManager;

class AfterRestartExceptions
implements Runnable {
    private static final Set<String> scheduledThrowableClasses = new HashSet<String>(Arrays.asList(OutOfMemoryError.class.getName(), "org.netbeans.modules.deadlock.detector.Detector$DeadlockDetectedException"));
    private static final Object IOLock = new Object();
    private static volatile Set<LogRecord> afterRestartRecords;

    private AfterRestartExceptions() {
    }

    static boolean willSchedule(LogRecord record) {
        return AfterRestartExceptions.getScheduledThrownClassName(record) != null;
    }

    private static String getScheduledThrownClassName(LogRecord record) {
        Throwable cause;
        Throwable thrown = record.getThrown();
        if (thrown == null) {
            return null;
        }
        while ((cause = thrown.getCause()) != null && cause.getStackTrace().length != 0) {
            thrown = cause;
        }
        String thrownClassName = thrown.getClass().getName();
        if (scheduledThrowableClasses.contains(thrownClassName)) {
            return thrownClassName;
        }
        return null;
    }

    static boolean schedule(LogRecord record) {
        String thrownClassName = AfterRestartExceptions.getScheduledThrownClassName(record);
        if (thrownClassName != null) {
            if (OutOfMemoryError.class.getName().equals(thrownClassName)) {
                AfterRestartExceptions.addHeapDump(record);
            }
            return AfterRestartExceptions.save(record);
        }
        return false;
    }

    private static File getLogRecordsFile() {
        File varLog = Installer.logsDirectory();
        if (varLog == null) {
            return null;
        }
        return new File(varLog, AfterRestartExceptions.class.getSimpleName());
    }

    private static void addHeapDump(LogRecord record) {
        File heapDump = Installer.getHeapDump();
        if (heapDump != null) {
            String heapDumpPath = heapDump.getAbsolutePath();
            Object[] parameters = record.getParameters();
            if (parameters == null) {
                parameters = new Object[]{heapDumpPath};
            } else {
                Object[] newParams = new Object[parameters.length + 1];
                System.arraycopy(parameters, 0, newParams, 0, parameters.length);
                newParams[parameters.length] = heapDumpPath;
                parameters = newParams;
            }
            record.setParameters(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean save(LogRecord record) {
        File exceptionsFile = AfterRestartExceptions.getLogRecordsFile();
        ObjectOutputStream os = null;
        Object object = IOLock;
        synchronized (object) {
            boolean bl;
            try {
                os = new ObjectOutputStream(new FileOutputStream(exceptionsFile, true));
                os.writeObject(record);
                bl = true;
            }
            catch (IOException ioex) {
                boolean bl2 = false;
                return bl2;
            }
            return bl;
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
    }

    static void report() {
        if (AfterRestartExceptions.readRecords()) {
            WindowManager.getDefault().invokeWhenUIReady((Runnable)new AfterRestartExceptions());
        }
    }

    static boolean isAfterRestartRecord(LogRecord record) {
        Set<LogRecord> records = afterRestartRecords;
        return records != null && records.contains(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean readRecords() {
        File logRecords = AfterRestartExceptions.getLogRecordsFile();
        if (logRecords == null || !logRecords.exists()) {
            return false;
        }
        LinkedHashSet<LogRecord> records = new LinkedHashSet<LogRecord>();
        ObjectInputStream in = null;
        Object object = IOLock;
        synchronized (object) {
            try {
                try {
                    in = new NbObjectInputStream((InputStream)new FileInputStream(logRecords));
                    while (true) {
                        Object obj;
                        if (!((obj = in.readObject()) instanceof LogRecord)) {
                            continue;
                        }
                        records.add((LogRecord)obj);
                    }
                }
                catch (IOException | ClassNotFoundException ex) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioex) {
                            // empty catch block
                        }
                    }
                    logRecords.delete();
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioex) {
                        // empty catch block
                    }
                }
                logRecords.delete();
                throw throwable;
            }
        }
        if (records.isEmpty()) {
            return false;
        }
        afterRestartRecords = records;
        return true;
    }

    @Override
    public void run() {
        final Set<LogRecord> records = afterRestartRecords;
        String msg = Bundle.MSG_AfterRestartReportQuestion();
        String title = Bundle.TTL_AfterRestartReport();
        int optionType = 3;
        JButton reportOption = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)reportOption, (String)Bundle.BTN_ReviewAndReport());
        NotifyDescriptor confMessage = new NotifyDescriptor((Object)msg, title, optionType, 3, new Object[]{reportOption, NotifyDescriptor.CANCEL_OPTION}, (Object)reportOption);
        Object ret = DialogDisplayer.getDefault().notify(confMessage);
        if (ret == reportOption) {
            Installer.RP.post(new Runnable(){

                @Override
                public void run() {
                    Installer.displaySummary("ERROR_URL", true, false, true, Installer.DataType.DATA_UIGESTURE, new ArrayList<LogRecord>(records), null, true);
                    Installer.setSelectedExcParams(null);
                    afterRestartRecords = null;
                }
            });
        }
    }
}

