/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.core.module.visengine;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.script.ScriptException;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.core.module.visengine.VisualizationException;
import rs.co.ast.aspen.core.module.visengine.graph.Graph;
import rs.co.ast.aspen.core.module.visengine.graph.Node;
import rs.co.ast.aspen.core.module.visengine.rs.Ruleset;

public class VisualizationEngine {
    private final Graph graph = new Graph();
    private final Ruleset ruleset;

    public VisualizationEngine(Ruleset ruleset) {
        this.ruleset = ruleset;
    }

    public void reset() {
        this.graph.clearAllNodes();
    }

    public Iterator<Node> allNodes() {
        return this.graph.allNodes();
    }

    public List<Node> allNodesList() {
        return this.graph.allNodesList();
    }

    public Iterator<Node> process(Collection<SecurityEvent> events) throws VisualizationException {
        for (SecurityEvent event : events) {
            try {
                this.ruleset.process(this.graph, event);
            }
            catch (ScriptException ex) {
                throw new VisualizationException(ex);
            }
        }
        return this.graph.rootNodes();
    }
}

