/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.chart;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Date;
import org.jfree.chart.labels.AbstractXYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.xy.XYDataset;

public class ByPriorityChartTooltipGenerator
extends AbstractXYItemLabelGenerator
implements XYToolTipGenerator {
    public static final String DEFAULT_TOOL_TIP_FORMAT = "{0}: ({1}, {2})";
    public static int PRIORITY5_TRESHOLD = 5000;

    public static ByPriorityChartTooltipGenerator getTimeSeriesInstance() {
        return new ByPriorityChartTooltipGenerator(DEFAULT_TOOL_TIP_FORMAT, DateFormat.getInstance(), NumberFormat.getInstance());
    }

    public ByPriorityChartTooltipGenerator(String formatString, DateFormat xFormat, NumberFormat yFormat) {
        super(formatString, xFormat, yFormat);
    }

    public String generateToolTip(XYDataset dataset, int series, int item) {
        return this.generateLabelString(dataset, series, item);
    }

    public String generateLabelString(XYDataset dataset, int series, int item) {
        Object[] items = this.createItemArray(dataset, series, item);
        String result = MessageFormat.format(this.getFormatString(), items);
        return result;
    }

    protected Object[] createItemArray(XYDataset dataset, int series, int item) {
        Object[] result = new Object[3];
        result[0] = dataset.getSeriesKey(series).toString();
        double x = dataset.getXValue(series, item);
        result[1] = this.getXDateFormat() != null ? this.getXDateFormat().format(new Date((long)x)) : this.getXFormat().format(x);
        double y = dataset.getYValue(series, item);
        String seriesKey = (String)((Object)dataset.getSeriesKey(series));
        if (seriesKey.equalsIgnoreCase("Priority 5")) {
            y /= (double)PRIORITY5_TRESHOLD;
        }
        result[2] = Double.isNaN(y) && dataset.getY(series, item) == null ? this.getNullYString() : (this.getYDateFormat() != null ? this.getYDateFormat().format(new Date((long)y)) : this.getYFormat().format(y));
        return result;
    }
}

