/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import net.jodah.failsafe.AbstractExecution;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.FailurePolicy;
import net.jodah.failsafe.Functions;
import net.jodah.failsafe.PolicyExecutor;
import net.jodah.failsafe.event.ExecutionAttemptedEvent;
import net.jodah.failsafe.function.CheckedConsumer;
import net.jodah.failsafe.function.CheckedFunction;
import net.jodah.failsafe.function.CheckedRunnable;
import net.jodah.failsafe.function.CheckedSupplier;
import net.jodah.failsafe.internal.executor.FallbackExecutor;
import net.jodah.failsafe.internal.util.Assert;

public class Fallback<R>
extends FailurePolicy<Fallback<R>, R> {
    private final CheckedFunction<ExecutionAttemptedEvent, R> fallback;
    private boolean async;

    private Fallback(CheckedFunction<ExecutionAttemptedEvent, R> fallback, boolean async) {
        this.fallback = Assert.notNull(fallback, "fallback");
        this.async = async;
    }

    public static <R> Fallback<R> of(CheckedRunnable fallback) {
        return new Fallback<CheckedRunnable>(Functions.fnOf(Assert.notNull(fallback, "fallback")), false);
    }

    public static <R> Fallback<R> ofAsync(CheckedRunnable fallback) {
        return new Fallback<CheckedRunnable>(Functions.fnOf(Assert.notNull(fallback, "fallback")), true);
    }

    public static <R> Fallback<R> of(CheckedSupplier<? extends R> fallback) {
        return new Fallback<CheckedSupplier<? extends R>>(Functions.fnOf(Assert.notNull(fallback, "fallback")), false);
    }

    public static <R> Fallback<R> ofAsync(CheckedSupplier<? extends R> fallback) {
        return new Fallback<CheckedSupplier<? extends R>>(Functions.fnOf(Assert.notNull(fallback, "fallback")), true);
    }

    public static <R> Fallback<R> of(CheckedConsumer<ExecutionAttemptedEvent<? extends R>> fallback) {
        return new Fallback<CheckedConsumer<ExecutionAttemptedEvent<? extends R>>>(Functions.fnOf(Assert.notNull(fallback, "fallback")), false);
    }

    public static <R> Fallback<R> ofAsync(CheckedConsumer<ExecutionAttemptedEvent<? extends R>> fallback) {
        return new Fallback<CheckedConsumer<ExecutionAttemptedEvent<? extends R>>>(Functions.fnOf(Assert.notNull(fallback, "fallback")), true);
    }

    public static <R> Fallback<R> of(CheckedFunction<ExecutionAttemptedEvent<? extends R>, ? extends R> fallback) {
        return new Fallback<R>(Assert.notNull(fallback, "fallback"), false);
    }

    public static <R> Fallback<R> ofAsync(CheckedFunction<ExecutionAttemptedEvent<? extends R>, ? extends R> fallback) {
        return new Fallback<R>(Assert.notNull(fallback, "fallback"), true);
    }

    public static <R> Fallback<R> of(R fallback) {
        return new Fallback<R>(Functions.fnOf(Assert.notNull(fallback, "fallback")), false);
    }

    public R apply(R result, Throwable failure, ExecutionContext context) throws Exception {
        return this.fallback.apply(new ExecutionAttemptedEvent<R>(result, failure, context));
    }

    public boolean isAsync() {
        return this.async;
    }

    @Override
    public PolicyExecutor toExecutor(AbstractExecution execution) {
        return new FallbackExecutor(this, execution);
    }
}

