/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor.nodes;

import java.util.ArrayList;
import java.util.List;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableNode;
import rs.co.ast.aspen.api.service.ParsingRuleTestCase;
import rs.co.ast.aspen.api.service.ParsingRuleTestCaseCheck;
import rs.co.ast.aspen.api.service.ParsingRuleTestResult;
import rs.co.ast.aspen.gui.module.prseditor.nodes.TestCaseCheckNode;
import rs.co.ast.aspen.gui.module.prseditor.nodes.TestRuleNode;

public class TestCaseNode
extends AbstractMutableTreeTableNode {
    private List<TestCaseCheckNode> childrens = new ArrayList<TestCaseCheckNode>();
    private boolean success;
    private ParsingRuleTestCase testCase;
    private ParsingRuleTestResult testResult;

    public TestCaseNode(MutableTreeTableNode parent, ParsingRuleTestCase testCase, ParsingRuleTestResult testResult, boolean success) {
        this.parent = parent;
        this.testCase = testCase;
        this.testResult = testResult;
        this.success = success;
        this.createChildNodes();
    }

    public boolean addChild(TestCaseCheckNode childNode) {
        return this.childrens.add(childNode);
    }

    public List<TestCaseCheckNode> getChildren() {
        return this.childrens;
    }

    public int getColumnCount() {
        return 4;
    }

    public TreeTableNode getParent() {
        return this.parent;
    }

    public void setParent(MutableTreeTableNode newParent) {
        this.parent = newParent;
    }

    public ParsingRuleTestCase getTestCase() {
        return this.testCase;
    }

    public Object getValueAt(int column) {
        switch (column) {
            case 0: {
                return this.testCase;
            }
        }
        return "";
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
        TestRuleNode tr = (TestRuleNode)this.parent;
        tr.checkSuccess();
    }

    private void createChildNodes() {
        System.out.println(String.format("%s - %s", this.testResult.getTestCase().getRawLog().getText(), this.testResult.isSuccedeed()));
        for (ParsingRuleTestCase.Checks.Entry entry : this.testCase.getChecks().getEntry()) {
            String key = entry.getKey();
            ParsingRuleTestCaseCheck value = entry.getValue();
            TestCaseCheckNode tccn = new TestCaseCheckNode((MutableTreeTableNode)this, value);
            tccn.checkSuccess(this.testResult);
            this.childrens.add(tccn);
        }
    }
}

