/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor.nodes;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ParsingRulesGroupDTO;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRulesGroupDTOWrapper;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RulesGroupNode;

public class RulesGroupsChildFactory
extends ChildFactory
implements NodeListener {
    private RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private String parentId;

    public RulesGroupsChildFactory(String parentId) {
        this.parentId = parentId;
    }

    public void childrenAdded(NodeMemberEvent ev) {
    }

    public void childrenRemoved(NodeMemberEvent ev) {
    }

    public void childrenReordered(NodeReorderEvent ev) {
    }

    public void nodeDestroyed(NodeEvent ev) {
        this.refresh(true);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    protected boolean createKeys(List toPopulate) {
        ArrayList<ParsingRulesGroupDTOWrapper> groups = new ArrayList<ParsingRulesGroupDTOWrapper>();
        try {
            List groups2 = this.model.getGroupsForParent(this.parentId, false);
            for (ParsingRulesGroupDTOWrapper g : groups2) {
                if (g.isForDelete() || !g.getParentId().equals(this.parentId)) continue;
                groups.add(g);
            }
            Collections.sort(groups, new Comparator<ParsingRulesGroupDTOWrapper>(){

                @Override
                public int compare(ParsingRulesGroupDTOWrapper o1, ParsingRulesGroupDTOWrapper o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            ParsingRulesGroupDTO group = new ParsingRulesGroupDTO();
            group.setParentId(this.parentId);
            group.setName(NbBundle.getMessage(RulesGroupsChildFactory.class, (String)"error.loadingnodes.message"));
            ParsingRulesGroupDTOWrapper wgroup = new ParsingRulesGroupDTOWrapper(group);
            groups.add(wgroup);
        }
        toPopulate.addAll(groups);
        return true;
    }

    protected Node createNodeForKey(Object key) {
        ParsingRulesGroupDTOWrapper group = (ParsingRulesGroupDTOWrapper)key;
        if (!group.isForDelete()) {
            RulesGroupNode node = new RulesGroupNode(group);
            node.addNodeListener(this);
            return node;
        }
        return null;
    }
}

