/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor.models;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleDTOWrapper;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRulesGroupDTOWrapper;

public class RulesTableModel
extends AbstractTableModel {
    private static final Logger LOGGER = Logger.getLogger(RulesTableModel.class.getName());
    private RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private List<ParsingRuleDTOWrapper> rules;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return ParsingRuleDTOWrapper.class;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return NbBundle.getMessage(RulesTableModel.class, (String)"rulesTables.col0.title");
            }
            case 1: {
                return NbBundle.getMessage(RulesTableModel.class, (String)"rulesTables.col1.title");
            }
            case 2: {
                return NbBundle.getMessage(RulesTableModel.class, (String)"rulesTables.col2.title");
            }
        }
        throw new IllegalArgumentException("Invalid column index");
    }

    public void setGroup(ParsingRulesGroupDTOWrapper group) {
        if (group != null) {
            List rulesForGroup = this.model.getRulesForGroup(group.getId());
            this.rules = new ArrayList<ParsingRuleDTOWrapper>();
            for (ParsingRuleDTOWrapper r : rulesForGroup) {
                if (r.isForDelete()) continue;
                this.rules.add(r);
            }
        } else {
            this.rules = new ArrayList<ParsingRuleDTOWrapper>();
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.rules != null ? this.rules.size() : 0;
    }

    public int getRowForRule(ParsingRuleDTOWrapper rule) {
        for (ParsingRuleDTOWrapper r : this.rules) {
            if (!r.getId().equals(rule.getId())) continue;
            return this.rules.indexOf(r);
        }
        return -1;
    }

    public ParsingRuleDTOWrapper getRule(int index) {
        if (this.rules != null && index < this.rules.size()) {
            return this.rules.get(index);
        }
        return null;
    }

    public List<ParsingRuleDTOWrapper> getRules() {
        return this.rules;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ParsingRuleDTOWrapper r = null;
        if (this.rules != null && rowIndex < this.rules.size()) {
            ParsingRuleDTOWrapper dto;
            r = dto = this.rules.get(rowIndex);
        }
        return r;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.model.isEditMode();
            }
            case 1: 
            case 2: {
                return false;
            }
        }
        return false;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.rules != null && rowIndex < this.rules.size()) {
            ParsingRuleDTOWrapper dto = this.rules.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    this.model.setRuleDescription(dto, (String)aValue);
                    break;
                }
                case 1: {
                    this.model.setRuleContinueParsing(dto, ((Boolean)aValue).booleanValue());
                    break;
                }
                case 2: {
                    this.model.setRuleSilent(dto, ((Boolean)aValue).booleanValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid column index");
                }
            }
        }
    }
}

