/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor;

import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import rs.co.ast.aspen.gui.module.prseditor.nodes.TestCaseCheckNode;
import rs.co.ast.aspen.gui.module.prseditor.nodes.TestCaseNode;
import rs.co.ast.aspen.gui.module.prseditor.nodes.TestGroupNode;
import rs.co.ast.aspen.gui.module.prseditor.nodes.TestRuleNode;
import rs.co.ast.aspen.gui.module.prseditor.nodes.TestRuleSetNode;

public class TreeTableCellRenderer
extends JLabel
implements TreeCellRenderer {
    private static final Color GRAY = Color.decode("#F2F2F2");
    private static final Color GREEN = Color.decode("#A9F5A9");
    private static final Color RED = Color.decode("#F5A9A9");
    private static final Logger logger = Logger.getLogger(TreeTableCellRenderer.class.getName());
    private Boolean success;

    public TreeTableCellRenderer() {
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.setHorizontalAlignment(2);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof TestRuleSetNode) {
            TestRuleSetNode trsn = (TestRuleSetNode)((Object)value);
            return this.setValues(trsn.getRuleSetWrapper().getRuleset().getName(), trsn.isSuccess());
        }
        if (value instanceof TestGroupNode) {
            TestGroupNode tgn = (TestGroupNode)((Object)value);
            return this.setValues(tgn.getGroupWrapper().getGroup().getName(), tgn.isSuccess());
        }
        if (value instanceof TestRuleNode) {
            TestRuleNode trn = (TestRuleNode)((Object)value);
            return this.setValues(trn.getRuleWrapper().getRule().getDescription(), trn.isSuccess());
        }
        if (value instanceof TestCaseNode) {
            TestCaseNode tcn = (TestCaseNode)((Object)value);
            return this.setValues("Test Case: " + tcn.getTestCase().getRawLog().getText(), null);
        }
        if (value instanceof TestCaseCheckNode) {
            TestCaseCheckNode tccn = (TestCaseCheckNode)((Object)value);
            return this.setValues("Check: " + tccn.getCheck().getCategory(), tccn.isSuccess());
        }
        return this;
    }

    public Boolean isSuccess() {
        return this.success;
    }

    private JLabel setValues(String name, Boolean success) {
        this.setText(name);
        this.setToolTipText(name);
        this.success = success;
        if (success != null && success.booleanValue()) {
            this.setIcon(this.createImageIcon("/accept.png", ""));
            this.setBackground(GREEN);
        } else if (success != null && !success.booleanValue()) {
            this.setIcon(this.createImageIcon("/delete.png", ""));
            this.setBackground(RED);
        } else {
            this.setIcon(this.createImageIcon("/script.png", ""));
            this.setBackground(GRAY);
        }
        return this;
    }

    protected ImageIcon createImageIcon(String path, String description) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        logger.warning(String.format("Couldn't find file: %s", path));
        return null;
    }
}

