/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ParsingRuleTestCaseCheck;
import rs.co.ast.aspen.api.service.ParsingRuleTestCaseCheckType;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleDTOWrapper;
import rs.co.ast.aspen.gui.module.prseditor.ParsingRulesetEditorTopComponent;

public class TestCaseCheckPanel
extends JPanel {
    private RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private ParsingRuleDTOWrapper rule;
    private ParsingRuleTestCaseCheck check;
    private TestCaseCheckPanel tccp = this;
    private JButton bClose;
    private JComboBox cbCategory;
    private JComboBox cbKey;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JToggleButton tbMatch;
    private JTextField tfValue;

    public TestCaseCheckPanel(ParsingRuleDTOWrapper rule, ParsingRuleTestCaseCheck check) {
        this.initComponents();
        this.setEditable(this.model.isEditMode());
        this.rule = rule;
        this.setTestCaseCheck(check);
        this.cbCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestCaseCheckPanel.this.model.setTestCaseCheckCategory(TestCaseCheckPanel.this.tccp.rule, TestCaseCheckPanel.this.tccp.check, (String)TestCaseCheckPanel.this.cbCategory.getSelectedItem());
            }
        });
        this.cbKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestCaseCheckPanel.this.model.setTestCaseCheckKey(TestCaseCheckPanel.this.tccp.rule, TestCaseCheckPanel.this.tccp.check, (String)TestCaseCheckPanel.this.cbKey.getSelectedItem());
            }
        });
        this.tfValue.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                TestCaseCheckPanel.this.model.setTestCaseCheckValue(TestCaseCheckPanel.this.tccp.rule, TestCaseCheckPanel.this.tccp.check, TestCaseCheckPanel.this.tfValue.getText());
            }
        });
        this.tbMatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TestCaseCheckPanel.this.tbMatch.isSelected()) {
                    TestCaseCheckPanel.this.tbMatch.setText(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"TestCaseType.mustMatch"));
                    TestCaseCheckPanel.this.model.setTestCaseCheckType(TestCaseCheckPanel.this.tccp.rule, TestCaseCheckPanel.this.tccp.check, ParsingRuleTestCaseCheckType.MUST_MATCH);
                } else {
                    TestCaseCheckPanel.this.tbMatch.setText(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"TestCaseType.mustNotMatch"));
                    TestCaseCheckPanel.this.model.setTestCaseCheckType(TestCaseCheckPanel.this.tccp.rule, TestCaseCheckPanel.this.tccp.check, ParsingRuleTestCaseCheckType.MUST_NOT_MATCH);
                }
            }
        });
    }

    private void setTestCaseCheck(ParsingRuleTestCaseCheck check) {
        this.check = check;
        this.updateDisplay();
    }

    public ParsingRuleTestCaseCheck getTestCaseCheck() {
        return this.check;
    }

    private void setEditable(boolean edit) {
        this.cbCategory.setEditable(edit);
        this.cbCategory.setEnabled(edit);
        this.cbKey.setEditable(edit);
        this.cbKey.setEnabled(edit);
        this.tfValue.setEditable(edit);
        this.tbMatch.setEnabled(edit);
        this.bClose.setEnabled(edit);
    }

    public void toggleEditable() {
        this.cbCategory.setEditable(!this.cbCategory.isEditable());
        this.cbCategory.setEnabled(!this.cbCategory.isEnabled());
        this.cbKey.setEditable(!this.cbKey.isEditable());
        this.cbKey.setEnabled(!this.cbKey.isEnabled());
        this.tfValue.setEditable(!this.tfValue.isEditable());
        this.tbMatch.setEnabled(!this.tbMatch.isEnabled());
        this.bClose.setEnabled(!this.bClose.isEnabled());
    }

    private void updateDisplay() {
        if (this.check != null) {
            this.cbCategory.setSelectedItem(this.check.getCategory());
            this.cbKey.addItem(this.check.getKey());
            this.cbKey.setSelectedItem(this.check.getKey());
            this.tfValue.setText(this.check.getRegexp());
            switch (this.check.getType()) {
                case MUST_MATCH: {
                    this.tbMatch.setSelected(true);
                    this.tbMatch.setText(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"TestCaseType.mustMatch"));
                    break;
                }
                case MUST_NOT_MATCH: {
                    this.tbMatch.setSelected(false);
                    this.tbMatch.setText(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"TestCaseType.mustNotMatch"));
                }
            }
        } else {
            this.cbCategory.setSelectedItem("");
            this.cbKey.setSelectedItem("");
            this.tfValue.setText("");
            this.tbMatch.setSelected(false);
        }
    }

    private void initComponents() {
        this.cbCategory = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.cbKey = new JComboBox();
        this.jLabel3 = new JLabel();
        this.tfValue = new JTextField();
        this.bClose = new JButton();
        this.tbMatch = new JToggleButton();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.cbCategory.setFont(new Font("Dialog", 0, 12));
        this.cbCategory.setModel(new DefaultComboBoxModel<String>(new String[]{"what", "who", "when", "where", "extra"}));
        this.cbCategory.setEnabled(false);
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(TestCaseCheckPanel.class, (String)"TestCaseCheckPanel.jLabel1.text"));
        this.jLabel2.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(TestCaseCheckPanel.class, (String)"TestCaseCheckPanel.jLabel2.text"));
        this.cbKey.setFont(new Font("Dialog", 0, 12));
        this.cbKey.setEnabled(false);
        this.jLabel3.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(TestCaseCheckPanel.class, (String)"TestCaseCheckPanel.jLabel3.text"));
        this.tfValue.setText(NbBundle.getMessage(TestCaseCheckPanel.class, (String)"TestCaseCheckPanel.tfValue.text"));
        this.bClose.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bClose, (String)NbBundle.getMessage(TestCaseCheckPanel.class, (String)"TestCaseCheckPanel.bClose.text"));
        this.bClose.setAlignmentX(0.5f);
        this.bClose.setMaximumSize(new Dimension(25, 25));
        this.bClose.setMinimumSize(new Dimension(25, 25));
        this.bClose.setPreferredSize(new Dimension(25, 25));
        this.bClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestCaseCheckPanel.this.bCloseActionPerformed(evt);
            }
        });
        this.tbMatch.setFont(new Font("Dialog", 0, 12));
        this.tbMatch.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.tbMatch, (String)NbBundle.getMessage(TestCaseCheckPanel.class, (String)"TestCaseCheckPanel.tbMatch.text"));
        this.tbMatch.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbCategory, 0, 138, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbKey, 0, 139, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfValue, -1, 140, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tbMatch).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bClose, -2, 45, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cbCategory, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.cbKey, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.tfValue, -2, -1, -2).addComponent(this.tbMatch).addComponent(this.bClose, -2, -1, -2)).addContainerGap()));
    }

    private void bCloseActionPerformed(ActionEvent evt) {
        Container parent = this.getParent();
        if (parent != null) {
            parent.remove(this.tccp);
            parent.validate();
            parent.repaint();
            Container parentsParent = parent.getParent();
            if (parentsParent != null) {
                parentsParent.validate();
                parentsParent.repaint();
            }
        }
        this.model.removeTestCaseCheck(this.rule, this.check);
        this.validate();
        this.repaint();
    }
}

