/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.BlenderKey;
import com.jme3.asset.GeneratedTextureKey;
import com.jme3.asset.TextureKey;
import com.jme3.math.Vector2f;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.ColorBand;
import com.jme3.scene.plugins.blender.textures.CombinedTexture;
import com.jme3.scene.plugins.blender.textures.GeneratedTexture;
import com.jme3.scene.plugins.blender.textures.ImageLoader;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.UVCoordinatesGenerator;
import com.jme3.scene.plugins.blender.textures.blending.TextureBlender;
import com.jme3.scene.plugins.blender.textures.blending.TextureBlenderFactory;
import com.jme3.scene.plugins.blender.textures.generating.TextureGeneratorFactory;
import com.jme3.scene.plugins.blender.textures.io.PixelIOFactory;
import com.jme3.scene.plugins.blender.textures.io.PixelInputOutput;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.image.ColorSpace;
import com.jme3.util.BufferUtils;
import com.jme3.util.PlaceholderAssets;
import java.awt.geom.AffineTransform;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TextureHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(TextureHelper.class.getName());
    public static final int TEX_NONE = 0;
    public static final int TEX_CLOUDS = 1;
    public static final int TEX_WOOD = 2;
    public static final int TEX_MARBLE = 3;
    public static final int TEX_MAGIC = 4;
    public static final int TEX_BLEND = 5;
    public static final int TEX_STUCCI = 6;
    public static final int TEX_NOISE = 7;
    public static final int TEX_IMAGE = 8;
    public static final int TEX_PLUGIN = 9;
    public static final int TEX_ENVMAP = 10;
    public static final int TEX_MUSGRAVE = 11;
    public static final int TEX_VORONOI = 12;
    public static final int TEX_DISTNOISE = 13;
    public static final int TEX_POINTDENSITY = 14;
    public static final int TEX_VOXELDATA = 15;
    public static final int TEX_OCEAN = 16;
    public static final VertexBuffer.Type[] TEXCOORD_TYPES = new VertexBuffer.Type[]{VertexBuffer.Type.TexCoord, VertexBuffer.Type.TexCoord2, VertexBuffer.Type.TexCoord3, VertexBuffer.Type.TexCoord4, VertexBuffer.Type.TexCoord5, VertexBuffer.Type.TexCoord6, VertexBuffer.Type.TexCoord7, VertexBuffer.Type.TexCoord8};
    private TextureGeneratorFactory textureGeneratorFactory = new TextureGeneratorFactory();

    public TextureHelper(String blenderVersion, BlenderContext blenderContext) {
        super(blenderVersion, blenderContext);
    }

    public Texture getTexture(Structure textureStructure, Structure mTex, BlenderContext blenderContext) throws BlenderFileException {
        Texture result = (Texture)blenderContext.getLoadedFeature(textureStructure.getOldMemoryAddress(), BlenderContext.LoadedDataType.FEATURE);
        if (result != null) {
            return result;
        }
        if ("ID".equals(textureStructure.getType())) {
            LOGGER.fine("Loading texture from external blend file.");
            return (Texture)this.loadLibrary(textureStructure);
        }
        int type = ((Number)textureStructure.getFieldValue("type")).intValue();
        int imaflag = ((Number)textureStructure.getFieldValue("imaflag")).intValue();
        switch (type) {
            case 8: {
                Structure image;
                Texture loadedTexture;
                Pointer pImage = (Pointer)textureStructure.getFieldValue("ima");
                if (!pImage.isNotNull() || (loadedTexture = this.loadImageAsTexture(image = pImage.fetchData().get(0), imaflag, blenderContext)) == null) break;
                result = loadedTexture;
                this.applyColorbandAndColorFactors(textureStructure, result.getImage(), blenderContext);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                result = new GeneratedTexture(textureStructure, mTex, this.textureGeneratorFactory.createTextureGenerator(type), blenderContext);
                break;
            }
            case 0: {
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: {
                LOGGER.log(Level.WARNING, "Unsupported texture type: {0} for texture: {1}", new Object[]{type, textureStructure.getName()});
                break;
            }
            default: {
                throw new BlenderFileException("Unknown texture type: " + type + " for texture: " + textureStructure.getName());
            }
        }
        if (result != null) {
            result.setName(textureStructure.getName());
            result.setWrap(Texture.WrapMode.Repeat);
            switch (blenderContext.getBlenderKey().getMipmapGenerationMethod()) {
                case ALWAYS_GENERATE: {
                    result.setMinFilter(Texture.MinFilter.Trilinear);
                    break;
                }
                case NEVER_GENERATE: {
                    break;
                }
                case GENERATE_WHEN_NEEDED: {
                    if ((imaflag & 4) == 0) break;
                    result.setMinFilter(Texture.MinFilter.Trilinear);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown mipmap generation method: " + (Object)((Object)blenderContext.getBlenderKey().getMipmapGenerationMethod()));
                }
            }
            if (type != 8) {
                result.setKey((AssetKey)new GeneratedTextureKey(textureStructure.getName()));
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Adding texture {0} to the loaded features with OMA = {1}", new Object[]{result.getName(), textureStructure.getOldMemoryAddress()});
            }
            blenderContext.addLoadedFeatures(textureStructure.getOldMemoryAddress(), BlenderContext.LoadedDataType.STRUCTURE, textureStructure);
            blenderContext.addLoadedFeatures(textureStructure.getOldMemoryAddress(), BlenderContext.LoadedDataType.FEATURE, result);
        }
        return result;
    }

    public Texture loadImageAsTexture(Structure imageStructure, int imaflag, BlenderContext blenderContext) throws BlenderFileException {
        LOGGER.log(Level.FINE, "Fetching texture with OMA = {0}", imageStructure.getOldMemoryAddress());
        Texture result = null;
        Image im = (Image)blenderContext.getLoadedFeature(imageStructure.getOldMemoryAddress(), BlenderContext.LoadedDataType.FEATURE);
        if ("ID".equals(imageStructure.getType())) {
            LOGGER.fine("Loading texture from external blend file.");
            result = (Texture)this.loadLibrary(imageStructure);
        } else {
            String texturePath = imageStructure.getFieldValue("name").toString();
            Pointer pPackedFile = (Pointer)imageStructure.getFieldValue("packedfile");
            if (pPackedFile.isNull()) {
                LOGGER.log(Level.FINE, "Reading texture from file: {0}", texturePath);
                result = this.loadImageFromFile(texturePath, imaflag, blenderContext);
            } else {
                LOGGER.fine("Packed texture. Reading directly from the blend file!");
                Structure packedFile = pPackedFile.fetchData().get(0);
                Pointer pData = (Pointer)packedFile.getFieldValue("data");
                FileBlockHeader dataFileBlock = blenderContext.getFileBlock(pData.getOldMemoryAddress());
                blenderContext.getInputStream().setPosition(dataFileBlock.getBlockPosition());
                result = new ImageLoader().loadTexture(blenderContext.getAssetManager(), blenderContext.getInputStream(), dataFileBlock.getBlockPosition(), true);
                if (result == null) {
                    result = new Texture2D(PlaceholderAssets.getPlaceholderImage((AssetManager)blenderContext.getAssetManager()));
                    LOGGER.fine("ImageLoader returned null. It probably failed to load the packed texture, using placeholder asset");
                }
            }
        }
        if (result != null) {
            blenderContext.addLoadedFeatures(imageStructure.getOldMemoryAddress(), BlenderContext.LoadedDataType.STRUCTURE, imageStructure);
            blenderContext.addLoadedFeatures(imageStructure.getOldMemoryAddress(), BlenderContext.LoadedDataType.FEATURE, result.getImage());
            result.setName(imageStructure.getName());
        }
        return result;
    }

    public AffineTransform createAffineTransform(Vector2f[] source, Vector2f[] dest, int[] sourceSize, int[] targetSize) {
        float x11 = source[0].getX() * (float)sourceSize[0];
        float x12 = source[0].getY() * (float)sourceSize[1];
        float x21 = source[1].getX() * (float)sourceSize[0];
        float x22 = source[1].getY() * (float)sourceSize[1];
        float x31 = source[2].getX() * (float)sourceSize[0];
        float x32 = source[2].getY() * (float)sourceSize[1];
        float y11 = dest[0].getX() * (float)targetSize[0];
        float y12 = dest[0].getY() * (float)targetSize[1];
        float y21 = dest[1].getX() * (float)targetSize[0];
        float y22 = dest[1].getY() * (float)targetSize[1];
        float y31 = dest[2].getX() * (float)targetSize[0];
        float y32 = dest[2].getY() * (float)targetSize[1];
        float a1 = ((y11 - y21) * (x12 - x32) - (y11 - y31) * (x12 - x22)) / ((x11 - x21) * (x12 - x32) - (x11 - x31) * (x12 - x22));
        float a2 = ((y11 - y21) * (x11 - x31) - (y11 - y31) * (x11 - x21)) / ((x12 - x22) * (x11 - x31) - (x12 - x32) * (x11 - x21));
        float a3 = y11 - a1 * x11 - a2 * x12;
        float a4 = ((y12 - y22) * (x12 - x32) - (y12 - y32) * (x12 - x22)) / ((x11 - x21) * (x12 - x32) - (x11 - x31) * (x12 - x22));
        float a5 = ((y12 - y22) * (x11 - x31) - (y12 - y32) * (x11 - x21)) / ((x12 - x22) * (x11 - x31) - (x12 - x32) * (x11 - x21));
        float a6 = y12 - a4 * x11 - a5 * x12;
        return new AffineTransform(a1, a4, a2, a5, a3, a6);
    }

    public int getPixelPosition(float pos, int size) {
        float pixelWidth = 1.0f / (float)size;
        int result = (int)(pos *= (float)size);
        if (Math.abs((float)result - pos) > pixelWidth) {
            ++result;
        }
        return result;
    }

    public Image getSubimage(Image image, int minX, int minY, int maxX, int maxY) {
        if (minY > maxY) {
            throw new IllegalArgumentException("Minimum Y value is higher than maximum Y value!");
        }
        if (minX > maxX) {
            throw new IllegalArgumentException("Minimum Y value is higher than maximum Y value!");
        }
        if (image.getData().size() > 1) {
            throw new IllegalArgumentException("Only flat images are allowed for subimage operation!");
        }
        if (image.getMipMapSizes() != null) {
            LOGGER.warning("Subimaging image with mipmaps is not yet supported!");
        }
        int width = maxX - minX;
        int height = maxY - minY;
        ByteBuffer data = BufferUtils.createByteBuffer((int)(width * height * (image.getFormat().getBitsPerPixel() >> 3)));
        Image result = new Image(image.getFormat(), width, height, data, ColorSpace.sRGB);
        PixelInputOutput pixelIO = PixelIOFactory.getPixelIO(image.getFormat());
        TexturePixel pixel = new TexturePixel();
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                pixelIO.read(image, 0, pixel, x, y);
                pixelIO.write(result, 0, pixel, x - minX, y - minY);
            }
        }
        return result;
    }

    private void applyColorbandAndColorFactors(Structure tex, Image image, BlenderContext blenderContext) {
        block7: {
            int depth;
            float bfac;
            float gfac;
            float rfac;
            block6: {
                rfac = ((Number)tex.getFieldValue("rfac")).floatValue();
                gfac = ((Number)tex.getFieldValue("gfac")).floatValue();
                bfac = ((Number)tex.getFieldValue("bfac")).floatValue();
                float[][] colorBand = new ColorBand(tex, blenderContext).computeValues();
                int n = depth = image.getDepth() == 0 ? 1 : image.getDepth();
                if (colorBand == null) break block6;
                TexturePixel pixel = new TexturePixel();
                PixelInputOutput imageIO = PixelIOFactory.getPixelIO(image.getFormat());
                for (int layerIndex = 0; layerIndex < depth; ++layerIndex) {
                    for (int x = 0; x < image.getWidth(); ++x) {
                        for (int y = 0; y < image.getHeight(); ++y) {
                            imageIO.read(image, layerIndex, pixel, x, y);
                            int colorbandIndex = (int)(pixel.alpha * 1000.0f);
                            pixel.red = colorBand[colorbandIndex][0] * rfac;
                            pixel.green = colorBand[colorbandIndex][1] * gfac;
                            pixel.blue = colorBand[colorbandIndex][2] * bfac;
                            pixel.alpha = colorBand[colorbandIndex][3];
                            imageIO.write(image, layerIndex, pixel, x, y);
                        }
                    }
                }
                break block7;
            }
            if (rfac == 1.0f && gfac == 1.0f && bfac == 1.0f) break block7;
            TexturePixel pixel = new TexturePixel();
            PixelInputOutput imageIO = PixelIOFactory.getPixelIO(image.getFormat());
            for (int layerIndex = 0; layerIndex < depth; ++layerIndex) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    for (int y = 0; y < image.getHeight(); ++y) {
                        imageIO.read(image, layerIndex, pixel, x, y);
                        pixel.red *= rfac;
                        pixel.green *= gfac;
                        pixel.blue *= bfac;
                        imageIO.write(image, layerIndex, pixel, x, y);
                    }
                }
            }
        }
    }

    protected Texture loadImageFromFile(String name, int imaflag, BlenderContext blenderContext) {
        if (!name.contains(".")) {
            return null;
        }
        boolean generateMipmaps = false;
        switch (blenderContext.getBlenderKey().getMipmapGenerationMethod()) {
            case ALWAYS_GENERATE: {
                generateMipmaps = true;
                break;
            }
            case NEVER_GENERATE: {
                break;
            }
            case GENERATE_WHEN_NEEDED: {
                generateMipmaps = (imaflag & 4) != 0;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mipmap generation method: " + (Object)((Object)blenderContext.getBlenderKey().getMipmapGenerationMethod()));
            }
        }
        AssetManager assetManager = blenderContext.getAssetManager();
        name = name.replace('\\', '/');
        Texture result = null;
        if (name.startsWith("//")) {
            String relativePath = name.substring(2);
            BlenderKey blenderKey = blenderContext.getBlenderKey();
            int idx = blenderKey.getName().lastIndexOf(47);
            String blenderAssetFolder = blenderKey.getName().substring(0, idx != -1 ? idx : 0);
            String absoluteName = blenderAssetFolder + '/' + relativePath;
            try {
                TextureKey key = new TextureKey(absoluteName);
                key.setFlipY(true);
                key.setGenerateMips(generateMipmaps);
                result = assetManager.loadTexture(key);
                result.setKey((AssetKey)key);
            }
            catch (AssetLoadException | AssetNotFoundException e) {
                LOGGER.fine(e.getLocalizedMessage());
            }
        } else {
            ArrayList<String> assetNames = new ArrayList<String>();
            String[] paths = name.split("\\/");
            StringBuilder sb = new StringBuilder(paths[paths.length - 1]);
            assetNames.add(paths[paths.length - 1]);
            for (int i = paths.length - 2; i >= 0; --i) {
                sb.insert(0, '/');
                sb.insert(0, paths[i]);
                assetNames.add(0, sb.toString());
            }
            for (String assetName : assetNames) {
                try {
                    Texture texture;
                    TextureKey key = new TextureKey(assetName);
                    key.setFlipY(true);
                    key.setGenerateMips(generateMipmaps);
                    AssetInfo info = assetManager.locateAsset((AssetKey)key);
                    if (info == null) continue;
                    result = texture = assetManager.loadTexture(key);
                    texture.setKey((AssetKey)key);
                    return result;
                }
                catch (AssetLoadException | AssetNotFoundException e) {
                    LOGGER.fine(e.getLocalizedMessage());
                }
            }
            try {
                TextureKey key = new TextureKey(name);
                assetManager.loadTexture(key);
            }
            catch (AssetLoadException | AssetNotFoundException e) {
                LOGGER.fine(e.getLocalizedMessage());
            }
        }
        return result;
    }

    public List<CombinedTexture> readTextureData(Structure structure, float[] diffuseColorArray, boolean skyTexture) throws BlenderFileException {
        DynamicArray mtexsArray = (DynamicArray)structure.getFieldValue("mtex");
        int separatedTextures = skyTexture ? 0 : ((Number)structure.getFieldValue("septex")).intValue();
        ArrayList<TextureData> texturesList = new ArrayList<TextureData>();
        for (int i = 0; i < mtexsArray.getTotalSize(); ++i) {
            Structure tex;
            Pointer pTex;
            Pointer p = (Pointer)mtexsArray.get(i);
            if (!p.isNotNull() || (separatedTextures & 1 << i) != 0) continue;
            TextureData textureData = new TextureData();
            textureData.mtex = p.fetchData().get(0);
            textureData.uvCoordinatesType = skyTexture ? UVCoordinatesGenerator.UVCoordinatesType.TEXCO_ORCO.blenderValue : ((Number)textureData.mtex.getFieldValue("texco")).intValue();
            textureData.projectionType = ((Number)textureData.mtex.getFieldValue("mapping")).intValue();
            textureData.uvCoordinatesName = textureData.mtex.getFieldValue("uvName").toString();
            if (textureData.uvCoordinatesName != null && textureData.uvCoordinatesName.trim().length() == 0) {
                textureData.uvCoordinatesName = null;
            }
            if (!(pTex = (Pointer)textureData.mtex.getFieldValue("tex")).isNotNull()) continue;
            textureData.textureStructure = tex = pTex.fetchData().get(0);
            texturesList.add(textureData);
        }
        LOGGER.info("Loading model's textures.");
        ArrayList<CombinedTexture> loadedTextures = new ArrayList<CombinedTexture>();
        if (this.blenderContext.getBlenderKey().isOptimiseTextures()) {
            LOGGER.fine("Optimising the useage of model's textures.");
            Map<Number, List<TextureData>> textureDataMap = this.sortTextures(texturesList);
            for (Map.Entry<Number, List<TextureData>> entry : textureDataMap.entrySet()) {
                if (entry.getValue().size() <= 0) continue;
                CombinedTexture combinedTexture = new CombinedTexture(entry.getKey().intValue(), !skyTexture);
                for (TextureData textureData : entry.getValue()) {
                    boolean negateTexture;
                    int texflag = ((Number)textureData.mtex.getFieldValue("texflag")).intValue();
                    boolean bl = negateTexture = (texflag & 4) != 0;
                    Texture texture = this.getTexture(textureData.textureStructure, textureData.mtex, this.blenderContext);
                    if (texture == null) continue;
                    int blendType = ((Number)textureData.mtex.getFieldValue("blendtype")).intValue();
                    float[] color = new float[]{((Number)textureData.mtex.getFieldValue("r")).floatValue(), ((Number)textureData.mtex.getFieldValue("g")).floatValue(), ((Number)textureData.mtex.getFieldValue("b")).floatValue()};
                    float colfac = ((Number)textureData.mtex.getFieldValue("colfac")).floatValue();
                    TextureBlender textureBlender = TextureBlenderFactory.createTextureBlender(texture.getImage().getFormat(), texflag, negateTexture, blendType, diffuseColorArray, color, colfac);
                    combinedTexture.add(texture, textureBlender, textureData.uvCoordinatesType, textureData.projectionType, textureData.textureStructure, textureData.uvCoordinatesName, this.blenderContext);
                }
                if (combinedTexture.getTexturesCount() <= 0) continue;
                loadedTextures.add(combinedTexture);
            }
        } else {
            LOGGER.fine("No textures optimisation applied.");
            int[] mappings = new int[]{1, 2, 64, 4, 128, 2048};
            for (TextureData textureData : texturesList) {
                Texture texture = this.getTexture(textureData.textureStructure, textureData.mtex, this.blenderContext);
                if (texture == null) continue;
                Number mapto = (Number)textureData.mtex.getFieldValue("mapto");
                int texflag = ((Number)textureData.mtex.getFieldValue("texflag")).intValue();
                boolean negateTexture = (texflag & 4) != 0;
                boolean colorSet = false;
                for (int i = 0; i < mappings.length; ++i) {
                    if ((mappings[i] & mapto.intValue()) == 0) continue;
                    if (mappings[i] == 1) {
                        colorSet = true;
                    } else if (colorSet && mappings[i] == 128) continue;
                    CombinedTexture combinedTexture = new CombinedTexture(mappings[i], !skyTexture);
                    int blendType = ((Number)textureData.mtex.getFieldValue("blendtype")).intValue();
                    float[] color = new float[]{((Number)textureData.mtex.getFieldValue("r")).floatValue(), ((Number)textureData.mtex.getFieldValue("g")).floatValue(), ((Number)textureData.mtex.getFieldValue("b")).floatValue()};
                    float colfac = ((Number)textureData.mtex.getFieldValue("colfac")).floatValue();
                    TextureBlender textureBlender = TextureBlenderFactory.createTextureBlender(texture.getImage().getFormat(), texflag, negateTexture, blendType, diffuseColorArray, color, colfac);
                    combinedTexture.add(texture, textureBlender, textureData.uvCoordinatesType, textureData.projectionType, textureData.textureStructure, textureData.uvCoordinatesName, this.blenderContext);
                    if (combinedTexture.getTexturesCount() <= 0) continue;
                    loadedTextures.add(combinedTexture);
                }
            }
        }
        return loadedTextures;
    }

    private Map<Number, List<TextureData>> sortTextures(List<TextureData> textures) {
        int[] mappings = new int[]{1, 2, 64, 4, 128, 2048};
        HashMap<Number, List<TextureData>> result = new HashMap<Number, List<TextureData>>();
        for (TextureData data : textures) {
            Number mapto = (Number)data.mtex.getFieldValue("mapto");
            boolean colorSet = false;
            for (int i = 0; i < mappings.length; ++i) {
                if ((mappings[i] & mapto.intValue()) == 0) continue;
                if (mappings[i] == 1) {
                    colorSet = true;
                } else if (colorSet && mappings[i] == 128) continue;
                ArrayList<TextureData> datas = (ArrayList<TextureData>)result.get(mappings[i]);
                if (datas == null) {
                    datas = new ArrayList<TextureData>();
                    result.put(mappings[i], datas);
                }
                datas.add(data);
            }
        }
        return result;
    }

    private static class TextureData {
        public Structure mtex;
        public Structure textureStructure;
        public int uvCoordinatesType;
        public int projectionType;
        public String uvCoordinatesName;

        private TextureData() {
        }
    }
}

