/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleDTOWrapper;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRulesGroupDTOWrapper;
import rs.co.ast.aspen.gui.rawlogs.nodes.RuleNode;
import rs.co.ast.aspen.gui.rawlogs.nodes.RulesGroupNode;

public class RulesGroupsChildFactory
extends ChildFactory {
    private boolean drawRules;
    private RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private String parentId;

    public RulesGroupsChildFactory(String parentId, boolean drawRules) {
        this.parentId = parentId;
        this.drawRules = drawRules;
    }

    protected boolean createKeys(List toPopulate) {
        try {
            List groups2 = this.model.getGroupsForParent(this.parentId, true);
            ArrayList<ParsingRulesGroupDTOWrapper> groups = new ArrayList<ParsingRulesGroupDTOWrapper>();
            for (ParsingRulesGroupDTOWrapper g : groups2) {
                if (g.isForDelete()) continue;
                groups.add(g);
            }
            Collections.sort(groups, new Comparator<ParsingRulesGroupDTOWrapper>(){

                @Override
                public int compare(ParsingRulesGroupDTOWrapper o1, ParsingRulesGroupDTOWrapper o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            toPopulate.addAll(groups);
            List rules2 = this.model.getRulesForGroup(this.parentId);
            ArrayList<ParsingRuleDTOWrapper> rules = new ArrayList<ParsingRuleDTOWrapper>();
            for (ParsingRuleDTOWrapper g : rules2) {
                if (g.isForDelete()) continue;
                rules.add(g);
            }
            toPopulate.addAll(rules);
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return true;
    }

    protected Node createNodeForKey(Object key) {
        if (key instanceof ParsingRulesGroupDTOWrapper) {
            ParsingRulesGroupDTOWrapper group = (ParsingRulesGroupDTOWrapper)key;
            RulesGroupNode node = new RulesGroupNode(group, this.drawRules);
            return node;
        }
        if (this.drawRules) {
            ParsingRuleDTOWrapper group = (ParsingRuleDTOWrapper)key;
            RuleNode node = new RuleNode(group);
            return node;
        }
        return null;
    }
}

