/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import rs.co.ast.aspen.gui.module.datamaps.DataMapKey;
import rs.co.ast.aspen.gui.module.datamaps.DataMapsTopComponent;
import rs.co.ast.aspen.gui.module.datamaps.model.DataMapModel;
import rs.co.ast.aspen.gui.module.datamaps.model.DeletedDataMapsModel;
import rs.co.ast.aspen.gui.module.datamaps.nodes.DataMapKeyNode;
import rs.co.ast.aspen.gui.module.datamaps.nodes.DataMapNode;

public final class DeleteMultipleDataMapKeyAction
implements ActionListener {
    private final List<DataMapKey> keys;
    private DataMapModel model = (DataMapModel)Lookup.getDefault().lookup(DataMapModel.class);
    private DeletedDataMapsModel deletedDataMapsModel = (DeletedDataMapsModel)Lookup.getDefault().lookup(DeletedDataMapsModel.class);

    public DeleteMultipleDataMapKeyAction(List<DataMapKey> keys) {
        this.keys = keys;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DeleteDataMapKeyConfirmation.message"), NbBundle.getMessage(DataMapsTopComponent.class, (String)"DeleteDataMapKeyConfirmation.title"), 0);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
            this.deletedDataMapsModel.addDeletedKeys(this.keys);
            for (DataMapKey key : this.keys) {
                Node parentNode;
                this.model.deleteDataMapKey(key.getDmv().getMap(), key.getDmv().getKey());
                DataMapKeyNode dataMapNode = (DataMapKeyNode)Utilities.actionsGlobalContext().lookup(DataMapKeyNode.class);
                if (dataMapNode == null || !((parentNode = dataMapNode.getParentNode()) instanceof DataMapNode)) continue;
                DataMapNode node = (DataMapNode)parentNode;
                node.updateChildren(key.getDmv().getMap());
            }
        }
    }
}

