/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.gfx;

import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import com.jme3.font.BitmapFont;
import com.jme3.math.ColorRGBA;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.FontKey;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.FontStyle;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.RGBAToAwt;

public class FontCache {
    private static final ExecutorService BG = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private static final String DEFAULT_FONT = "appfnt.ttf";
    private static final Map<FontKey, BitmapFont> FONT_CACHE = new HashMap<FontKey, BitmapFont>();
    private static final Map<FontKey, Future> FUTURES = new HashMap<FontKey, Future>();
    private final AssetManager assetManager;
    private final Thread pruneFutures = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Thread.sleep(1000L);
                    Map map = FUTURES;
                    synchronized (map) {
                        Iterator it = FUTURES.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            Future f = (Future)entry.getValue();
                            if (!f.isDone()) continue;
                            try {
                                f.get();
                                it.remove();
                            }
                            catch (InterruptedException | ExecutionException exception) {}
                        }
                    }
                }
                catch (InterruptedException ex) {
                    this.interrupt();
                }
            }
        }
    };

    public FontCache(AssetManager assetManager) {
        this.assetManager = assetManager;
        this.pruneFutures.setDaemon(true);
        this.pruneFutures.start();
    }

    public BitmapFont getFont(String name, String style, int size, ColorRGBA color) {
        FontKey key = new FontKey(this.getName(name), 0, new RGBAToAwt(color).getColor(), size, new FontStyle(style).getFontStyle());
        return this.getFont(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFontAsync(String name, String style, int size, ColorRGBA color, Function<BitmapFont, Void> code) {
        FontKey key = new FontKey(this.getName(name), 0, new RGBAToAwt(color).getColor(), size, new FontStyle(style).getFontStyle());
        Map<FontKey, Future> map = FUTURES;
        synchronized (map) {
            BitmapFont fnt = FONT_CACHE.get((Object)key);
            if (fnt != null) {
                code.apply(fnt);
            } else if (!FUTURES.containsKey((Object)key)) {
                Future<?> future = BG.submit(() -> {
                    BitmapFont font = this.getFont(key);
                    code.apply(font);
                });
                FUTURES.put(key, future);
            }
        }
    }

    private BitmapFont getDefaultFont() {
        return this.assetManager.loadFont("Default.fnt");
    }

    private BitmapFont getFont(FontKey key) {
        BitmapFont font = FONT_CACHE.get((Object)key);
        if (font == null) {
            font = this.getTrueTypeFont(key);
            if (font == null) {
                font = this.getDefaultFont();
            }
            FONT_CACHE.put(key, font);
        }
        return font;
    }

    private String getName(String name) {
        String ret = name;
        if (name == null) {
            ret = DEFAULT_FONT;
        } else if (!name.endsWith(".ttf")) {
            ret = name.concat(".ttf");
        }
        return ret;
    }

    private BitmapFont getTrueTypeFont(FontKey key) {
        return (BitmapFont)this.assetManager.loadAsset((AssetKey)key);
    }
}

