/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.FastMath;
import com.jme3.renderer.Renderer;
import com.jme3.texture.image.ColorSpace;
import com.jme3.texture.image.LastTextureState;
import com.jme3.util.BufferUtils;
import com.jme3.util.NativeObject;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Image
extends NativeObject
implements Savable {
    protected Format format;
    protected int width;
    protected int height;
    protected int depth;
    protected int[] mipMapSizes;
    protected ArrayList<ByteBuffer> data;
    protected int multiSamples = 1;
    protected ColorSpace colorSpace = null;
    protected boolean mipsWereGenerated = false;
    protected boolean needGeneratedMips = false;
    protected LastTextureState lastTextureState = new LastTextureState();

    public LastTextureState getLastTextureState() {
        return this.lastTextureState;
    }

    public void setMipmapsGenerated(boolean generated) {
        this.mipsWereGenerated = generated;
    }

    public boolean isMipmapsGenerated() {
        return this.mipsWereGenerated;
    }

    void setNeedGeneratedMipmaps() {
        this.needGeneratedMips = true;
    }

    public boolean isGeneratedMipmapsRequired() {
        return this.needGeneratedMips;
    }

    @Override
    public void setUpdateNeeded() {
        super.setUpdateNeeded();
        if (this.isGeneratedMipmapsRequired() && !this.hasMipmaps()) {
            this.setMipmapsGenerated(false);
        }
    }

    public boolean isNPOT() {
        return this.width != 0 && this.height != 0 && (!FastMath.isPowerOfTwo(this.width) || !FastMath.isPowerOfTwo(this.height));
    }

    @Override
    public void resetObject() {
        this.id = -1;
        this.mipsWereGenerated = false;
        this.lastTextureState.reset();
        this.setUpdateNeeded();
    }

    @Override
    protected void deleteNativeBuffers() {
        for (ByteBuffer buf : this.data) {
            BufferUtils.destroyDirectBuffer(buf);
        }
    }

    @Override
    public void deleteObject(Object rendererObject) {
        ((Renderer)rendererObject).deleteImage(this);
    }

    @Override
    public NativeObject createDestructableClone() {
        return new Image(this.id);
    }

    @Override
    public long getUniqueId() {
        return 0x200000000L | (long)this.id;
    }

    @Override
    public Image clone() {
        Image clone = (Image)super.clone();
        clone.mipMapSizes = this.mipMapSizes != null ? (int[])this.mipMapSizes.clone() : null;
        clone.data = this.data != null ? new ArrayList<ByteBuffer>(this.data) : null;
        clone.lastTextureState = new LastTextureState();
        clone.setUpdateNeeded();
        return clone;
    }

    public Image() {
        this.data = new ArrayList(1);
    }

    protected Image(int id) {
        super(id);
    }

    public Image(Format format, int width, int height, int depth, ArrayList<ByteBuffer> data, int[] mipMapSizes, ColorSpace colorSpace) {
        this();
        if (mipMapSizes != null) {
            if (mipMapSizes.length <= 1) {
                mipMapSizes = null;
            } else {
                this.needGeneratedMips = false;
                this.mipsWereGenerated = true;
            }
        }
        this.setFormat(format);
        this.width = width;
        this.height = height;
        this.data = data;
        this.depth = depth;
        this.mipMapSizes = mipMapSizes;
        this.colorSpace = colorSpace;
    }

    @Deprecated
    public Image(Format format, int width, int height, int depth, ArrayList<ByteBuffer> data, int[] mipMapSizes) {
        this(format, width, height, depth, data, mipMapSizes, ColorSpace.Linear);
    }

    public Image(Format format, int width, int height, ByteBuffer data, int[] mipMapSizes, ColorSpace colorSpace) {
        this();
        if (mipMapSizes != null && mipMapSizes.length <= 1) {
            mipMapSizes = null;
        } else {
            this.needGeneratedMips = false;
            this.mipsWereGenerated = true;
        }
        this.setFormat(format);
        this.width = width;
        this.height = height;
        if (data != null) {
            this.data = new ArrayList(1);
            this.data.add(data);
        }
        this.mipMapSizes = mipMapSizes;
        this.colorSpace = colorSpace;
    }

    @Deprecated
    public Image(Format format, int width, int height, ByteBuffer data, int[] mipMapSizes) {
        this(format, width, height, data, mipMapSizes, ColorSpace.Linear);
    }

    public Image(Format format, int width, int height, int depth, ArrayList<ByteBuffer> data, ColorSpace colorSpace) {
        this(format, width, height, depth, data, null, colorSpace);
    }

    @Deprecated
    public Image(Format format, int width, int height, int depth, ArrayList<ByteBuffer> data) {
        this(format, width, height, depth, data, ColorSpace.Linear);
    }

    public Image(Format format, int width, int height, ByteBuffer data, ColorSpace colorSpace) {
        this(format, width, height, data, null, colorSpace);
    }

    @Deprecated
    public Image(Format format, int width, int height, ByteBuffer data) {
        this(format, width, height, data, null, ColorSpace.Linear);
    }

    public int getMultiSamples() {
        return this.multiSamples;
    }

    public void setMultiSamples(int multiSamples) {
        if (multiSamples <= 0) {
            throw new IllegalArgumentException("multiSamples must be > 0");
        }
        if (this.getData(0) != null) {
            throw new IllegalArgumentException("Cannot upload data as multisample texture");
        }
        if (this.hasMipmaps()) {
            throw new IllegalArgumentException("Multisample textures do not support mipmaps");
        }
        this.multiSamples = multiSamples;
    }

    public void setData(ArrayList<ByteBuffer> data) {
        this.data = data;
        this.setUpdateNeeded();
    }

    public void setData(ByteBuffer data) {
        this.data = new ArrayList(1);
        this.data.add(data);
        this.setUpdateNeeded();
    }

    public void addData(ByteBuffer data) {
        if (this.data == null) {
            this.data = new ArrayList(1);
        }
        this.data.add(data);
        this.setUpdateNeeded();
    }

    public void setData(int index, ByteBuffer data) {
        if (index >= 0) {
            while (this.data.size() <= index) {
                this.data.add(null);
            }
        } else {
            throw new IllegalArgumentException("index must be greater than or equal to 0.");
        }
        this.data.set(index, data);
        this.setUpdateNeeded();
    }

    @Deprecated
    public void setEfficentData(Object efficientData) {
    }

    @Deprecated
    public Object getEfficentData() {
        return null;
    }

    public void setMipMapSizes(int[] mipMapSizes) {
        if (mipMapSizes != null && mipMapSizes.length <= 1) {
            mipMapSizes = null;
        }
        this.mipMapSizes = mipMapSizes;
        if (mipMapSizes != null) {
            this.needGeneratedMips = false;
            this.mipsWereGenerated = false;
        } else {
            this.needGeneratedMips = true;
            this.mipsWereGenerated = false;
        }
        this.setUpdateNeeded();
    }

    public void setHeight(int height) {
        this.height = height;
        this.setUpdateNeeded();
    }

    public void setDepth(int depth) {
        this.depth = depth;
        this.setUpdateNeeded();
    }

    public void setWidth(int width) {
        this.width = width;
        this.setUpdateNeeded();
    }

    public void setFormat(Format format) {
        if (format == null) {
            throw new NullPointerException("format may not be null.");
        }
        this.format = format;
        this.setUpdateNeeded();
    }

    public Format getFormat() {
        return this.format;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public List<ByteBuffer> getData() {
        return this.data;
    }

    public ByteBuffer getData(int index) {
        if (this.data.size() > index) {
            return this.data.get(index);
        }
        return null;
    }

    public boolean hasMipmaps() {
        return this.mipMapSizes != null;
    }

    public int[] getMipMapSizes() {
        return this.mipMapSizes;
    }

    public void setColorSpace(ColorSpace colorSpace) {
        this.colorSpace = colorSpace;
    }

    public ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[size=").append(this.width).append("x").append(this.height);
        if (this.depth > 1) {
            sb.append("x").append(this.depth);
        }
        sb.append(", format=").append(this.format.name());
        if (this.hasMipmaps()) {
            sb.append(", mips");
        }
        if (this.getId() >= 0) {
            sb.append(", id=").append(this.id);
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Image)) {
            return false;
        }
        Image that = (Image)other;
        if (this.getFormat() != that.getFormat()) {
            return false;
        }
        if (this.getWidth() != that.getWidth()) {
            return false;
        }
        if (this.getHeight() != that.getHeight()) {
            return false;
        }
        if (this.getData() != null && !this.getData().equals(that.getData())) {
            return false;
        }
        if (this.getData() == null && that.getData() != null) {
            return false;
        }
        if (this.getMipMapSizes() != null && !Arrays.equals(this.getMipMapSizes(), that.getMipMapSizes())) {
            return false;
        }
        if (this.getMipMapSizes() == null && that.getMipMapSizes() != null) {
            return false;
        }
        return this.getMultiSamples() == that.getMultiSamples();
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.format != null ? this.format.hashCode() : 0);
        hash = 97 * hash + this.width;
        hash = 97 * hash + this.height;
        hash = 97 * hash + this.depth;
        hash = 97 * hash + Arrays.hashCode(this.mipMapSizes);
        hash = 97 * hash + (this.data != null ? this.data.hashCode() : 0);
        hash = 97 * hash + this.multiSamples;
        return hash;
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.format, "format", Format.RGBA8);
        capsule.write(this.width, "width", 0);
        capsule.write(this.height, "height", 0);
        capsule.write(this.depth, "depth", 0);
        capsule.write(this.mipMapSizes, "mipMapSizes", (int[])null);
        capsule.write(this.multiSamples, "multiSamples", 1);
        capsule.writeByteBufferArrayList(this.data, "data", null);
        capsule.write(this.colorSpace, "colorSpace", null);
    }

    @Override
    public void read(JmeImporter e) throws IOException {
        InputCapsule capsule = e.getCapsule(this);
        this.format = capsule.readEnum("format", Format.class, Format.RGBA8);
        this.width = capsule.readInt("width", 0);
        this.height = capsule.readInt("height", 0);
        this.depth = capsule.readInt("depth", 0);
        this.mipMapSizes = capsule.readIntArray("mipMapSizes", null);
        this.multiSamples = capsule.readInt("multiSamples", 1);
        this.data = capsule.readByteBufferArrayList("data", null);
        this.colorSpace = capsule.readEnum("colorSpace", ColorSpace.class, null);
        if (this.mipMapSizes != null) {
            this.needGeneratedMips = false;
            this.mipsWereGenerated = true;
        }
    }

    public static enum Format {
        Alpha8(8),
        Reserved1(0),
        Luminance8(8),
        Reserved2(0),
        Luminance16F(16, true),
        Luminance32F(32, true),
        Luminance8Alpha8(16),
        Reserved3(0),
        Luminance16FAlpha16F(32, true),
        Reserved4(0),
        Reserved5(0),
        BGR8(24),
        RGB8(24),
        Reserved6(0),
        Reserved7(0),
        RGB565(16),
        Reserved8(0),
        RGB5A1(16),
        RGBA8(32),
        ABGR8(32),
        ARGB8(32),
        BGRA8(32),
        Reserved9(0),
        DXT1(4, false, true, false),
        DXT1A(4, false, true, false),
        DXT3(8, false, true, false),
        DXT5(8, false, true, false),
        Reserved10(0),
        Depth(0, true, false, false),
        Depth16(16, true, false, false),
        Depth24(24, true, false, false),
        Depth32(32, true, false, false),
        Depth32F(32, true, false, true),
        RGB16F_to_RGB111110F(48, true),
        RGB111110F(32, true),
        RGB16F_to_RGB9E5(48, true),
        RGB9E5(32, true),
        RGB16F(48, true),
        RGBA16F(64, true),
        RGB32F(96, true),
        RGBA32F(128, true),
        Reserved11(0),
        Depth24Stencil8(32, true, false, false),
        Reserved12(0),
        ETC1(4, false, true, false),
        R8I(8),
        R8UI(8),
        R16I(16),
        R16UI(16),
        R32I(32),
        R32UI(32),
        RG8I(16),
        RG8UI(16),
        RG16I(32),
        RG16UI(32),
        RG32I(64),
        RG32UI(64),
        RGB8I(24),
        RGB8UI(24),
        RGB16I(48),
        RGB16UI(48),
        RGB32I(96),
        RGB32UI(96),
        RGBA8I(32),
        RGBA8UI(32),
        RGBA16I(64),
        RGBA16UI(64),
        RGBA32I(128),
        RGBA32UI(128);

        private int bpp;
        private boolean isDepth;
        private boolean isCompressed;
        private boolean isFloatingPoint;

        private Format(int bpp) {
            this.bpp = bpp;
        }

        private Format(int bpp, boolean isFP) {
            this(bpp);
            this.isFloatingPoint = isFP;
        }

        private Format(int bpp, boolean isDepth, boolean isCompressed, boolean isFP) {
            this(bpp, isFP);
            this.isDepth = isDepth;
            this.isCompressed = isCompressed;
        }

        public int getBitsPerPixel() {
            return this.bpp;
        }

        public boolean isDepthFormat() {
            return this.isDepth;
        }

        boolean isDepthStencilFormat() {
            return this == Depth24Stencil8;
        }

        public boolean isCompressed() {
            return this.isCompressed;
        }

        public boolean isFloatingPont() {
            return this.isFloatingPoint;
        }
    }
}

