/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents.simplecorrelator;

import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.CellEditor;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import rs.co.ast.aspen.gui.module.securityevents.simplecorrelator.ActionSpinnerNodeData;

public class EditorJspinner
extends JPanel
implements CellEditor {
    private List listeners = new ArrayList();
    private ActionSpinnerNodeData node;
    private JSpinner spinner = new JSpinner();
    private JLabel label;

    public EditorJspinner() {
        this.spinner.addChangeListener(e -> {
            if (this.stopCellEditing()) {
                this.fireEditingStopped();
            }
        });
        this.label = new JLabel(new ImageIcon(this.getClass().getResource("/application_form_edit.png")));
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setVgap(0);
        flowLayout.setHgap(0);
        this.setBackground(UIManager.getColor("Tree.background"));
        this.setLayout(flowLayout);
        this.add(this.label);
        this.add(this.spinner);
    }

    public ActionSpinnerNodeData getNode() {
        return this.node;
    }

    public void setNode(ActionSpinnerNodeData node) {
        this.node = node;
        this.spinner.setModel(new SpinnerNumberModel(node.getValue(), node.getMinValue(), node.getMaxValue(), node.getStepSize()));
        this.label.setText(node.getProperty());
    }

    @Override
    public Object getCellEditorValue() {
        return this.node;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return anEvent == null || anEvent instanceof MouseEvent && ((MouseEvent)anEvent).isMetaDown();
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.node.setValue((Integer)this.spinner.getValue());
        return true;
    }

    @Override
    public void cancelCellEditing() {
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    protected void fireEditingStopped() {
        if (this.listeners.size() > 0) {
            ChangeEvent ce = new ChangeEvent(this);
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                ((CellEditorListener)this.listeners.get(i)).editingStopped(ce);
            }
        }
    }
}

