/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.centralized.api.manager.savedscript;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.SavedScript;
import rs.co.ast.aspen.api.service.SavedScriptType;
import rs.co.ast.aspen.api.service.Script;
import rs.co.ast.aspen.gui.module.centralized.api.manager.savedscript.ScriptComparatorByName;
import rs.co.ast.aspen.gui.module.centralized.api.manager.savedscript.ScriptComparatorByOrder;

public class ScriptEditorTableModel
extends AbstractTableModel {
    private List<SavedScript> scripts;
    private final Map<SavedScriptType, List<SavedScript>> scriptsOfType = new HashMap<SavedScriptType, List<SavedScript>>();
    private final Map<String, Map<SavedScriptType, List<SavedScript>>> scriptsOfServerAndType = new HashMap<String, Map<SavedScriptType, List<SavedScript>>>();
    private List<String> servers = new ArrayList<String>();

    public List<SavedScript> sortScriptsByOrder(String server, SavedScriptType type) {
        List<SavedScript> s = this.getScriptsByServer(server, type);
        if (s != null) {
            ArrayList<SavedScript> list = new ArrayList<SavedScript>();
            list.addAll(s);
            this.scripts = list;
            Collections.sort(this.scripts, new ScriptComparatorByOrder());
            this.fireTableDataChanged();
            return list;
        }
        return new ArrayList<SavedScript>();
    }

    public List<SavedScript> sortScriptsByName(String server, SavedScriptType type) {
        List<SavedScript> s = this.getScriptsByServer(server, type);
        if (s != null) {
            ArrayList<SavedScript> list = new ArrayList<SavedScript>();
            list.addAll(s);
            this.scripts = list;
            Collections.sort(this.scripts, new ScriptComparatorByName());
            this.fireTableDataChanged();
            return list;
        }
        return new ArrayList<SavedScript>();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Script.class;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int column) {
        return NbBundle.getMessage(ScriptEditorTableModel.class, (String)"ScriptEditorTopComponent.tScripts.col0.title");
    }

    public void setData(Collection<SavedScript> scripts) {
        this.scripts = (List)scripts;
        this.servers.clear();
        this.scriptsOfType.clear();
        this.scriptsOfServerAndType.clear();
        this.scriptsOfServerAndType.clear();
        this.sortByServerAndType();
        this.getScriptsByServer("All", SavedScriptType.ROUTING);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.scripts != null ? this.scripts.size() : 0;
    }

    public Map<SavedScriptType, List<SavedScript>> getScriptsOfType() {
        return this.scriptsOfType;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < this.scripts.size()) {
            return this.scripts.get(rowIndex);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public boolean scriptAlreadyExist(String name, SavedScriptType type) {
        List<SavedScript> scriptNames = this.scriptsOfType.get(type);
        return scriptNames.stream().anyMatch(script -> script.getName().equals(name));
    }

    private List<SavedScript> getScriptsByServer(String server, SavedScriptType type) {
        boolean readAll = false;
        if (server != null) {
            if (server.equals("All")) {
                readAll = true;
            }
            Map<SavedScriptType, List<SavedScript>> scriptsOfTypeByServer = this.scriptsOfServerAndType.get(server);
            return this.getScriptsByType(readAll, type, scriptsOfTypeByServer);
        }
        return Collections.EMPTY_LIST;
    }

    private List<SavedScript> getScriptsByType(boolean readAll, SavedScriptType type, Map<SavedScriptType, List<SavedScript>> scriptsOfTypeByServer) {
        this.scripts = readAll ? this.scriptsOfType.get(type) : scriptsOfTypeByServer.get(type);
        this.fireTableDataChanged();
        return this.scripts;
    }

    private void sortByType() {
        for (SavedScriptType t : SavedScriptType.values()) {
            ArrayList<SavedScript> list = new ArrayList<SavedScript>();
            for (SavedScript s : this.scripts) {
                if (!s.getType().equals((Object)t)) continue;
                list.add(s);
            }
            this.scriptsOfType.put(t, list);
        }
    }

    private void sortByServerAndType() {
        for (SavedScriptType t : SavedScriptType.values()) {
            ArrayList<SavedScript> list = new ArrayList<SavedScript>();
            for (SavedScript s : this.scripts) {
                if (s.getOriginIp() != null && !this.servers.contains(s.getOriginIp())) {
                    this.servers.add(s.getOriginIp());
                }
                if (!s.getType().equals((Object)t)) continue;
                list.add(s);
            }
            this.scriptsOfType.put(t, list);
        }
        for (String serverIp : this.servers) {
            HashMap mapScriptByType = new HashMap();
            for (SavedScriptType t : SavedScriptType.values()) {
                ArrayList<SavedScript> listSS = new ArrayList<SavedScript>();
                for (SavedScript ss : this.scripts) {
                    if (ss.getOriginIp() == null || !ss.getOriginIp().equals(serverIp) || !ss.getType().equals((Object)t)) continue;
                    listSS.add(ss);
                }
                mapScriptByType.put(t, listSS);
            }
            this.scriptsOfServerAndType.put(serverIp, mapScriptByType);
        }
    }

    public SavedScript getScriptByRow(int row) {
        SavedScript retScript = null;
        if (row >= 0 && row < this.scripts.size()) {
            retScript = this.scripts.get(row);
        }
        return retScript;
    }

    public int getRowByScriptName(String scriptName) {
        int ret = -1;
        for (int i = 0; i < this.scripts.size(); ++i) {
            if (!this.scripts.get(i).getName().equalsIgnoreCase(scriptName)) continue;
            ret = i;
        }
        return ret;
    }

    public List<SavedScript> getAllScripts() {
        return this.scripts;
    }

    public List<String> getServers() {
        return this.servers;
    }
}

