/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.centralized.api.manager.savedscript;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;
import org.fife.ui.rsyntaxtextarea.folding.FoldParserManager;
import org.fife.ui.rsyntaxtextarea.folding.JsonFoldParser;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.painter.BusyPainter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiErrorMessage;
import rs.co.ast.aspen.api.service.ApiResponse;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ListSavedScriptsResponse;
import rs.co.ast.aspen.api.service.ModuleVersionUtils;
import rs.co.ast.aspen.api.service.SavedScript;
import rs.co.ast.aspen.api.service.SavedScriptType;
import rs.co.ast.aspen.api.service.Script;
import rs.co.ast.aspen.api.service.ScriptModelChanged;
import rs.co.ast.aspen.gui.module.centralized.api.manager.savedscript.JavaScriptFileFilter;
import rs.co.ast.aspen.gui.module.centralized.api.manager.savedscript.ScriptEditorTableModel;
import rs.co.ast.aspen.gui.module.centralized.api.manager.savedscript.ScriptEditorTableRenderer;
import rs.co.ast.aspen.gui.module.centralized.api.manager.savedscript.ScriptTypeComboBoxModel;
import rs.co.ast.aspen.gui.module.centralized.api.manager.savedscript.ScriptsZipUtils;
import rs.co.ast.aspen.gui.module.centralized.api.manager.savedscript.SearchResultsTopComponent;
import rs.co.ast.aspen.gui.module.centralized.api.manager.savedscript.VisualizationTokenMaker;

@TopComponent.Description(preferredID="CentralizedApiSavedScriptManagerTopComponent", iconBase="script.png", persistenceType=2)
public final class CentralizedApiSavedScriptManagerTopComponent
extends TopComponent {
    private static final Logger LOGGER = Logger.getLogger(CentralizedApiSavedScriptManagerTopComponent.class.getName());
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private ScriptEditorTableModel tableModel = new ScriptEditorTableModel();
    private final InstanceContent ic = new InstanceContent();
    private Collection<SavedScript> allScripts;
    private RSyntaxTextArea taScriptText;
    private int selectedRow = 0;
    private int caretPosition = 0;
    private boolean onSave = false;
    private ScriptTypeComboBoxModel scriptTypeModel = new ScriptTypeComboBoxModel();
    private final ScheduledExecutorService scriptsUpdater = Executors.newSingleThreadScheduledExecutor();
    private DefaultComboBoxModel<String> serverComboboxModel = new DefaultComboBoxModel();
    private JButton bExport;
    private JButton bExportAll;
    private JButton bRefresh;
    private JButton bSearchAllScripts;
    private JComboBox cbScriptType;
    private JComboBox<String> cbServer;
    private JPanel cp;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JXBusyLabel lLoading;
    private JLabel lType;
    private JMenuItem miDelete;
    private JMenuItem miDeleteAll;
    private JMenuItem miSortByName;
    private JPopupMenu pmOperations;
    private JTable tScripts;
    private JTextField tfSearch;
    ActionListener cbServerActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SavedScriptType scriptType = CentralizedApiSavedScriptManagerTopComponent.this.scriptTypeModel.getSelectedItem(CentralizedApiSavedScriptManagerTopComponent.this.scriptTypeModel.getSelectedIndex());
            String server = (String)CentralizedApiSavedScriptManagerTopComponent.this.cbServer.getSelectedItem();
            System.out.println("Selected " + server);
            CentralizedApiSavedScriptManagerTopComponent.this.refreshTable(server, scriptType);
            CentralizedApiSavedScriptManagerTopComponent.this.resetScriptText();
            switch (scriptType) {
                case CORRELATION: 
                case ROUTING: 
                case NOTIFICATION_PREPROCESSING: 
                case SCHEDULED: 
                case UTILITY_FUNCTIONS: {
                    CentralizedApiSavedScriptManagerTopComponent.this.taScriptText.setSyntaxEditingStyle("text/javascript");
                    break;
                }
                case VISUALISATION_CONFIGURATION: 
                case VISUALISATION_RULESET: {
                    CentralizedApiSavedScriptManagerTopComponent.this.taScriptText.setSyntaxEditingStyle("text/visscript");
                }
            }
        }
    };

    public CentralizedApiSavedScriptManagerTopComponent() {
        LOGGER.info(String.format("%s version: %s", ModuleVersionUtils.getModuleDisplayName((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.APIMANAGER), ModuleVersionUtils.getModuleVersion((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.APIMANAGER)));
        this.initComponents();
        this.setName(NbBundle.getMessage(CentralizedApiSavedScriptManagerTopComponent.class, (String)"CTL_CentralizedApiSavedScriptManagerAction"));
        this.setToolTipText(NbBundle.getMessage(CentralizedApiSavedScriptManagerTopComponent.class, (String)"HINT_CentralizedApiSavedScriptManagerAction"));
        this.associateLookup((Lookup)new AbstractLookup((AbstractLookup.Content)this.ic));
        this.taScriptText = new RSyntaxTextArea(20, 60);
        FoldParserManager.get().addFoldParserMapping("text/visscript", (FoldParser)new JsonFoldParser());
        AbstractTokenMakerFactory atmf = (AbstractTokenMakerFactory)TokenMakerFactory.getDefaultInstance();
        atmf.putMapping("text/visscript", VisualizationTokenMaker.class.getName(), ((Object)((Object)this)).getClass().getClassLoader());
        this.taScriptText.setTabSize(4);
        this.taScriptText.setCodeFoldingEnabled(true);
        SyntaxScheme scheme = this.taScriptText.getSyntaxScheme();
        scheme.getStyle((int)10).foreground = new Color(153, 0, 0);
        scheme.getStyle((int)6).foreground = new Color(68, 85, 136);
        scheme.getStyle((int)7).foreground = new Color(0, 128, 128);
        scheme.getStyle((int)17).foreground = new Color(153, 0, 115);
        scheme.getStyle((int)1).foreground = new Color(0, 128, 0);
        scheme.getStyle((int)22).foreground = Color.DARK_GRAY;
        this.taScriptText.setSyntaxEditingStyle("text/javascript");
        Font font = this.taScriptText.getFontForTokenType(22);
        scheme.getStyle((int)22).font = font = font.deriveFont(1);
        RTextScrollPane sp = new RTextScrollPane((RTextArea)this.taScriptText);
        this.cp.add((Component)sp);
        this.disableButtons();
        this.taScriptText.getCaret().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!CentralizedApiSavedScriptManagerTopComponent.this.onSave) {
                    CentralizedApiSavedScriptManagerTopComponent.this.caretPosition = CentralizedApiSavedScriptManagerTopComponent.this.taScriptText.getCaret().getDot();
                }
            }
        });
        this.tScripts.setDefaultRenderer(Script.class, new ScriptEditorTableRenderer());
        this.tScripts.setSelectionMode(2);
        this.tScripts.setRowSelectionAllowed(true);
        this.tScripts.setFillsViewportHeight(true);
        this.tScripts.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (CentralizedApiSavedScriptManagerTopComponent.this.tScripts.getSelectedRow() > -1) {
                    CentralizedApiSavedScriptManagerTopComponent.this.selectedRow = CentralizedApiSavedScriptManagerTopComponent.this.tScripts.getSelectedRow();
                    SavedScript script = (SavedScript)CentralizedApiSavedScriptManagerTopComponent.this.tableModel.getValueAt(CentralizedApiSavedScriptManagerTopComponent.this.tScripts.getSelectedRow(), 0);
                    if (script != null) {
                        CentralizedApiSavedScriptManagerTopComponent.this.setScriptText(script.getScript());
                        CentralizedApiSavedScriptManagerTopComponent.this.taScriptText.getCaret().setDot(CentralizedApiSavedScriptManagerTopComponent.this.caretPosition);
                        CentralizedApiSavedScriptManagerTopComponent.this.taScriptText.requestFocus();
                        CentralizedApiSavedScriptManagerTopComponent.this.onSave = false;
                        CentralizedApiSavedScriptManagerTopComponent.this.miDelete.setEnabled(true);
                        CentralizedApiSavedScriptManagerTopComponent.this.miDeleteAll.setEnabled(true);
                        CentralizedApiSavedScriptManagerTopComponent.this.bExport.setEnabled(true);
                    }
                }
            }
        });
        this.tScripts.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    int row = CentralizedApiSavedScriptManagerTopComponent.this.tScripts.rowAtPoint(e.getPoint());
                    int column = CentralizedApiSavedScriptManagerTopComponent.this.tScripts.columnAtPoint(e.getPoint());
                    if (!CentralizedApiSavedScriptManagerTopComponent.this.tScripts.isRowSelected(row)) {
                        if (row > -1) {
                            CentralizedApiSavedScriptManagerTopComponent.this.tScripts.setRowSelectionInterval(row, row);
                        }
                        CentralizedApiSavedScriptManagerTopComponent.this.tScripts.changeSelection(row, column, false, false);
                    }
                    CentralizedApiSavedScriptManagerTopComponent.this.pmOperations.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.cbScriptType.setModel(this.scriptTypeModel);
        this.cbScriptType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CentralizedApiSavedScriptManagerTopComponent.this.disableButtons();
            }
        });
        this.cbServer.setModel(this.serverComboboxModel);
        this.cbScriptType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CentralizedApiSavedScriptManagerTopComponent.this.disableButtons();
            }
        });
        this.taScriptText.setEditable(false);
        ActionListener findLisener = event -> {
            this.tfSearch.requestFocus();
            this.tfSearch.setCaretPosition(0);
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(70, 2, false);
        this.taScriptText.registerKeyboardAction(findLisener, "Find", stroke, 0);
        ActionListener findInAllFilesLisener = event -> this.searchInAllFiles();
        KeyStroke strokeFiles = KeyStroke.getKeyStroke(70, 8, false);
        this.registerKeyboardAction(findInAllFilesLisener, "FindInAll", strokeFiles, 1);
    }

    private void initComponents() {
        this.pmOperations = new JPopupMenu();
        this.miDelete = new JMenuItem();
        this.miDeleteAll = new JMenuItem();
        this.miSortByName = new JMenuItem();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.lType = new JLabel();
        this.cbScriptType = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.tScripts = new JTable();
        this.bRefresh = new JButton();
        this.lLoading = new JXBusyLabel();
        this.bSearchAllScripts = new JButton();
        this.jLabel2 = new JLabel();
        this.cbServer = new JComboBox();
        this.jPanel2 = new JPanel();
        this.bExport = new JButton();
        this.cp = new JPanel();
        this.jLabel1 = new JLabel();
        this.tfSearch = new JTextField();
        this.bExportAll = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.miDelete, (String)NbBundle.getMessage(CentralizedApiSavedScriptManagerTopComponent.class, (String)"CentralizedApiSavedScriptManagerTopComponent.miDelete.text"));
        this.miDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiSavedScriptManagerTopComponent.this.miDeleteActionPerformed(evt);
            }
        });
        this.pmOperations.add(this.miDelete);
        Mnemonics.setLocalizedText((AbstractButton)this.miDeleteAll, (String)NbBundle.getMessage(CentralizedApiSavedScriptManagerTopComponent.class, (String)"CentralizedApiSavedScriptManagerTopComponent.miDeleteAll.text"));
        this.miDeleteAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiSavedScriptManagerTopComponent.this.miDeleteAllActionPerformed(evt);
            }
        });
        this.pmOperations.add(this.miDeleteAll);
        Mnemonics.setLocalizedText((AbstractButton)this.miSortByName, (String)NbBundle.getMessage(CentralizedApiSavedScriptManagerTopComponent.class, (String)"CentralizedApiSavedScriptManagerTopComponent.miSortByName.text"));
        this.miSortByName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiSavedScriptManagerTopComponent.this.miSortByNameActionPerformed(evt);
            }
        });
        this.pmOperations.add(this.miSortByName);
        this.jSplitPane1.setDividerLocation(300);
        this.jSplitPane1.setResizeWeight(0.2);
        this.jSplitPane1.setMinimumSize(new Dimension(250, 0));
        this.jPanel1.setMinimumSize(new Dimension(270, 0));
        this.jPanel1.setPreferredSize(new Dimension(270, 501));
        this.lType.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.lType, (String)NbBundle.getMessage(CentralizedApiSavedScriptManagerTopComponent.class, (String)"CentralizedApiSavedScriptManagerTopComponent.lType.text"));
        this.cbScriptType.setFont(new Font("Dialog", 0, 12));
        this.cbScriptType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiSavedScriptManagerTopComponent.this.cbScriptTypeActionPerformed(evt);
            }
        });
        this.tScripts.setModel(this.tableModel);
        this.tScripts.setComponentPopupMenu(this.pmOperations);
        this.tScripts.setGridColor(new Color(217, 217, 217));
        this.tScripts.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.tScripts);
        this.bRefresh.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/arrow_refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bRefresh, (String)NbBundle.getMessage(CentralizedApiSavedScriptManagerTopComponent.class, (String)"CentralizedApiSavedScriptManagerTopComponent.bRefresh.text"));
        this.bRefresh.setMaximumSize(new Dimension(50, 15));
        this.bRefresh.setMinimumSize(new Dimension(50, 15));
        this.bRefresh.setPreferredSize(new Dimension(50, 15));
        this.bRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiSavedScriptManagerTopComponent.this.bRefreshActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lLoading, (String)NbBundle.getMessage(CentralizedApiSavedScriptManagerTopComponent.class, (String)"CentralizedApiSavedScriptManagerTopComponent.lLoading.text"));
        this.lLoading.setDirection(BusyPainter.Direction.RIGHT);
        this.bSearchAllScripts.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/magnifier.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bSearchAllScripts, (String)NbBundle.getMessage(CentralizedApiSavedScriptManagerTopComponent.class, (String)"CentralizedApiSavedScriptManagerTopComponent.bSearchAllScripts.text"));
        this.bSearchAllScripts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiSavedScriptManagerTopComponent.this.bSearchAllScriptsActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CentralizedApiSavedScriptManagerTopComponent.class, (String)"CentralizedApiSavedScriptManagerTopComponent.jLabel2.text"));
        this.cbServer.setModel(new DefaultComboBoxModel<String>(new String[]{"All", "197.168.2.2", "etc"}));
        this.cbServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiSavedScriptManagerTopComponent.this.cbServerActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lType, -1, 179, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bSearchAllScripts, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.lLoading, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bRefresh, -2, 32, -2)).addComponent(this.cbScriptType, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbServer, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent((Component)this.lLoading, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.bSearchAllScripts, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.bRefresh, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lType, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbScriptType, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.cbServer, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 443, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.bExport.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bExport, (String)NbBundle.getMessage(CentralizedApiSavedScriptManagerTopComponent.class, (String)"CentralizedApiSavedScriptManagerTopComponent.bExport.text"));
        this.bExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiSavedScriptManagerTopComponent.this.bExportActionPerformed(evt);
            }
        });
        this.cp.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CentralizedApiSavedScriptManagerTopComponent.class, (String)"CentralizedApiSavedScriptManagerTopComponent.jLabel1.text"));
        this.tfSearch.setText(NbBundle.getMessage(CentralizedApiSavedScriptManagerTopComponent.class, (String)"CentralizedApiSavedScriptManagerTopComponent.tfSearch.text"));
        this.tfSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiSavedScriptManagerTopComponent.this.tfSearchActionPerformed(evt);
            }
        });
        this.bExportAll.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bExportAll, (String)NbBundle.getMessage(CentralizedApiSavedScriptManagerTopComponent.class, (String)"CentralizedApiSavedScriptManagerTopComponent.bExportAll.text"));
        this.bExportAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CentralizedApiSavedScriptManagerTopComponent.this.bExportAllActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfSearch)).addGroup(jPanel2Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.bExportAll, -1, 98, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bExport, -1, 127, Short.MAX_VALUE).addGap(709, 709, 709)).addComponent(this.cp, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.tfSearch, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cp, -1, 471, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bExport).addComponent(this.bExportAll)).addContainerGap()));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 1281, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void cbScriptTypeActionPerformed(ActionEvent evt) {
        SavedScriptType scriptType = this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex());
        String server = (String)this.cbServer.getSelectedItem();
        this.refreshTable(server, scriptType);
        this.resetScriptText();
        switch (scriptType) {
            case CORRELATION: 
            case ROUTING: 
            case NOTIFICATION_PREPROCESSING: 
            case SCHEDULED: 
            case UTILITY_FUNCTIONS: {
                this.taScriptText.setSyntaxEditingStyle("text/javascript");
                break;
            }
            case VISUALISATION_CONFIGURATION: 
            case VISUALISATION_RULESET: {
                this.taScriptText.setSyntaxEditingStyle("text/visscript");
            }
        }
    }

    private void bExportActionPerformed(ActionEvent evt) {
        if (!this.taScriptText.getText().isEmpty()) {
            JFileChooser saveFileDialog = new JFileChooser();
            saveFileDialog.setFileFilter(new JavaScriptFileFilter());
            saveFileDialog.setAcceptAllFileFilterUsed(false);
            Script script = (Script)this.tScripts.getValueAt(this.tScripts.getSelectedRow(), 0);
            saveFileDialog.setSelectedFile(new File(script.getName() + ".js"));
            int result = saveFileDialog.showSaveDialog(WindowManager.getDefault().getMainWindow());
            if (result == 0) {
                try (FileOutputStream st = new FileOutputStream(saveFileDialog.getSelectedFile());){
                    ((OutputStream)st).write(this.taScriptText.getText().getBytes());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void miDeleteActionPerformed(ActionEvent evt) {
        if (this.tScripts.getSelectedRow() != -1) {
            int[] selectedRows = this.tScripts.getSelectedRows();
            String bodyMessage = "";
            bodyMessage = selectedRows.length > 1 ? String.format(NbBundle.getMessage(ScriptEditorTableModel.class, (String)"DeleteScriptConfirmation.message.multipleDeletions"), selectedRows.length) : NbBundle.getMessage(ScriptEditorTableModel.class, (String)"DeleteScriptConfirmation.message");
            NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)bodyMessage, NbBundle.getMessage(ScriptEditorTableModel.class, (String)"DeleteScriptConfirmation.title"), 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
                try {
                    SavedScript script = (SavedScript)this.tableModel.getValueAt(this.tScripts.getSelectedRow(), 0);
                    ApiResponse response = this.apiService.apiDeleteSavedScript(script.getId());
                    if (response.isSuccess()) {
                        this.ic.set(Collections.singletonList(new ScriptModelChanged()), null);
                        new Updater().execute();
                        this.selectedRow = this.selectedRow - 1 <= 0 ? 0 : this.selectedRow - 1;
                    } else {
                        ApiErrorMessage apiError = response.getErrorMessage();
                        LOGGER.log(Level.SEVERE, String.format("%s | %s", apiError.getErrorCode(), apiError.getMessage()));
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)apiError.getMessage(), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void tfSearchActionPerformed(ActionEvent evt) {
        this.search();
    }

    private void bExportAllActionPerformed(ActionEvent evt) {
        try {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(NbBundle.getMessage(CentralizedApiSavedScriptManagerTopComponent.class, (String)"ExportDialog.title"));
            int userSelection = fileChooser.showSaveDialog(WindowManager.getDefault().getMainWindow());
            File source = new File(ScriptsZipUtils.generateZipFileName());
            if (userSelection == 0) {
                ScriptsZipUtils.zip(this.tableModel.getScriptsOfType(), source.getAbsolutePath());
                File target = fileChooser.getSelectedFile();
                if (!target.getAbsolutePath().endsWith(".zip")) {
                    target = new File(Paths.get(target.getAbsolutePath() + ".zip", new String[0]).toString());
                }
                Files.move(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.deleteIfExists(source.toPath());
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void bRefreshActionPerformed(ActionEvent evt) {
        new Updater().execute();
    }

    private void bSearchAllScriptsActionPerformed(ActionEvent evt) {
        this.searchInAllFiles();
    }

    private void miDeleteAllActionPerformed(ActionEvent evt) {
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ScriptEditorTableModel.class, (String)"DeleteAllScriptConfirmation.message"), NbBundle.getMessage(ScriptEditorTableModel.class, (String)"DeleteAllScriptConfirmation.title"), 0);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
            try {
                ListSavedScriptsResponse response = this.apiService.apiGetAllSavedScripts();
                if (response.isSuccess()) {
                    this.ic.set(Collections.singletonList(new ScriptModelChanged()), null);
                    new Updater().execute();
                    this.selectedRow = this.selectedRow - 1 <= 0 ? 0 : this.selectedRow - 1;
                } else {
                    ApiErrorMessage apiError = response.getErrorMessage();
                    LOGGER.log(Level.SEVERE, String.format("%s | %s", apiError.getErrorCode(), apiError.getMessage()));
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)apiError.getMessage(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void miSortByNameActionPerformed(ActionEvent evt) {
        this.tableModel.sortScriptsByName((String)this.cbServer.getSelectedItem(), this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex()));
    }

    private void cbServerActionPerformed(ActionEvent evt) {
        SavedScriptType scriptType = this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex());
        String server = (String)this.cbServer.getSelectedItem();
        this.refreshTable(server, scriptType);
        this.resetScriptText();
        switch (scriptType) {
            case CORRELATION: 
            case ROUTING: 
            case NOTIFICATION_PREPROCESSING: 
            case SCHEDULED: 
            case UTILITY_FUNCTIONS: {
                this.taScriptText.setSyntaxEditingStyle("text/javascript");
                break;
            }
            case VISUALISATION_CONFIGURATION: 
            case VISUALISATION_RULESET: {
                this.taScriptText.setSyntaxEditingStyle("text/visscript");
            }
        }
    }

    public void selectAndSearchScript(String type, String scriptName, String search) {
        if (!this.scriptTypeModel.getSelectedItem().toString().equalsIgnoreCase(type)) {
            this.scriptTypeModel.setSelectedItem(type);
            this.cbScriptType.invalidate();
            this.cbScriptType.revalidate();
            this.cbScriptType.repaint();
            SavedScriptType scriptType = this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex());
            String server = (String)this.cbServer.getSelectedItem();
            this.refreshTable(server, scriptType);
        }
        int row = this.tableModel.getRowByScriptName(scriptName);
        if (this.tScripts.getSelectedRow() != row) {
            this.tScripts.setRowSelectionInterval(row, row);
        }
        this.tfSearch.setText(search);
        this.search();
    }

    private void search() {
        if (this.tfSearch.getText().isEmpty()) {
            this.taScriptText.setCaretPosition(0);
        }
        SearchContext context = new SearchContext();
        context.setSearchFor(this.tfSearch.getText());
        context.setMatchCase(false);
        context.setRegularExpression(true);
        context.setSearchForward(true);
        context.setWholeWord(false);
        context.setMarkAll(true);
        SearchEngine.find((JTextArea)this.taScriptText, (SearchContext)context);
    }

    private void searchInAllFiles() {
        ImageIcon mag = new ImageIcon(((Object)((Object)this)).getClass().getResource("/magnifier.png"));
        String searchTitle = NbBundle.getMessage(CentralizedApiSavedScriptManagerTopComponent.class, (String)"CentralizedApiManagerTopComponent.searchTitle");
        String input = (String)JOptionPane.showInputDialog((Component)((Object)this), searchTitle, searchTitle, -1, mag, null, null);
        if (input != null && !input.isEmpty()) {
            ArrayList<SavedScript> searchResults = new ArrayList<SavedScript>();
            this.allScripts.forEach(s -> {
                if (s.getScript().toLowerCase().contains(input.toLowerCase())) {
                    searchResults.add((SavedScript)s);
                }
            });
            Mode mode = WindowManager.getDefault().findMode("bottomSlidingSide");
            SearchResultsTopComponent tc = new SearchResultsTopComponent();
            tc.setSearchStringAndScripts(input, searchResults);
            mode.dockInto((TopComponent)tc);
            tc.open();
            tc.requestActive();
            tc.setDisplayName(String.format(NbBundle.getMessage(CentralizedApiSavedScriptManagerTopComponent.class, (String)"SearchResultsTopComponent.title"), input));
        }
    }

    public void componentOpened() {
        new Updater().execute();
    }

    public void componentClosed() {
        this.scriptsUpdater.shutdownNow();
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private void refreshTable(String server, SavedScriptType type) {
        if (type == SavedScriptType.VISUALISATION_CONFIGURATION || type == SavedScriptType.VISUALISATION_RULESET) {
            this.tableModel.sortScriptsByName(server, type);
        } else {
            this.tableModel.sortScriptsByOrder(server, type);
        }
    }

    private void resetScriptText() {
        this.setScriptText("");
    }

    private void disableButtons() {
        this.miDelete.setEnabled(false);
        this.miDeleteAll.setEnabled(false);
        this.bExport.setEnabled(false);
    }

    private void toggleLoading() {
        this.lLoading.setBusy(!this.lLoading.isBusy());
    }

    private void populateServerComboBox(List<String> servers) {
        this.serverComboboxModel.removeAllElements();
        this.serverComboboxModel.addElement("All");
        for (String s : servers) {
            this.serverComboboxModel.addElement(s);
        }
    }

    private void setScriptText(String text) {
        this.taScriptText.setText(text);
        this.taScriptText.setCaretPosition(0);
    }

    public class Updater
    extends SwingWorker<ListSavedScriptsResponse, Void> {
        private boolean newScript;
        private String newScriptName;

        @Override
        protected ListSavedScriptsResponse doInBackground() throws Exception {
            CentralizedApiSavedScriptManagerTopComponent.this.toggleLoading();
            try {
                return CentralizedApiSavedScriptManagerTopComponent.this.apiService.apiGetAllSavedScripts();
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            try {
                ListSavedScriptsResponse response = (ListSavedScriptsResponse)this.get();
                if (response.isSuccess()) {
                    CentralizedApiSavedScriptManagerTopComponent.this.allScripts = response.getScripts();
                    CentralizedApiSavedScriptManagerTopComponent.this.tableModel.setData(CentralizedApiSavedScriptManagerTopComponent.this.allScripts);
                    CentralizedApiSavedScriptManagerTopComponent.this.populateServerComboBox(CentralizedApiSavedScriptManagerTopComponent.this.tableModel.getServers());
                    CentralizedApiSavedScriptManagerTopComponent.this.refreshTable((String)CentralizedApiSavedScriptManagerTopComponent.this.cbServer.getSelectedItem(), CentralizedApiSavedScriptManagerTopComponent.this.scriptTypeModel.getSelectedItem(CentralizedApiSavedScriptManagerTopComponent.this.scriptTypeModel.getSelectedIndex()));
                    CentralizedApiSavedScriptManagerTopComponent.this.resetScriptText();
                    CentralizedApiSavedScriptManagerTopComponent.this.disableButtons();
                    if (this.newScript) {
                        CentralizedApiSavedScriptManagerTopComponent.this.selectedRow = CentralizedApiSavedScriptManagerTopComponent.this.tableModel.getRowByScriptName(this.newScriptName);
                    }
                    if (CentralizedApiSavedScriptManagerTopComponent.this.tableModel.getRowCount() > 0 && CentralizedApiSavedScriptManagerTopComponent.this.selectedRow != -1 && CentralizedApiSavedScriptManagerTopComponent.this.selectedRow <= CentralizedApiSavedScriptManagerTopComponent.this.tableModel.getRowCount()) {
                        CentralizedApiSavedScriptManagerTopComponent.this.tScripts.setRowSelectionInterval(CentralizedApiSavedScriptManagerTopComponent.this.selectedRow, CentralizedApiSavedScriptManagerTopComponent.this.selectedRow);
                    }
                } else {
                    ApiErrorMessage errorMessage = response.getErrorMessage();
                    LOGGER.log(Level.SEVERE, String.format("%s | %s", errorMessage.getErrorCode(), errorMessage.getMessage()));
                    NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)errorMessage.getMessage(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                CentralizedApiSavedScriptManagerTopComponent.this.toggleLoading();
            }
        }

        public void setNewScript(boolean newScript) {
            this.newScript = newScript;
        }

        public void setNewScriptName(String newScriptName) {
            this.newScriptName = newScriptName;
        }
    }
}

