/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.login;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.modules.ModuleInstall;
import org.openide.modules.Places;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceExceptionMessage;
import rs.co.ast.aspen.api.service.ApiServiceExceptionType;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.gui.module.login.LoginBannerPanel;
import rs.co.ast.aspen.gui.module.login.LoginPanel;

public class Installer
extends ModuleInstall
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(Installer.class.getName());
    private DialogDescriptor des;
    private Dialog d;
    private DialogDescriptor desB;
    private final LoginPanel loginPanel = new LoginPanel();
    private final LoginBannerPanel loginBannerPanel = new LoginBannerPanel();
    private boolean okClicked = false;
    private final String requiredJavaVersion = "1.8";
    private final String requiredJavaVendor = "Oracle";

    public Installer() {
        this.des = new DialogDescriptor((Object)this.loginPanel, NbBundle.getMessage(Installer.class, (String)"LoginDialog.title"), true, (ActionListener)this);
        this.des.setClosingOptions(new Object[0]);
        this.d = DialogDisplayer.getDefault().createDialog(this.des);
        this.d.setResizable(false);
        this.d.setAlwaysOnTop(true);
        if (!Runtime.class.getPackage().getSpecificationVendor().contains("Oracle") || !Runtime.class.getPackage().isCompatibleWith("1.8")) {
            JOptionPane.showMessageDialog(this.loginPanel, String.format(NbBundle.getMessage(Installer.class, (String)"Login.java.version.vendor"), "\n", Runtime.class.getPackage().getSpecificationVendor(), Runtime.class.getPackage().getSpecificationVersion()), "Warning message", 2);
        }
        this.d.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                if (!Installer.this.okClicked) {
                    System.exit(0);
                }
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
    }

    public void restored() {
        this.d.setVisible(true);
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                StringBuilder title = new StringBuilder();
                String mainTitle = WindowManager.getDefault().getMainWindow().getTitle();
                mainTitle = mainTitle.replaceAll("[0-9]", "");
                title.append(mainTitle);
                title.append(": ");
                String username = Installer.this.loginPanel.getUsername();
                String host = Installer.this.loginPanel.getServer().replace("http://", "").replace("https://", "");
                boolean ssl = Installer.this.loginPanel.getSsl();
                if (ssl) {
                    title.append("https://");
                } else {
                    title.append("http://");
                }
                title.append(username);
                title.append("@");
                title.append(host);
                title.append(" - userdir: ");
                title.append(Places.getUserDirectory().toString());
                LOGGER.info(String.format("TITLE: %s", title.toString()));
                WindowManager.getDefault().getMainWindow().setTitle(title.toString());
            }
        });
    }

    private void doLogin() throws ApiServiceException_Exception {
        ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
        apiService.logoff();
        String username = this.loginPanel.getUsername();
        String password = this.loginPanel.getPassword();
        boolean ssl = this.loginPanel.getSsl();
        String host = this.loginPanel.getServer();
        if (!host.contains("://")) {
            host = (ssl ? "https://" : "http://") + host;
        }
        apiService.login(host, username, password);
        NbPreferences.forModule(LoginPanel.class).put("server_" + host, host);
        NbPreferences.forModule(LoginPanel.class).put("lastUsedServer", host);
        NbPreferences.forModule(LoginPanel.class).putBoolean("use_ssl", ssl);
    }

    private void exit() {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                LifecycleManager.getDefault().exit();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == DialogDescriptor.OK_OPTION) {
            try {
                this.okClicked = true;
                if (!this.loginBannerPanel.isDontShow()) {
                    this.displayLoginBannerPanel();
                }
                if (this.loginBannerPanel.isIAgree()) {
                    this.doLogin();
                    this.des.setClosingOptions(null);
                }
            }
            catch (ApiServiceException_Exception ex) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ApiServiceExceptionMessage.forType((ApiServiceExceptionType)ex.getFaultInfo().getType(), null));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            }
            catch (RuntimeException ex) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ex.getLocalizedMessage());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            }
        } else {
            this.exit();
            this.des.setClosingOptions(null);
        }
    }

    private void displayLoginBannerPanel() {
        this.desB = new DialogDescriptor((Object)this.loginBannerPanel, NbBundle.getMessage(Installer.class, (String)"LoginDialog.warningTitle"), true, e -> {
            if (e.getSource() == DialogDescriptor.OK_OPTION) {
                NbPreferences.forModule(LoginPanel.class).putBoolean("IAgree", this.loginBannerPanel.isIAgree());
                NbPreferences.forModule(LoginPanel.class).putBoolean("DontShow", this.loginBannerPanel.isDontShow());
            }
        });
        this.desB.setValid(this.loginBannerPanel.isIAgree());
        this.loginBannerPanel.setDialogDescriptor(this.desB);
        this.d = DialogDisplayer.getDefault().createDialog(this.desB);
        this.d.setResizable(false);
        this.d.setVisible(true);
    }
}

