/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.export;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.netbeans.api.visual.export.WidgetPolygonalCoordinates;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.modules.visual.export.Scene2Image;

public final class SceneExporter {
    private SceneExporter() {
    }

    public static ArrayList<WidgetPolygonalCoordinates> createImageMap(Scene scene, File file, ImageType imageType, ZoomType zoomType, boolean visibleAreaOnly, boolean selectedOnly, int quality, int width, int height, int margin) throws IOException {
        if (scene == null || file == null) {
            return null;
        }
        Scene2Image s2i = new Scene2Image(scene, file);
        s2i.createImage(imageType, zoomType, visibleAreaOnly, selectedOnly, quality, width, height, true);
        return s2i.getSceneImageMapCoordinates(margin);
    }

    public static BufferedImage createImage(Scene scene, File file, ImageType imageType, ZoomType zoomType, boolean visibleAreaOnly, boolean selectedOnly, int quality, int width, int height) throws IOException {
        if (scene == null) {
            return null;
        }
        if (!scene.isValidated()) {
            if (scene.getView() != null) {
                scene.validate();
            } else {
                BufferedImage emptyImage = new BufferedImage(1, 1, 6);
                Graphics2D emptyGraphics = emptyImage.createGraphics();
                scene.validate(emptyGraphics);
            }
        }
        Scene2Image s2i = new Scene2Image(scene, file);
        BufferedImage image = s2i.createImage(imageType, zoomType, visibleAreaOnly, selectedOnly, quality, width, height, false);
        return image;
    }

    public static enum ImageType {
        JPG,
        PNG;

    }

    public static enum ZoomType {
        CUSTOM_SIZE,
        FIT_IN_WINDOW,
        CURRENT_ZOOM_LEVEL,
        ACTUAL_SIZE;

    }
}

