/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.centralized.api.manager.savedscript;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.joda.time.DateTime;
import org.openide.util.Exceptions;
import rs.co.ast.aspen.api.service.SavedScript;
import rs.co.ast.aspen.api.service.SavedScriptType;

public class ScriptsZipUtils {
    private static final int BUFFER_SIZE = 1024;
    private static final String SCRIPT_FILE_EXTENSION = ".js";
    private static final String TEMP_DIR_PREXIX = "scripts_";
    private static List<File> fileList = new ArrayList<File>();
    private static final Logger logger = Logger.getLogger(ScriptsZipUtils.class.getName());

    public static String generateZipFileName() {
        String tmp = System.getProperty("java.io.tmpdir");
        long now = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        DateTime dt = new DateTime(now);
        sb.append(tmp);
        sb.append("/scripts_");
        sb.append(dt.getYear());
        sb.append(dt.getMonthOfYear());
        sb.append(dt.getDayOfMonth());
        sb.append("-");
        sb.append(dt.getHourOfDay());
        sb.append(dt.getMinuteOfHour());
        sb.append(".zip");
        return sb.toString();
    }

    public static void zip(Map<SavedScriptType, List<SavedScript>> scripts, String zipFile) {
        byte[] buffer = new byte[1024];
        try {
            Path mainDir = Files.createTempDirectory(TEMP_DIR_PREXIX, new FileAttribute[0]);
            for (SavedScriptType type : scripts.keySet()) {
                Path scriptTypeDir = Paths.get(mainDir.toAbsolutePath() + File.separator + type.name(), new String[0]);
                Files.createDirectory(scriptTypeDir, new FileAttribute[0]);
                for (SavedScript script : scripts.get(type)) {
                    Path scriptPath = Paths.get(scriptTypeDir.toAbsolutePath() + File.separator + script.getName() + SCRIPT_FILE_EXTENSION, new String[0]);
                    Files.createFile(scriptPath, new FileAttribute[0]);
                    PrintWriter pw = new PrintWriter(scriptPath.toFile(), "UTF-8");
                    Throwable throwable = null;
                    try {
                        pw.write(script.getScript());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (pw == null) continue;
                        if (throwable != null) {
                            try {
                                pw.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        pw.close();
                    }
                }
            }
            fileList.clear();
            ScriptsZipUtils.generateFileList(mainDir);
            FileOutputStream fos = new FileOutputStream(zipFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (File file : fileList) {
                ZipEntry ze = new ZipEntry(file.getAbsolutePath());
                zos.putNextEntry(ze);
                FileInputStream in = new FileInputStream(file);
                int len = 0;
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                in.close();
                zos.closeEntry();
            }
            zos.close();
            logger.info(fileList.toString());
            ScriptsZipUtils.deleteDirectory(mainDir.toFile());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void deleteDirectory(File file) throws IOException {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
            } else {
                String[] files;
                for (String temp : files = file.list()) {
                    File fileDelete = new File(file, temp);
                    ScriptsZipUtils.deleteDirectory(fileDelete);
                }
                if (file.list().length == 0) {
                    file.delete();
                }
            }
        } else {
            file.delete();
        }
    }

    private static void generateFileList(Path mainDir) {
        File srcDir = mainDir.toFile();
        if (srcDir.isDirectory()) {
            File[] files;
            for (File file : files = srcDir.listFiles()) {
                ScriptsZipUtils.generateFileList(file.toPath());
            }
        } else {
            fileList.add(srcDir);
        }
    }
}

