/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents.export;

import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.gui.module.securityevents.export.FetchResult;
import rs.co.ast.aspen.gui.module.securityevents.export.listeners.ProgressValueChangedSupport;

public class PDFDataSource
extends ProgressValueChangedSupport
implements JRDataSource {
    private List<SecurityEvent> logs;
    private float elapsed = 0.0f;
    private long totalSearchDuration = 0L;
    private long totalHits = 0L;
    private int position_list = -1;
    private int pageSize;

    public PDFDataSource(FetchResult result) {
        this.logs = result.getEvents();
        this.totalSearchDuration = result.getTotalSearchDuration();
        this.totalHits = result.getTotalHits();
        this.pageSize = 10000L > this.totalHits ? (int)this.totalHits : 10000;
    }

    public boolean next() throws JRException {
        this.elapsed = (float)this.totalSearchDuration - (float)this.totalSearchDuration * ((float)Math.abs(this.position_list) / (float)this.pageSize);
        this.fireProgressValueChangedEvent(this.position_list, this.position_list + 1, this.logs.size(), this.elapsed);
        return this.logs.size() > ++this.position_list;
    }

    public Object getFieldValue(JRField jrf) throws JRException {
        if (this.position_list < this.logs.size()) {
            switch (jrf.getName()) {
                case "id": {
                    return this.logs.get(this.position_list).getId();
                }
                case "timestamp": {
                    DateTime date = new DateTime((Object)this.logs.get(this.position_list).getTimestamp());
                    DateTimeFormatter dtf = ISODateTimeFormat.basicDateTimeNoMillis();
                    return date.toString(dtf);
                }
                case "what": {
                    List what = this.logs.get(this.position_list).getWhat().getEntry();
                    if (!what.isEmpty()) {
                        int count = 0;
                        StringBuilder sb = new StringBuilder();
                        sb.append("<b>WHAT</b><br/>");
                        for (SecurityEvent.What.Entry e : what) {
                            sb.append(String.format("<b>%s</b>=%s", e.getKey(), e.getValue()));
                            if (count < what.size() - 1) {
                                sb.append(",");
                            }
                            ++count;
                        }
                        return sb.toString();
                    }
                    return "";
                }
                case "when": {
                    List when = this.logs.get(this.position_list).getWhen().getEntry();
                    if (!when.isEmpty()) {
                        int count = 0;
                        StringBuilder sb = new StringBuilder();
                        sb.append("<b>WHEN</b><br/>");
                        for (SecurityEvent.When.Entry e : when) {
                            sb.append(String.format("<b>%s</b>=%s", e.getKey(), e.getValue()));
                            if (count < when.size() - 1) {
                                sb.append(",");
                            }
                            ++count;
                        }
                        return sb.toString();
                    }
                    return "";
                }
                case "where": {
                    List where = this.logs.get(this.position_list).getWhere().getEntry();
                    if (!where.isEmpty()) {
                        int count = 0;
                        StringBuilder sb = new StringBuilder();
                        sb.append("<b>WHERE</b><br/>");
                        for (SecurityEvent.Where.Entry e : where) {
                            sb.append(String.format("<b>%s</b>=%s", e.getKey(), e.getValue()));
                            if (count < where.size() - 1) {
                                sb.append(",");
                            }
                            ++count;
                        }
                        return sb.toString();
                    }
                    return "";
                }
                case "who": {
                    List who = this.logs.get(this.position_list).getWho().getEntry();
                    if (!who.isEmpty()) {
                        int count = 0;
                        StringBuilder sb = new StringBuilder();
                        sb.append("<b>WHO</b><br/>");
                        for (SecurityEvent.Who.Entry e : who) {
                            sb.append(String.format("<b>%s</b>=%s", e.getKey(), e.getValue()));
                            if (count < who.size() - 1) {
                                sb.append(",");
                            }
                            ++count;
                        }
                        return sb.toString();
                    }
                    return "";
                }
                case "extra": {
                    List extra = this.logs.get(this.position_list).getExtra().getEntry();
                    if (!extra.isEmpty()) {
                        int count = 0;
                        StringBuilder sb = new StringBuilder();
                        sb.append("<b>EXTRA</b><br/>");
                        for (SecurityEvent.Extra.Entry e : extra) {
                            sb.append(String.format("<b>%s</b>=%s", e.getKey(), e.getValue()));
                            if (count < extra.size() - 1) {
                                sb.append(",");
                            }
                            ++count;
                        }
                        return sb.toString();
                    }
                    return "";
                }
            }
        }
        return "unknown field " + jrf.getName();
    }
}

