/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.joda.time.DateTime;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.DateRange;
import rs.co.ast.aspen.api.service.RawLog;
import rs.co.ast.aspen.api.service.RawLogSimWrapper;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.gui.module.securityevents.DisplayOptions;
import rs.co.ast.aspen.gui.module.securityevents.FullscreenDisplayOptionsDisplayer;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventDetailsTopComponent;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventWrapper;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventsTableModel;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventsTableRenderer;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventsTopComponent;
import rs.co.ast.aspen.gui.module.securityevents.query.QueryManager;
import rs.co.ast.aspen.gui.module.securityevents.search.SearchExecutor;
import rs.co.ast.aspen.gui.module.securityevents.search.SkippedTaskInfo;
import rs.co.ast.aspen.gui.module.securityevents.search.TaskMonitor;

public class SecurityEventsFullScreenPanel
extends JPanel
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(SecurityEventsFullScreenPanel.class.getName());
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private SearchExecutor searchExecutor;
    private InstanceContent instanceContent = new InstanceContent();
    private Lookup selectedEvent = new AbstractLookup((AbstractLookup.Content)this.instanceContent);
    private final DisplayOptions displayOptions = new DisplayOptions();
    private final Timer autoRefreshTimer;
    private SecurityEventsTableModel tableModel = new SecurityEventsTableModel();
    private String query;
    private static SecurityEventWrapper prevEvent = null;
    private static RawLogSimWrapper prevLog = null;
    private String tag = UUID.randomUUID().toString();
    private static final int REFRESH_INTERVALS = 3600000;
    private JScrollPane jScrollPane;
    private JMenuItem miDisplayOptions;
    private JPopupMenu pmDisplayOptions;
    private JTable tSecurityEvents;

    public SecurityEventsFullScreenPanel() {
        this.initComponents();
        this.query = "*";
        this.displayOptions.setAutoRefresh(1);
        this.displayOptions.setPageSize(100);
        this.displayOptions.setQuery(this.query);
        this.displayOptions.setLastNHoursSelectedIndex(0);
        long now = System.currentTimeMillis();
        this.displayOptions.setTimeStart(now - 3600000L);
        this.displayOptions.setTimeFinish(now);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SecurityEvent event = (SecurityEvent)SecurityEventsFullScreenPanel.this.tableModel.getValueAt(SecurityEventsFullScreenPanel.this.tSecurityEvents.getSelectedRow(), SecurityEventsFullScreenPanel.this.tSecurityEvents.getSelectedColumn());
                String category = SecurityEventsFullScreenPanel.this.tableModel.getColumnName(SecurityEventsFullScreenPanel.this.tSecurityEvents.getSelectedColumn()).replace("<html><b>", "").replace("</b></html>", "");
                String query = QueryManager.copySecurityEventColumn(event, category);
                StringSelection selection = new StringSelection(query);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(67, 2, false);
        this.tSecurityEvents.registerKeyboardAction(listener, "Copy", stroke, 0);
        this.tSecurityEvents.getTableHeader().setReorderingAllowed(false);
        this.tSecurityEvents.setDefaultRenderer(SecurityEvent.class, new SecurityEventsTableRenderer());
        this.tSecurityEvents.setFillsViewportHeight(true);
        this.tSecurityEvents.setSelectionMode(0);
        this.tSecurityEvents.setRowSelectionAllowed(true);
        this.tSecurityEvents.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            private RequestProcessor rp = new RequestProcessor("TransmitFromSERawLogSimWrapper");
            private TopComponent rawLogDetails = WindowManager.getDefault().findTopComponent("RawLogDetailsTopComponent");
            private TopComponent securityEventDetails = WindowManager.getDefault().findTopComponent("SecurityEventDetailsTopComponent");

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    final SecurityEvent event = (SecurityEvent)SecurityEventsFullScreenPanel.this.tableModel.getValueAt(SecurityEventsFullScreenPanel.this.tSecurityEvents.getSelectedRow(), 0);
                    if (this.securityEventDetails.isOpened()) {
                        this.rp.execute(new Runnable(){

                            @Override
                            public void run() {
                                if (event != null) {
                                    SecurityEventWrapper sew = new SecurityEventWrapper(event, SecurityEventsFullScreenPanel.this.displayOptions, SecurityEventsFullScreenPanel.this.tag);
                                    sew.setQuery(SecurityEventsFullScreenPanel.this.query);
                                    if (prevEvent != null) {
                                        SecurityEventsFullScreenPanel.this.instanceContent.remove((Object)prevEvent);
                                    }
                                    SecurityEventsFullScreenPanel.this.instanceContent.add((Object)sew);
                                    prevEvent = sew;
                                }
                            }
                        });
                    }
                    if (this.rawLogDetails.isOpened()) {
                        this.rp.execute(new Runnable(){

                            @Override
                            public void run() {
                                if (event != null) {
                                    long start = event.getTimestamp() - 600000L;
                                    long finish = event.getTimestamp() + 600000L;
                                    try {
                                        RawLog log = SecurityEventsFullScreenPanel.this.apiService.getRawLog(event.getId(), start, finish);
                                        RawLogSimWrapper rlsw = null;
                                        if (log != null) {
                                            rlsw = new RawLogSimWrapper(log, start, finish, SecurityEventsFullScreenPanel.this.tag, SecurityEventsFullScreenPanel.this.displayOptions.isLastNHours(), SecurityEventsFullScreenPanel.this.displayOptions.getLastNHoursSelectedIndex(), SecurityEventsFullScreenPanel.this.displayOptions.isNow());
                                            rlsw.setQuery(SecurityEventsFullScreenPanel.this.query);
                                        } else {
                                            log = new RawLog();
                                            log.setId(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.nodata"));
                                            log.setSource(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.nodata"));
                                            log.setText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.nodata"));
                                            log.setSource(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.nodata"));
                                            rlsw = new RawLogSimWrapper(log, start, finish, SecurityEventsFullScreenPanel.this.tag, SecurityEventsFullScreenPanel.this.displayOptions.isLastNHours(), SecurityEventsFullScreenPanel.this.displayOptions.getLastNHoursSelectedIndex(), SecurityEventsFullScreenPanel.this.displayOptions.isNow());
                                            rlsw.setQuery(SecurityEventsFullScreenPanel.this.query);
                                        }
                                        if (prevLog != null) {
                                            SecurityEventsFullScreenPanel.this.instanceContent.remove((Object)prevLog);
                                        }
                                        SecurityEventsFullScreenPanel.this.instanceContent.add((Object)rlsw);
                                        prevLog = rlsw;
                                    }
                                    catch (ApiServiceException_Exception ex) {
                                        Exceptions.printStackTrace((Throwable)ex);
                                    }
                                }
                            }
                        });
                    }
                }
            }
        });
        this.tSecurityEvents.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SecurityEvent event;
                if (e.getClickCount() == 2 && (event = (SecurityEvent)SecurityEventsFullScreenPanel.this.tableModel.getValueAt(SecurityEventsFullScreenPanel.this.tSecurityEvents.getSelectedRow(), 0)) != null) {
                    TopComponent[] openedTopComponents;
                    Mode mode = WindowManager.getDefault().findMode("properties");
                    for (TopComponent tc : openedTopComponents = WindowManager.getDefault().getOpenedTopComponents(mode)) {
                        if (!(tc instanceof SecurityEventDetailsTopComponent)) continue;
                        return;
                    }
                    SecurityEventDetailsTopComponent details = (SecurityEventDetailsTopComponent)WindowManager.getDefault().findTopComponent("SecurityEventDetailsTopComponent");
                    mode.dockInto((TopComponent)details);
                    SecurityEventWrapper sew = new SecurityEventWrapper(event, SecurityEventsFullScreenPanel.this.displayOptions, SecurityEventsFullScreenPanel.this.tag);
                    details.setSecurityEvent(sew);
                    details.open();
                    details.requestActive();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    SecurityEventsFullScreenPanel.this.pmDisplayOptions.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.tSecurityEvents.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                SecurityEventsFullScreenPanel.this.tSecurityEvents.getSelectionModel().clearSelection();
                if (prevEvent != null) {
                    SecurityEventsFullScreenPanel.this.instanceContent.remove((Object)prevEvent);
                }
                if (prevLog != null) {
                    SecurityEventsFullScreenPanel.this.instanceContent.remove((Object)prevLog);
                }
            }
        });
        this.displayOptions.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SecurityEventsFullScreenPanel.this.displayOptions.save();
                if (SecurityEventsFullScreenPanel.this.displayOptions.getAutoRefresh() == 0) {
                    SecurityEventsFullScreenPanel.this.stopAutoRefreshTimer();
                } else {
                    SecurityEventsFullScreenPanel.this.startAutoRefreshTimer();
                }
                SecurityEventsFullScreenPanel.this.startSearch();
            }
        });
        this.autoRefreshTimer = new Timer(this.displayOptions.getAutoRefresh(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SecurityEventsFullScreenPanel.this.startSearch();
            }
        });
    }

    public SecurityEventsFullScreenPanel(String query) {
        this();
        this.query = query;
        this.displayOptions.setQuery(query);
    }

    public SecurityEventsFullScreenPanel(PriorityQuery priorityQuery) {
        this(priorityQuery.toString());
    }

    public void setQuery(String query) {
        this.query = query;
        this.displayOptions.setQuery(query);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "PROP_EVENTS": {
                List events = (List)evt.getNewValue();
                this.tableModel.setData(events);
                break;
            }
            case "PROP_COUNT_TASK_FINISHED": {
                this.fetch((DateRange)evt.getNewValue());
                break;
            }
            case "PROP_FETCH_TASK_FINISHED": {
                try {
                    this.searchExecutor.count();
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            case "PROP_COUNT_TASK_SKIPPED": {
                SkippedTaskInfo sti = (SkippedTaskInfo)evt.getNewValue();
                logger.info(String.format("Date Range skipped: s: %s, f: %s", new DateTime(sti.getStartTimeStamp()), new DateTime(sti.getFinishTimeStamp())));
                if (this.searchExecutor.getSearchContext().getTaskMonitor().isAllCountTasksCompleted()) {
                    this.searchExecutor.submitSkippedTaskWithBackoff(TaskMonitor.BaseTaskName.COUNT.getBaseTaskName(), sti);
                    break;
                }
                this.searchExecutor.addTaskToSkippedTask(sti);
                break;
            }
            case "PROP_ALL_COUNT_TASKS_FINISHED": {
                logger.info("PROP_ALL_COUNT_TASKS_FINISHED");
                List<SkippedTaskInfo> tasks = this.searchExecutor.getSearchContext().getSkippedTasks();
                for (SkippedTaskInfo ski : tasks) {
                    this.searchExecutor.submitSkippedTaskWithBackoff(TaskMonitor.BaseTaskName.COUNT.getBaseTaskName(), ski);
                }
                this.searchExecutor.getSearchContext().getSkippedTasks().clear();
                break;
            }
            case "PROP_ALL_SKIPPED_COUNT_TASKS_FINISHED": {
                logger.info("PROP_ALL_SKIPPED_COUNT_TASKS_FINISHED");
            }
            case "PROP_ALL_FETCH_TASKS_FINISHED": {
                logger.info("PROP_ALL_FETCH_TASKS_FINISHED");
                break;
            }
            case "PROP_ALL_TASKS_FINISHED": {
                logger.info("ALL TASKS ARE COMPLETED");
                break;
            }
            case "PROP_FETCH_TASK_FAILED": 
            case "PROP_COUNT_TASK_FAILED": {
                List errors = (List)evt.getNewValue();
                logger.info(String.format("TASK FAILED: %s", errors));
                this.searchExecutor.shutdown();
            }
        }
    }

    public String getQuery() {
        return this.query;
    }

    public Lookup getSelectedEventLookup() {
        return this.selectedEvent;
    }

    public void startAutoRefreshTimer() {
        if (this.displayOptions.getAutoRefresh() > 0) {
            this.autoRefreshTimer.setInitialDelay(this.displayOptions.getAutoRefresh() * 1000 * 60);
            this.autoRefreshTimer.setDelay(this.displayOptions.getAutoRefresh() * 1000 * 60);
            this.autoRefreshTimer.start();
        }
    }

    public void stopAutoRefreshTimer() {
        this.autoRefreshTimer.stop();
    }

    public void startSearch() {
        this.tableModel.clearData();
        if (this.searchExecutor != null) {
            this.searchExecutor.shutdown();
        }
        this.displayOptions.adjustTime();
        try {
            logger.info(String.format("START SEARCH: s: %s f: %s", new DateTime(this.displayOptions.getTimeStart()), new DateTime(this.displayOptions.getTimeFinish())));
            this.searchExecutor = new SearchExecutor(this.displayOptions.getQuery(), this.displayOptions.getTimeStart(), this.displayOptions.getTimeFinish(), this.displayOptions.getIndexSplit(), this.displayOptions.getPageSize(), false, this);
            this.searchExecutor.startSearch();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void fetch(DateRange dr) {
        try {
            this.searchExecutor.fetch(dr);
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initComponents() {
        this.pmDisplayOptions = new JPopupMenu();
        this.miDisplayOptions = new JMenuItem();
        this.jScrollPane = new JScrollPane();
        this.tSecurityEvents = new JTable();
        Mnemonics.setLocalizedText((AbstractButton)this.miDisplayOptions, (String)NbBundle.getMessage(SecurityEventsFullScreenPanel.class, (String)"SecurityEventsFullScreenPanel.miDisplayOptions.text"));
        this.miDisplayOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecurityEventsFullScreenPanel.this.miDisplayOptionsActionPerformed(evt);
            }
        });
        this.pmDisplayOptions.add(this.miDisplayOptions);
        this.tSecurityEvents.setModel(this.tableModel);
        this.jScrollPane.setViewportView(this.tSecurityEvents);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane, -1, 376, Short.MAX_VALUE).addContainerGap())));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane, -1, 276, Short.MAX_VALUE).addContainerGap())));
    }

    private void miDisplayOptionsActionPerformed(ActionEvent evt) {
        FullscreenDisplayOptionsDisplayer.display(this.displayOptions);
    }

    public static enum PriorityQuery {
        PRIORITY_3("what.priority:3 NOT extra.tags:\"internal\""),
        PRIORITY_4("what.priority:4 NOT extra.tags:\"internal\""),
        PRIORITY_5("what.priority:5 NOT extra.tags:\"internal\"");

        private final String query;

        private PriorityQuery(String query) {
            this.query = query;
        }

        public String toString() {
            return this.query;
        }
    }
}

