/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.meshes;

import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.meshes.IndexesLoop;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Point {
    private static final Logger LOGGER = Logger.getLogger(Point.class.getName());
    private int index;

    public Point(int index) {
        this.index = index;
    }

    public Point clone() {
        return new Point(this.index);
    }

    public int getIndex() {
        return this.index;
    }

    public void shiftIndexes(int shift, IndexesLoop.IndexPredicate predicate) {
        if (predicate == null || predicate.execute(this.index)) {
            this.index += shift;
        }
    }

    public static List<Point> loadAll(Structure meshStructure) throws BlenderFileException {
        LOGGER.log(Level.FINE, "Loading all points that do not belong to any edge from mesh: {0}", meshStructure.getName());
        ArrayList<Point> result = new ArrayList<Point>();
        Pointer pMEdge = (Pointer)meshStructure.getFieldValue("medge");
        if (pMEdge.isNotNull()) {
            int count = ((Number)meshStructure.getFieldValue("totvert")).intValue();
            HashSet<Integer> unusedVertices = new HashSet<Integer>(count);
            for (int i = 0; i < count; ++i) {
                unusedVertices.add(i);
            }
            List<Structure> edges = pMEdge.fetchData();
            for (Structure edge : edges) {
                unusedVertices.remove(((Number)edge.getFieldValue("v1")).intValue());
                unusedVertices.remove(((Number)edge.getFieldValue("v2")).intValue());
            }
            for (Integer unusedIndex : unusedVertices) {
                result.add(new Point(unusedIndex));
            }
        }
        LOGGER.log(Level.FINE, "Loaded {0} points.", result.size());
        return result;
    }
}

