/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.animations;

import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SpatialTrack;
import com.jme3.scene.Node;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.BoneContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BlenderAction
implements Cloneable {
    final String name;
    int fps;
    int stopFrame;
    Map<String, Ipo> featuresTracks = new HashMap<String, Ipo>();

    public BlenderAction(String name, int fps) {
        this.name = name;
        this.fps = fps;
    }

    public void removeTracksThatAreNotInTheCollection(Collection<String> trackNames) {
        HashMap<String, Ipo> newTracks = new HashMap<String, Ipo>();
        for (String trackName : trackNames) {
            if (!this.featuresTracks.containsKey(trackName)) continue;
            newTracks.put(trackName, this.featuresTracks.get(trackName));
        }
        this.featuresTracks = newTracks;
    }

    public BlenderAction clone() {
        BlenderAction result = new BlenderAction(this.name, this.fps);
        result.stopFrame = this.stopFrame;
        result.featuresTracks = new HashMap<String, Ipo>(this.featuresTracks);
        return result;
    }

    public SpatialTrack[] toTracks(Node node, BlenderContext blenderContext) {
        ArrayList<SpatialTrack> tracks = new ArrayList<SpatialTrack>(this.featuresTracks.size());
        for (Map.Entry<String, Ipo> entry : this.featuresTracks.entrySet()) {
            tracks.add((SpatialTrack)entry.getValue().calculateTrack(0, null, node.getLocalTranslation(), node.getLocalRotation(), node.getLocalScale(), 1, this.stopFrame, this.fps, true));
        }
        return tracks.toArray(new SpatialTrack[tracks.size()]);
    }

    public BoneTrack[] toTracks(Skeleton skeleton, BlenderContext blenderContext) {
        ArrayList<BoneTrack> tracks = new ArrayList<BoneTrack>(this.featuresTracks.size());
        for (Map.Entry<String, Ipo> entry : this.featuresTracks.entrySet()) {
            int boneIndex = skeleton.getBoneIndex(entry.getKey());
            BoneContext boneContext = blenderContext.getBoneContext(skeleton.getBone(boneIndex));
            tracks.add((BoneTrack)entry.getValue().calculateTrack(boneIndex, boneContext, boneContext.getBone().getBindPosition(), boneContext.getBone().getBindRotation(), boneContext.getBone().getBindScale(), 1, this.stopFrame, this.fps, false));
        }
        return tracks.toArray(new BoneTrack[tracks.size()]);
    }

    public String getName() {
        return this.name;
    }

    public float getAnimationTime() {
        return (float)(this.stopFrame - 1) / (float)this.fps;
    }

    public boolean hasTrackName(String name) {
        return this.featuresTracks.containsKey(name);
    }

    public int getTracksCount() {
        return this.featuresTracks.size();
    }

    public String toString() {
        return "BlenderTrack [name = " + this.name + "; tracks = [" + this.featuresTracks.keySet() + "]]";
    }
}

