/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.gfx;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Node;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.Renderer;

public class MouseSelectorAppState
implements AppState {
    private boolean active;
    private Renderer app;
    private Camera cam;
    private final boolean fireOnLMBClick;
    private final boolean fireOnMMBClick;
    private final boolean fireOnMouseOver;
    private final boolean fireOnRMBClick;
    private InputManager inputManager;
    private boolean initialized = false;
    private final InputListener mouseClickListener = new ActionListener(){

        public void onAction(String name, boolean isPressed, float tpf) {
            SelectionData sel;
            if (isPressed && (MouseSelectorAppState.this.fireOnLMBClick && name.equals("LMB") || MouseSelectorAppState.this.fireOnMMBClick && name.equals("MMB") || MouseSelectorAppState.this.fireOnRMBClick && name.equals("RMB")) && (sel = MouseSelectorAppState.this.getSelectionData()) != null) {
                MouseSelectorAppState.this.app.fireSelectionEvent(sel.name, sel.distance, name, sel.cursorPos);
            }
        }
    };
    private Node rootNode;

    public MouseSelectorAppState(boolean fireOnMouseOver, boolean fireOnLeftMouseClick, boolean fireOnMiddleMouseClick, boolean fireOnRightMouseClick) {
        this.fireOnMouseOver = fireOnMouseOver;
        this.fireOnLMBClick = fireOnLeftMouseClick;
        this.fireOnMMBClick = fireOnMiddleMouseClick;
        this.fireOnRMBClick = fireOnRightMouseClick;
    }

    public void cleanup() {
        this.inputManager.removeListener(this.mouseClickListener);
        this.inputManager.deleteTrigger("LMB", (Trigger)new MouseButtonTrigger(0));
        this.inputManager.deleteTrigger("MMB", (Trigger)new MouseButtonTrigger(2));
        this.inputManager.deleteTrigger("RMB", (Trigger)new MouseButtonTrigger(1));
        this.initialized = false;
    }

    public void initialize(AppStateManager stateManager, Application app) {
        this.app = (Renderer)app;
        this.inputManager = app.getInputManager();
        this.cam = this.app.getCamera();
        this.rootNode = this.app.getRootNode();
        this.inputManager.addMapping("LMB", new Trigger[]{new MouseButtonTrigger(0)});
        this.inputManager.addMapping("MMB", new Trigger[]{new MouseButtonTrigger(2)});
        this.inputManager.addMapping("RMB", new Trigger[]{new MouseButtonTrigger(1)});
        this.inputManager.addListener(this.mouseClickListener, new String[]{"LMB"});
        this.inputManager.addListener(this.mouseClickListener, new String[]{"MMB"});
        this.inputManager.addListener(this.mouseClickListener, new String[]{"RMB"});
        this.active = true;
        this.initialized = true;
    }

    public boolean isEnabled() {
        return this.active;
    }

    public void setEnabled(boolean active) {
        this.active = active;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void postRender() {
    }

    public void render(RenderManager rm) {
    }

    public void stateAttached(AppStateManager stateManager) {
    }

    public void stateDetached(AppStateManager stateManager) {
    }

    public void update(float tpf) {
        SelectionData sel;
        if (this.fireOnMouseOver && (sel = this.getSelectionData()) != null) {
            this.app.fireSelectionEvent(sel.name, sel.distance, "NMB", sel.cursorPos);
        }
    }

    private SelectionData getSelectionData() {
        SelectionData ret = null;
        CollisionResults results = new CollisionResults();
        Vector2f cursorPos = this.inputManager.getCursorPosition();
        Vector3f cameraPos = this.cam.getWorldCoordinates(new Vector2f(cursorPos.x, cursorPos.y), 0.0f).clone();
        Vector3f dir = this.cam.getWorldCoordinates(new Vector2f(cursorPos.x, cursorPos.y), 1.0f).subtractLocal(cameraPos).normalizeLocal();
        Ray ray = new Ray(cameraPos, dir);
        this.rootNode.collideWith((Collidable)ray, results);
        if (results.getClosestCollision() != null) {
            float dist = results.getClosestCollision().getDistance();
            String name = results.getClosestCollision().getGeometry().getName();
            ret = new SelectionData(dist, name, cursorPos);
        }
        return ret;
    }

    private static class SelectionData {
        public final Vector2f cursorPos;
        public final float distance;
        public final String name;

        SelectionData(float distance, String name, Vector2f cursorPos) {
            this.distance = distance;
            this.name = name;
            this.cursorPos = cursorPos;
        }
    }
}

