/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.gfx;

import com.jme3.math.ColorRGBA;

public class ColorString {
    private final String string;

    public static ColorRGBA colorFromString(String str) {
        if (str.startsWith("#") && (str.length() == 7 || str.length() == 9)) {
            return ColorString.colorFromHexString(str);
        }
        return ColorString.colorFromName(str);
    }

    private static ColorRGBA colorFromHexString(String hex) {
        ColorRGBA ret = ColorRGBA.White;
        hex = hex.toUpperCase();
        String rhex = hex.substring(1, 3);
        String ghex = hex.substring(3, 5);
        String bhex = hex.substring(5, 7);
        String ahex = "FF";
        if (hex.length() == 9) {
            ahex = hex.substring(7, 9);
        }
        try {
            ret = new ColorRGBA((float)Integer.parseInt(rhex, 16) / 255.0f, (float)Integer.parseInt(ghex, 16) / 255.0f, (float)Integer.parseInt(bhex, 16) / 255.0f, (float)Integer.parseInt(ahex, 16) / 255.0f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret;
    }

    private static ColorRGBA colorFromName(String color) {
        switch (color.toLowerCase()) {
            case "black": {
                return ColorRGBA.Black;
            }
            case "blue": {
                return ColorRGBA.Blue;
            }
            case "brown": {
                return ColorRGBA.Brown;
            }
            case "cyan": {
                return ColorRGBA.Cyan;
            }
            case "darkgray": {
                return ColorRGBA.DarkGray;
            }
            case "gray": {
                return ColorRGBA.Gray;
            }
            case "green": {
                return ColorRGBA.Green;
            }
            case "lightgray": {
                return ColorRGBA.LightGray;
            }
            case "magenta": {
                return ColorRGBA.Magenta;
            }
            case "orange": {
                return ColorRGBA.Orange;
            }
            case "pink": {
                return ColorRGBA.Pink;
            }
            case "red": {
                return ColorRGBA.Red;
            }
            case "white": {
                return ColorRGBA.White;
            }
            case "yellow": {
                return ColorRGBA.Yellow;
            }
            case "random": {
                return ColorRGBA.randomColor();
            }
        }
        return ColorRGBA.White;
    }

    public ColorString(String string) {
        this.string = string;
    }

    public ColorRGBA color() {
        return this.string != null ? ColorString.colorFromString(this.string) : ColorRGBA.White;
    }
}

