/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.chart.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import rs.co.ast.chart.OverviewChart;
import rs.co.ast.chart.event.ASTMouseEvent;
import rs.co.ast.chart.event.ASTMouseListener;
import rs.co.ast.chart.event.ASTPlotChangeEvent;
import rs.co.ast.chart.event.ASTPlotChangeListener;

public class ChartTestFrame
extends JFrame {
    private OverviewChart chart;
    private JButton bUpdate;
    private JPanel pChartWrapper;

    public ChartTestFrame() {
        this.initComponents();
        this.chart = new OverviewChart(this.generateTimeSeries("TS1"), this.generateTimeSeries("TS2"));
        this.chart.addPlotChangeListener(new ASTPlotChangeListener(){

            @Override
            public void plotChanged(ASTPlotChangeEvent event) {
                System.out.println("PlotChanged!");
            }
        });
        this.chart.addChartPanelMouseListener(new ASTMouseListener(){

            @Override
            public void mousePressed(ASTMouseEvent e) {
                System.out.println("MousePressed!");
            }

            @Override
            public void mouseReleased(ASTMouseEvent e) {
                System.out.println("MouseReleased!");
            }
        });
        this.pChartWrapper.setLayout(new BorderLayout());
        this.pChartWrapper.add((Component)this.chart.getChartPanel());
        this.pack();
    }

    private void initComponents() {
        this.pChartWrapper = new JPanel();
        this.bUpdate = new JButton();
        this.setDefaultCloseOperation(3);
        GroupLayout pChartWrapperLayout = new GroupLayout(this.pChartWrapper);
        this.pChartWrapper.setLayout(pChartWrapperLayout);
        pChartWrapperLayout.setHorizontalGroup(pChartWrapperLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        pChartWrapperLayout.setVerticalGroup(pChartWrapperLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 327, Short.MAX_VALUE));
        this.bUpdate.setText("Update");
        this.bUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartTestFrame.this.bUpdateActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.bUpdate).addContainerGap(632, Short.MAX_VALUE)).addComponent(this.pChartWrapper, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pChartWrapper, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bUpdate).addGap(6, 6, 6)));
        this.pack();
    }

    private void bUpdateActionPerformed(ActionEvent evt) {
        this.chart.updateChart(this.generateTimeSeries("TS1"), this.generateTimeSeries("TS2"), this.generateTimeSeries("TS3"));
    }

    private TimeSeries generateTimeSeries(String name) {
        long now = System.currentTimeMillis();
        TimeSeries ts1 = new TimeSeries((Comparable)((Object)name));
        ts1.addOrUpdate(RegularTimePeriod.createInstance(Minute.class, (Date)new Date(now + 1000L), (TimeZone)TimeZone.getDefault()), Math.random());
        ts1.addOrUpdate(RegularTimePeriod.createInstance(Minute.class, (Date)new Date(now + 60000L), (TimeZone)TimeZone.getDefault()), Math.random());
        ts1.addOrUpdate(RegularTimePeriod.createInstance(Minute.class, (Date)new Date(now + 120000L), (TimeZone)TimeZone.getDefault()), Math.random());
        ts1.addOrUpdate(RegularTimePeriod.createInstance(Minute.class, (Date)new Date(now + 180000L), (TimeZone)TimeZone.getDefault()), Math.random());
        ts1.addOrUpdate(RegularTimePeriod.createInstance(Minute.class, (Date)new Date(now + 240000L), (TimeZone)TimeZone.getDefault()), Math.random());
        ts1.addOrUpdate(RegularTimePeriod.createInstance(Minute.class, (Date)new Date(now + 300000L), (TimeZone)TimeZone.getDefault()), Math.random());
        ts1.addOrUpdate(RegularTimePeriod.createInstance(Minute.class, (Date)new Date(now + 360000L), (TimeZone)TimeZone.getDefault()), Math.random());
        ts1.addOrUpdate(RegularTimePeriod.createInstance(Minute.class, (Date)new Date(now + 420000L), (TimeZone)TimeZone.getDefault()), Math.random());
        ts1.addOrUpdate(RegularTimePeriod.createInstance(Minute.class, (Date)new Date(now + 480000L), (TimeZone)TimeZone.getDefault()), Math.random());
        ts1.addOrUpdate(RegularTimePeriod.createInstance(Minute.class, (Date)new Date(now + 540000L), (TimeZone)TimeZone.getDefault()), Math.random());
        ts1.addOrUpdate(RegularTimePeriod.createInstance(Minute.class, (Date)new Date(now + 600000L), (TimeZone)TimeZone.getDefault()), Math.random());
        ts1.addOrUpdate(RegularTimePeriod.createInstance(Minute.class, (Date)new Date(now + 660000L), (TimeZone)TimeZone.getDefault()), Math.random());
        ts1.addOrUpdate(RegularTimePeriod.createInstance(Minute.class, (Date)new Date(now + 720000L), (TimeZone)TimeZone.getDefault()), Math.random());
        ts1.addOrUpdate(RegularTimePeriod.createInstance(Minute.class, (Date)new Date(now + 780000L), (TimeZone)TimeZone.getDefault()), Math.random());
        ts1.addOrUpdate(RegularTimePeriod.createInstance(Minute.class, (Date)new Date(now + 840000L), (TimeZone)TimeZone.getDefault()), Math.random());
        return ts1;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ChartTestFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ChartTestFrame().setVisible(true);
            }
        });
    }
}

