/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block.linsol.qr;

import org.ejml.alg.block.BlockMatrixOps;
import org.ejml.alg.block.BlockTriangularSolver;
import org.ejml.alg.block.decomposition.qr.QRDecompositionHouseholder_B64;
import org.ejml.data.BlockMatrix64F;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.D1Submatrix64F;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.ops.SpecializedOps;

public class BlockQrHouseHolderSolver
implements LinearSolver<BlockMatrix64F> {
    protected QRDecompositionHouseholder_B64 decomposer = new QRDecompositionHouseholder_B64();
    protected BlockMatrix64F QR;

    public BlockQrHouseHolderSolver() {
        this.decomposer.setSaveW(false);
    }

    public boolean setA(BlockMatrix64F A) {
        if (A.numRows < A.numCols) {
            throw new IllegalArgumentException("Number of rows must be more than or equal to the number of columns.  Can't solve an underdetermined system.");
        }
        if (!this.decomposer.decompose(A)) {
            return false;
        }
        this.QR = this.decomposer.getQR();
        return true;
    }

    public double quality() {
        return SpecializedOps.qualityTriangular((D1Matrix64F)this.decomposer.getQR());
    }

    public void solve(BlockMatrix64F B, BlockMatrix64F X) {
        if (B.numCols != X.numCols) {
            throw new IllegalArgumentException("Columns of B and X do not match");
        }
        if (this.QR.numCols != X.numRows) {
            throw new IllegalArgumentException("Rows in X do not match the columns in A");
        }
        if (this.QR.numRows != B.numRows) {
            throw new IllegalArgumentException("Rows in B do not match the rows in A.");
        }
        if (B.blockLength != this.QR.blockLength || X.blockLength != this.QR.blockLength) {
            throw new IllegalArgumentException("All matrices must have the same block length.");
        }
        this.decomposer.applyQTran(B);
        BlockMatrixOps.extractAligned(B, X);
        int M = Math.min(this.QR.numRows, this.QR.numCols);
        BlockTriangularSolver.solve(this.QR.blockLength, true, new D1Submatrix64F((D1Matrix64F)this.QR, 0, M, 0, M), new D1Submatrix64F((D1Matrix64F)X), false);
    }

    public void invert(BlockMatrix64F A_inv) {
        int M = Math.min(this.QR.numRows, this.QR.numCols);
        if (A_inv.numRows != M || A_inv.numCols != M) {
            throw new IllegalArgumentException("A_inv must be square an have dimension " + M);
        }
        BlockMatrixOps.setIdentity(A_inv);
        this.decomposer.applyQTran(A_inv);
        BlockTriangularSolver.solve(this.QR.blockLength, true, new D1Submatrix64F((D1Matrix64F)this.QR, 0, M, 0, M), new D1Submatrix64F((D1Matrix64F)A_inv), false);
    }

    public boolean modifiesA() {
        return this.decomposer.inputModified();
    }

    public boolean modifiesB() {
        return true;
    }

    public QRDecomposition<BlockMatrix64F> getDecomposition() {
        return this.decomposer;
    }
}

