/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.export.binary;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteUtils {
    public static byte[] getByteContent(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(16384);
        byte[] buffer = new byte[1024];
        int byteCount = -1;
        byte[] data = null;
        while ((byteCount = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, byteCount);
        }
        data = outputStream.toByteArray();
        outputStream.close();
        return data;
    }

    public static void writeShort(OutputStream outputStream, short value) throws IOException {
        byte[] byteArray = ByteUtils.convertToBytes(value);
        outputStream.write(byteArray);
    }

    public static byte[] convertToBytes(short value) {
        byte[] byteArray = new byte[]{(byte)(value >> 8), (byte)value};
        return byteArray;
    }

    public static short readShort(InputStream inputStream) throws IOException {
        byte[] byteArray = new byte[2];
        inputStream.read(byteArray);
        short number = ByteUtils.convertShortFromBytes(byteArray);
        return number;
    }

    public static short convertShortFromBytes(byte[] byteArray) {
        return ByteUtils.convertShortFromBytes(byteArray, 0);
    }

    public static short convertShortFromBytes(byte[] byteArray, int offset) {
        short number = (short)((byteArray[offset + 1] & 0xFF) + ((byteArray[offset + 0] & 0xFF) << 8));
        return number;
    }

    public static void writeInt(OutputStream outputStream, int integer) throws IOException {
        byte[] byteArray = ByteUtils.convertToBytes(integer);
        outputStream.write(byteArray);
    }

    public static byte[] convertToBytes(int integer) {
        byte[] byteArray = new byte[]{(byte)(integer >> 24), (byte)(integer >> 16), (byte)(integer >> 8), (byte)integer};
        return byteArray;
    }

    public static int readInt(InputStream inputStream) throws IOException {
        byte[] byteArray = new byte[4];
        inputStream.read(byteArray);
        int number = ByteUtils.convertIntFromBytes(byteArray);
        return number;
    }

    public static int convertIntFromBytes(byte[] byteArray) {
        return ByteUtils.convertIntFromBytes(byteArray, 0);
    }

    public static int convertIntFromBytes(byte[] byteArray, int offset) {
        int number = ((byteArray[offset] & 0xFF) << 24) + ((byteArray[offset + 1] & 0xFF) << 16) + ((byteArray[offset + 2] & 0xFF) << 8) + (byteArray[offset + 3] & 0xFF);
        return number;
    }

    public static void writeLong(OutputStream outputStream, long value) throws IOException {
        byte[] byteArray = ByteUtils.convertToBytes(value);
        outputStream.write(byteArray);
    }

    public static byte[] convertToBytes(long n) {
        byte[] bytes = new byte[8];
        bytes[7] = (byte)n;
        bytes[6] = (byte)(n >>>= 8);
        bytes[5] = (byte)(n >>>= 8);
        bytes[4] = (byte)(n >>>= 8);
        bytes[3] = (byte)(n >>>= 8);
        bytes[2] = (byte)(n >>>= 8);
        bytes[1] = (byte)(n >>>= 8);
        bytes[0] = (byte)(n >>>= 8);
        return bytes;
    }

    public static long readLong(InputStream inputStream) throws IOException {
        byte[] byteArray = new byte[8];
        inputStream.read(byteArray);
        long number = ByteUtils.convertLongFromBytes(byteArray);
        return number;
    }

    public static long convertLongFromBytes(byte[] bytes) {
        return ByteUtils.convertLongFromBytes(bytes, 0);
    }

    public static long convertLongFromBytes(byte[] bytes, int offset) {
        return ((long)bytes[offset + 7] & 0xFFL) + (((long)bytes[offset + 6] & 0xFFL) << 8) + (((long)bytes[offset + 5] & 0xFFL) << 16) + (((long)bytes[offset + 4] & 0xFFL) << 24) + (((long)bytes[offset + 3] & 0xFFL) << 32) + (((long)bytes[offset + 2] & 0xFFL) << 40) + (((long)bytes[offset + 1] & 0xFFL) << 48) + (((long)bytes[offset + 0] & 0xFFL) << 56);
    }

    public static void writeDouble(OutputStream outputStream, double value) throws IOException {
        byte[] byteArray = ByteUtils.convertToBytes(value);
        outputStream.write(byteArray);
    }

    public static byte[] convertToBytes(double n) {
        long bits = Double.doubleToLongBits(n);
        return ByteUtils.convertToBytes(bits);
    }

    public static double readDouble(InputStream inputStream) throws IOException {
        byte[] byteArray = new byte[8];
        inputStream.read(byteArray);
        double number = ByteUtils.convertDoubleFromBytes(byteArray);
        return number;
    }

    public static double convertDoubleFromBytes(byte[] bytes) {
        return ByteUtils.convertDoubleFromBytes(bytes, 0);
    }

    public static double convertDoubleFromBytes(byte[] bytes, int offset) {
        long bits = ByteUtils.convertLongFromBytes(bytes, offset);
        return Double.longBitsToDouble(bits);
    }

    public static void writeFloat(OutputStream outputStream, float fVal) throws IOException {
        byte[] byteArray = ByteUtils.convertToBytes(fVal);
        outputStream.write(byteArray);
    }

    public static byte[] convertToBytes(float f) {
        int temp = Float.floatToIntBits(f);
        return ByteUtils.convertToBytes(temp);
    }

    public static float readFloat(InputStream inputStream) throws IOException {
        byte[] byteArray = new byte[4];
        inputStream.read(byteArray);
        float number = ByteUtils.convertFloatFromBytes(byteArray);
        return number;
    }

    public static float convertFloatFromBytes(byte[] byteArray) {
        return ByteUtils.convertFloatFromBytes(byteArray, 0);
    }

    public static float convertFloatFromBytes(byte[] byteArray, int offset) {
        int number = ByteUtils.convertIntFromBytes(byteArray, offset);
        return Float.intBitsToFloat(number);
    }

    public static void writeBoolean(OutputStream outputStream, boolean bVal) throws IOException {
        byte[] byteArray = ByteUtils.convertToBytes(bVal);
        outputStream.write(byteArray);
    }

    public static byte[] convertToBytes(boolean b) {
        byte[] rVal = new byte[]{b ? (byte)1 : 0};
        return rVal;
    }

    public static boolean readBoolean(InputStream inputStream) throws IOException {
        byte[] byteArray = new byte[1];
        inputStream.read(byteArray);
        return ByteUtils.convertBooleanFromBytes(byteArray);
    }

    public static boolean convertBooleanFromBytes(byte[] byteArray) {
        return ByteUtils.convertBooleanFromBytes(byteArray, 0);
    }

    public static boolean convertBooleanFromBytes(byte[] byteArray, int offset) {
        return byteArray[offset] != 0;
    }

    public static byte[] readData(byte[] store, int bytes, InputStream is) throws IOException {
        for (int i = 0; i < bytes; ++i) {
            store[i] = (byte)is.read();
        }
        return store;
    }

    public static byte[] rightAlignBytes(byte[] bytes, int width) {
        if (bytes.length != width) {
            byte[] rVal = new byte[width];
            for (int x = width - bytes.length; x < width; ++x) {
                rVal[x] = bytes[x - (width - bytes.length)];
            }
            return rVal;
        }
        return bytes;
    }
}

