/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app;

import com.jme3.app.AppTask;
import com.jme3.app.Application;
import com.jme3.app.LostFocusBehavior;
import com.jme3.app.ResetStatsState;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.audio.AudioContext;
import com.jme3.audio.AudioRenderer;
import com.jme3.audio.Listener;
import com.jme3.input.InputManager;
import com.jme3.input.JoyInput;
import com.jme3.input.KeyInput;
import com.jme3.input.MouseInput;
import com.jme3.input.TouchInput;
import com.jme3.math.Vector3f;
import com.jme3.profile.AppProfiler;
import com.jme3.profile.AppStep;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.NanoTimer;
import com.jme3.system.SystemListener;
import com.jme3.system.Timer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LegacyApplication
implements Application,
SystemListener {
    private static final Logger logger = Logger.getLogger(LegacyApplication.class.getName());
    protected AssetManager assetManager;
    protected AudioRenderer audioRenderer;
    protected Renderer renderer;
    protected RenderManager renderManager;
    protected ViewPort viewPort;
    protected ViewPort guiViewPort;
    protected JmeContext context;
    protected AppSettings settings;
    protected Timer timer = new NanoTimer();
    protected Camera cam;
    protected Listener listener;
    protected boolean inputEnabled = true;
    protected LostFocusBehavior lostFocusBehavior = LostFocusBehavior.ThrottleOnLostFocus;
    protected float speed = 1.0f;
    protected boolean paused = false;
    protected MouseInput mouseInput;
    protected KeyInput keyInput;
    protected JoyInput joyInput;
    protected TouchInput touchInput;
    protected InputManager inputManager;
    protected AppStateManager stateManager;
    protected AppProfiler prof;
    private final ConcurrentLinkedQueue<AppTask<?>> taskQueue = new ConcurrentLinkedQueue();

    public LegacyApplication() {
        this(null);
    }

    public LegacyApplication(AppState ... initialStates) {
        this.initStateManager();
        if (initialStates != null) {
            for (AppState a : initialStates) {
                if (a == null) continue;
                this.stateManager.attach(a);
            }
        }
    }

    @Override
    public LostFocusBehavior getLostFocusBehavior() {
        return this.lostFocusBehavior;
    }

    @Override
    public void setLostFocusBehavior(LostFocusBehavior lostFocusBehavior) {
        this.lostFocusBehavior = lostFocusBehavior;
    }

    @Override
    public boolean isPauseOnLostFocus() {
        return this.getLostFocusBehavior() == LostFocusBehavior.PauseOnLostFocus;
    }

    @Override
    public void setPauseOnLostFocus(boolean pauseOnLostFocus) {
        if (pauseOnLostFocus) {
            this.setLostFocusBehavior(LostFocusBehavior.PauseOnLostFocus);
        } else {
            this.setLostFocusBehavior(LostFocusBehavior.Disabled);
        }
    }

    @Deprecated
    public void setAssetManager(AssetManager assetManager) {
        if (this.assetManager != null) {
            throw new IllegalStateException("Can only set asset manager before initialization.");
        }
        this.assetManager = assetManager;
    }

    private void initAssetManager() {
        String assetCfg;
        URL assetCfgUrl = null;
        if (this.settings != null && (assetCfg = this.settings.getString("AssetConfigURL")) != null) {
            try {
                assetCfgUrl = new URL(assetCfg);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (assetCfgUrl == null && (assetCfgUrl = LegacyApplication.class.getClassLoader().getResource(assetCfg)) == null) {
                logger.log(Level.SEVERE, "Unable to access AssetConfigURL in asset config:{0}", assetCfg);
                return;
            }
        }
        if (assetCfgUrl == null) {
            assetCfgUrl = JmeSystem.getPlatformAssetConfigURL();
        }
        if (this.assetManager == null) {
            this.assetManager = JmeSystem.newAssetManager(assetCfgUrl);
        }
    }

    @Override
    public void setSettings(AppSettings settings) {
        this.settings = settings;
        if (this.context != null && settings.useInput() != this.inputEnabled) {
            boolean bl = this.inputEnabled = !this.inputEnabled;
            if (this.inputEnabled) {
                this.initInput();
            } else {
                this.destroyInput();
            }
        } else {
            this.inputEnabled = settings.useInput();
        }
    }

    @Override
    public void setTimer(Timer timer) {
        this.timer = timer;
        if (timer != null) {
            timer.reset();
        }
        if (this.renderManager != null) {
            this.renderManager.setTimer(timer);
        }
    }

    @Override
    public Timer getTimer() {
        return this.timer;
    }

    private void initDisplay() {
        this.settings = this.context.getSettings();
        if (this.timer == null) {
            this.timer = this.context.getTimer();
        }
        this.renderer = this.context.getRenderer();
    }

    private void initAudio() {
        if (this.settings.getAudioRenderer() != null && this.context.getType() != JmeContext.Type.Headless) {
            this.audioRenderer = JmeSystem.newAudioRenderer(this.settings);
            this.audioRenderer.initialize();
            AudioContext.setAudioRenderer(this.audioRenderer);
            this.listener = new Listener();
            this.audioRenderer.setListener(this.listener);
        }
    }

    private void initCamera() {
        this.cam = new Camera(this.settings.getWidth(), this.settings.getHeight());
        this.cam.setFrustumPerspective(45.0f, (float)this.cam.getWidth() / (float)this.cam.getHeight(), 1.0f, 1000.0f);
        this.cam.setLocation(new Vector3f(0.0f, 0.0f, 10.0f));
        this.cam.lookAt(new Vector3f(0.0f, 0.0f, 0.0f), Vector3f.UNIT_Y);
        this.renderManager = new RenderManager(this.renderer);
        this.renderManager.setTimer(this.timer);
        if (this.prof != null) {
            this.renderManager.setAppProfiler(this.prof);
        }
        this.viewPort = this.renderManager.createMainView("Default", this.cam);
        this.viewPort.setClearFlags(true, true, true);
        Camera guiCam = new Camera(this.settings.getWidth(), this.settings.getHeight());
        this.guiViewPort = this.renderManager.createPostView("Gui Default", guiCam);
        this.guiViewPort.setClearFlags(false, false, false);
    }

    private void initInput() {
        this.mouseInput = this.context.getMouseInput();
        if (this.mouseInput != null) {
            this.mouseInput.initialize();
        }
        this.keyInput = this.context.getKeyInput();
        if (this.keyInput != null) {
            this.keyInput.initialize();
        }
        this.touchInput = this.context.getTouchInput();
        if (this.touchInput != null) {
            this.touchInput.initialize();
        }
        if (!this.settings.getBoolean("DisableJoysticks")) {
            this.joyInput = this.context.getJoyInput();
            if (this.joyInput != null) {
                this.joyInput.initialize();
            }
        }
        this.inputManager = new InputManager(this.mouseInput, this.keyInput, this.joyInput, this.touchInput);
    }

    private void initStateManager() {
        this.stateManager = new AppStateManager(this);
        this.stateManager.attach(new ResetStatsState());
    }

    @Override
    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    @Override
    public InputManager getInputManager() {
        return this.inputManager;
    }

    @Override
    public AppStateManager getStateManager() {
        return this.stateManager;
    }

    @Override
    public RenderManager getRenderManager() {
        return this.renderManager;
    }

    @Override
    public Renderer getRenderer() {
        return this.renderer;
    }

    @Override
    public AudioRenderer getAudioRenderer() {
        return this.audioRenderer;
    }

    @Override
    public Listener getListener() {
        return this.listener;
    }

    @Override
    public JmeContext getContext() {
        return this.context;
    }

    @Override
    public Camera getCamera() {
        return this.cam;
    }

    @Override
    public void start() {
        this.start(JmeContext.Type.Display, false);
    }

    @Override
    public void start(boolean waitFor) {
        this.start(JmeContext.Type.Display, waitFor);
    }

    public void start(JmeContext.Type contextType) {
        this.start(contextType, false);
    }

    public void start(JmeContext.Type contextType, boolean waitFor) {
        if (this.context != null && this.context.isCreated()) {
            logger.warning("start() called when application already created!");
            return;
        }
        if (this.settings == null) {
            this.settings = new AppSettings(true);
        }
        logger.log(Level.FINE, "Starting application: {0}", this.getClass().getName());
        this.context = JmeSystem.newContext(this.settings, contextType);
        this.context.setSystemListener(this);
        this.context.create(waitFor);
    }

    @Override
    public void setAppProfiler(AppProfiler prof) {
        this.prof = prof;
        if (this.renderManager != null) {
            this.renderManager.setAppProfiler(prof);
        }
    }

    @Override
    public AppProfiler getAppProfiler() {
        return this.prof;
    }

    public void createCanvas() {
        if (this.context != null && this.context.isCreated()) {
            logger.warning("createCanvas() called when application already created!");
            return;
        }
        if (this.settings == null) {
            this.settings = new AppSettings(true);
        }
        logger.log(Level.FINE, "Starting application: {0}", this.getClass().getName());
        this.context = JmeSystem.newContext(this.settings, JmeContext.Type.Canvas);
        this.context.setSystemListener(this);
    }

    public void startCanvas() {
        this.startCanvas(false);
    }

    public void startCanvas(boolean waitFor) {
        this.context.create(waitFor);
    }

    @Override
    public void reshape(int w, int h) {
        if (this.renderManager != null) {
            this.renderManager.notifyReshape(w, h);
        }
    }

    @Override
    public void restart() {
        this.context.setSettings(this.settings);
        this.context.restart();
    }

    @Override
    public void stop() {
        this.stop(false);
    }

    @Override
    public void stop(boolean waitFor) {
        logger.log(Level.FINE, "Closing application: {0}", this.getClass().getName());
        this.context.destroy(waitFor);
    }

    @Override
    public void initialize() {
        if (this.assetManager == null) {
            this.initAssetManager();
        }
        this.initDisplay();
        this.initCamera();
        if (this.inputEnabled) {
            this.initInput();
        }
        this.initAudio();
        this.timer.reset();
    }

    @Override
    public void handleError(String errMsg, Throwable t) {
        logger.log(Level.SEVERE, errMsg, t);
        if (this.context.getType() != JmeContext.Type.Headless) {
            if (t != null) {
                JmeSystem.showErrorDialog(errMsg + "\n" + t.getClass().getSimpleName() + (t.getMessage() != null ? ": " + t.getMessage() : ""));
            } else {
                JmeSystem.showErrorDialog(errMsg);
            }
        }
        this.stop();
    }

    @Override
    public void gainFocus() {
        if (this.lostFocusBehavior != LostFocusBehavior.Disabled) {
            if (this.lostFocusBehavior == LostFocusBehavior.PauseOnLostFocus) {
                this.paused = false;
            }
            this.context.setAutoFlushFrames(true);
            if (this.inputManager != null) {
                this.inputManager.reset();
            }
        }
    }

    @Override
    public void loseFocus() {
        if (this.lostFocusBehavior != LostFocusBehavior.Disabled) {
            if (this.lostFocusBehavior == LostFocusBehavior.PauseOnLostFocus) {
                this.paused = true;
            }
            this.context.setAutoFlushFrames(false);
        }
    }

    @Override
    public void requestClose(boolean esc) {
        this.context.destroy(false);
    }

    @Override
    public <V> Future<V> enqueue(Callable<V> callable) {
        AppTask<V> task = new AppTask<V>(callable);
        this.taskQueue.add(task);
        return task;
    }

    @Override
    public void enqueue(Runnable runnable) {
        this.enqueue(new RunnableWrapper(runnable));
    }

    protected void runQueuedTasks() {
        AppTask<?> task;
        while ((task = this.taskQueue.poll()) != null) {
            if (task.isCancelled()) continue;
            task.invoke();
        }
    }

    @Override
    public void update() {
        AudioContext.setAudioRenderer(this.audioRenderer);
        if (this.prof != null) {
            this.prof.appStep(AppStep.QueuedTasks);
        }
        this.runQueuedTasks();
        if (this.speed == 0.0f || this.paused) {
            return;
        }
        this.timer.update();
        if (this.inputEnabled) {
            if (this.prof != null) {
                this.prof.appStep(AppStep.ProcessInput);
            }
            this.inputManager.update(this.timer.getTimePerFrame());
        }
        if (this.audioRenderer != null) {
            if (this.prof != null) {
                this.prof.appStep(AppStep.ProcessAudio);
            }
            this.audioRenderer.update(this.timer.getTimePerFrame());
        }
    }

    protected void destroyInput() {
        if (this.mouseInput != null) {
            this.mouseInput.destroy();
        }
        if (this.keyInput != null) {
            this.keyInput.destroy();
        }
        if (this.joyInput != null) {
            this.joyInput.destroy();
        }
        if (this.touchInput != null) {
            this.touchInput.destroy();
        }
        this.inputManager = null;
    }

    @Override
    public void destroy() {
        this.stateManager.cleanup();
        this.destroyInput();
        if (this.audioRenderer != null) {
            this.audioRenderer.cleanup();
        }
        this.timer.reset();
    }

    @Override
    public ViewPort getGuiViewPort() {
        return this.guiViewPort;
    }

    @Override
    public ViewPort getViewPort() {
        return this.viewPort;
    }

    private class RunnableWrapper
    implements Callable {
        private final Runnable runnable;

        public RunnableWrapper(Runnable runnable) {
            this.runnable = runnable;
        }

        public Object call() {
            this.runnable.run();
            return null;
        }
    }
}

