/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.gsm;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.osgi.framework.Bundle;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;

public class IMEICondition {
    private static final String ORG_OSGI_UTIL_GSM_IMEI = "org.osgi.util.gsm.imei";
    private static final String IMEI = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty(IMEICondition.ORG_OSGI_UTIL_GSM_IMEI);
        }
    });
    private static final int IMEI_LENGTH = 15;

    private IMEICondition() {
    }

    public static Condition getCondition(Bundle bundle, ConditionInfo conditionInfo) {
        String imei = conditionInfo.getArgs()[0];
        int length = imei.length();
        if (length > 15) {
            throw new IllegalArgumentException("IMEI too long: " + imei);
        }
        if (imei.endsWith("*")) {
            imei = imei.substring(0, --length);
        } else if (length < 15) {
            throw new IllegalArgumentException("IMEI too short: " + imei);
        }
        for (int i = 0; i < length; ++i) {
            char c = imei.charAt(i);
            if ('0' <= c && c <= '9') continue;
            throw new IllegalArgumentException("not a valid IMEI: " + imei);
        }
        if (IMEI == null) {
            System.err.println("The OSGi implementation of org.osgi.util.gsm.IMEICondition needs the system property org.osgi.util.gsm.imei set.");
            return Condition.FALSE;
        }
        return IMEI.startsWith(imei) ? Condition.TRUE : Condition.FALSE;
    }
}

