/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import rs.co.ast.aspen.api.service.SecurityEvent;

public class Encryption {
    private static final List<String> fields = Arrays.asList("User", "SubjectUserName", "AccountName", "TargetUserName");

    public static List<SecurityEvent> md5EncryptMap(List<SecurityEvent> securityEvents) {
        ArrayList<SecurityEvent> encryptedListSE = new ArrayList<SecurityEvent>();
        boolean isGermanHostname = false;
        boolean isGermanSource = false;
        for (SecurityEvent se : securityEvents) {
            isGermanHostname = false;
            isGermanSource = false;
            for (SecurityEvent.Where.Entry entry : se.getWhere().getEntry()) {
                if (entry.getKey().equals("hostname") && entry.getValue().endsWith(".intern")) {
                    isGermanHostname = true;
                }
                if (!entry.getKey().equals("source") || !entry.getValue().startsWith("172.18.2.")) continue;
                isGermanSource = true;
            }
            block2: for (SecurityEvent.Where.Entry entry : se.getWhat().getEntry()) {
                for (String field : fields) {
                    if (!entry.getKey().equals(field)) continue;
                    entry.setValue(DigestUtils.md5Hex((String)entry.getValue()));
                    continue block2;
                }
            }
            block4: for (SecurityEvent.Where.Entry entry : se.getWhen().getEntry()) {
                for (String field : fields) {
                    if (!entry.getKey().equals(field)) continue;
                    entry.setValue(DigestUtils.md5Hex((String)entry.getValue()));
                    continue block4;
                }
            }
            for (SecurityEvent.Where.Entry entry : se.getWhere().getEntry()) {
                for (String field : fields) {
                    if (!entry.getKey().equals(field)) continue;
                    entry.setValue(DigestUtils.md5Hex((String)entry.getValue()));
                }
            }
            block8: for (SecurityEvent.Where.Entry entry : se.getWho().getEntry()) {
                for (String field : fields) {
                    if (!entry.getKey().equals(field)) continue;
                    entry.setValue(DigestUtils.md5Hex((String)entry.getValue()));
                    continue block8;
                }
            }
            encryptedListSE.add(se);
        }
        return encryptedListSE;
    }

    public static String md5EncryptValue(String key, String value) {
        for (String field : fields) {
            if (!field.equals(key)) continue;
            return DigestUtils.md5Hex((String)value);
        }
        return value;
    }
}

