/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.gfx.hollywood;

import com.jme3.bounding.BoundingVolume;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.Limits;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.ui.Picture;
import java.io.IOException;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.RenderedText;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.Renderer;

public class LabelControl
implements Control {
    private final Camera camera;
    private final Vector3f coords;
    private final float duration;
    private final ColorRGBA fontColor;
    private final String fontName;
    private final int fontSize;
    private final String fontStyle;
    private final Node guiNode;
    private Node label;
    private final int level;
    private final float maxDistance;
    private final float minDistance;
    private final Vector3f offset;
    private final Renderer renderer;
    private final float scale;
    private final ColorRGBA shadowColor;
    private final Vector3f shadowOffset;
    private Spatial spatial;
    private final float start;
    private final String text;
    private float time;

    public LabelControl(Renderer renderer, int level, Node guiNode, Camera camera, String text, String fontName, String fontStyle, int fontSize, ColorRGBA fontColor, float start, float duration, float minDistance, float maxDistance, Vector3f coords, float scale, Vector3f offset, Vector3f shadowOffset, ColorRGBA shadowColor) {
        this.renderer = renderer;
        this.camera = camera;
        this.coords = coords;
        this.duration = duration < 0.0f ? Float.MAX_VALUE : duration;
        this.guiNode = guiNode;
        this.level = level;
        this.maxDistance = maxDistance;
        this.minDistance = minDistance;
        this.offset = offset;
        this.scale = scale;
        this.shadowOffset = shadowOffset;
        this.shadowColor = shadowColor;
        this.start = start;
        this.text = text;
        this.fontName = fontName;
        this.fontStyle = fontStyle;
        this.fontSize = fontSize;
        this.fontColor = fontColor;
        this.createLabel();
    }

    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getLevel() {
        return this.level;
    }

    public void setSpatial(Spatial spatial) {
        if (spatial == null) {
            this.guiNode.detachChild((Spatial)this.label);
        }
        this.spatial = spatial;
    }

    public void read(JmeImporter im) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void render(RenderManager rm, ViewPort vp) {
    }

    public void update(float tpf) {
        this.time += tpf;
        if (this.time > this.start + this.duration) {
            this.guiNode.detachChild((Spatial)this.label);
            if (this.spatial != null) {
                this.spatial.removeControl((Control)this);
            }
        }
        if (this.spatial != null) {
            this.label.setLocalTranslation(this.coords != null ? this.coords.add(this.getScreenPos()) : this.getScreenPos());
            if (this.camera.getLocation().distance(this.spatial.getWorldTranslation()) > this.maxDistance || this.camera.getLocation().distance(this.spatial.getWorldTranslation()) < this.minDistance || !this.isInCamera(this.spatial)) {
                if (this.guiNode.hasChild((Spatial)this.label)) {
                    this.guiNode.detachChild((Spatial)this.label);
                }
            } else if (!this.guiNode.hasChild((Spatial)this.label)) {
                this.guiNode.attachChild((Spatial)this.label);
            }
        }
    }

    public void write(JmeExporter ex) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void createLabel() {
        this.label = new Node("txt_" + this.text);
        int size = (int)((float)this.fontSize * this.scale);
        Picture p = new RenderedText(this.renderer.getAssetManager(), this.text, this.fontName, this.fontStyle, size, this.fontColor, this.shadowOffset, this.shadowColor, (Integer)this.renderer.getRenderer().getLimits().get(Limits.TextureSize)).getPicture();
        p.setLocalTranslation(this.offset);
        p.getMaterial().getAdditionalRenderState().setDepthTest(false);
        this.label.attachChild((Spatial)p);
        if (this.coords != null) {
            this.coords.subtractLocal(this.getScreenPos());
        }
    }

    private Vector3f getScreenPos() {
        Vector3f v;
        Vector3f vector3f = v = this.camera != null && this.spatial != null ? this.camera.getScreenCoordinates(this.spatial.getWorldTranslation()) : null;
        if (v != null) {
            v.x = (int)v.x;
            v.y = (int)v.y;
            v.z = (int)v.z;
        }
        return v;
    }

    private boolean isInCamera(Spatial spatial) {
        boolean ret = false;
        BoundingVolume bv = null;
        if (spatial instanceof Node) {
            bv = ((Geometry)((Node)spatial).getChild(0)).getWorldBound();
        } else if (spatial instanceof Geometry) {
            bv = ((Geometry)spatial).getWorldBound();
        }
        if (bv != null) {
            int ss = bv.getCheckPlane();
            int sc = this.camera.getPlaneState();
            bv.setCheckPlane(0);
            this.camera.setPlaneState(0);
            Camera.FrustumIntersect i = this.camera.contains(bv);
            bv.setCheckPlane(ss);
            this.camera.setPlaneState(sc);
            ret = i == Camera.FrustumIntersect.Inside || i == Camera.FrustumIntersect.Intersects;
        }
        return ret;
    }

    public void hide() {
        if (this.spatial != null) {
            this.spatial.removeControl((Control)this);
        }
    }
}

