/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLocator;
import com.jme3.asset.AssetManager;
import com.jme3.scene.plugins.fbx.ContentTextureKey;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContentTextureLocator
implements AssetLocator {
    private static final Logger logger = Logger.getLogger(ContentTextureLocator.class.getName());

    public void setRootPath(String rootPath) {
    }

    public AssetInfo locate(AssetManager manager, AssetKey key) {
        if (key instanceof ContentTextureKey) {
            String name = key.getName();
            byte[] content = ((ContentTextureKey)key).getContent();
            if (content != null) {
                return new ContentAssetInfo(manager, key, content);
            }
            logger.log(Level.WARNING, "No content for " + name);
            return null;
        }
        logger.log(Level.SEVERE, "AssetKey should be TextureContentKey instance");
        return null;
    }

    private class ContentAssetInfo
    extends AssetInfo {
        private InputStream stream;

        public ContentAssetInfo(AssetManager assetManager, AssetKey key, byte[] content) {
            super(assetManager, key);
            this.stream = content != null ? new ByteArrayInputStream(content) : null;
        }

        public InputStream openStream() {
            return this.stream;
        }
    }
}

