/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material.plugin.export.materialdef;

import com.jme3.material.MatParam;
import com.jme3.material.MaterialDef;
import com.jme3.material.TechniqueDef;
import com.jme3.material.plugin.export.materialdef.J3mdMatParamWriter;
import com.jme3.material.plugin.export.materialdef.J3mdTechniqueDefWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;

public class J3mdExporter {
    public void save(MaterialDef matDef, OutputStream f) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(f);
        J3mdMatParamWriter paramWriter = new J3mdMatParamWriter();
        J3mdTechniqueDefWriter techniqueWriter = new J3mdTechniqueDefWriter();
        out.write("MaterialDef " + matDef.getName() + " {\n");
        out.write("    MaterialParameters {\n");
        for (MatParam matParam : matDef.getMaterialParams()) {
            paramWriter.write(matParam, out);
        }
        out.write("    }\n\n");
        for (String key : matDef.getTechniqueDefsNames()) {
            List defs = matDef.getTechniqueDefs(key);
            for (TechniqueDef def : defs) {
                techniqueWriter.write(def, matDef.getMaterialParams(), out);
            }
        }
        out.write("}\n");
        out.flush();
    }

    public void save(MaterialDef matDef, File f) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(f);){
            this.save(matDef, fos);
        }
    }
}

