/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.core.module.visengine.actions;

import java.util.Map;
import javax.script.ScriptException;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.core.module.visengine.actions.Action;
import rs.co.ast.aspen.core.module.visengine.graph.Graph;
import rs.co.ast.aspen.core.module.visengine.graph.Node;
import rs.co.ast.aspen.core.module.visengine.rs.Check;
import rs.co.ast.aspen.core.module.visengine.rs.Ruleset;

public class ConnectNodeAction
extends Action {
    private final Map<String, String> edgeAttributes;
    private final Map<String, String> node1Attributes;
    private final Map<String, String> node2Attributes;

    public static Action fromMap(Map params, Ruleset rs) {
        Map n1a = rs.mergeTemplates(params, "node1_templates", "node1_attributes");
        Map n2a = rs.mergeTemplates(params, "node2_templates", "node2_attributes");
        Map ea = rs.mergeTemplates(params, "edge_templates", "edge_attributes");
        return new ConnectNodeAction(n1a, n2a, ea);
    }

    public ConnectNodeAction(Map<String, String> node1Attrs, Map<String, String> node2Attrs, Map<String, String> edgeAttrs) {
        this.node1Attributes = node1Attrs;
        this.node2Attributes = node2Attrs;
        this.edgeAttributes = edgeAttrs;
    }

    @Override
    public Check.Status execute(Graph graph, SecurityEvent event, Node node) throws ScriptException {
        Node n2;
        Map<String, String> n1a = this.node1Attributes != null ? this.evaluateValues(this.keyAttributes(this.node1Attributes), event, node, graph) : null;
        Map<String, String> n2a = this.node2Attributes != null ? this.evaluateValues(this.keyAttributes(this.node2Attributes), event, node, graph) : null;
        Map<String, String> ea = this.edgeAttributes != null ? this.evaluateValues(this.edgeAttributes, event, node, graph) : null;
        Node n1 = n1a != null ? graph.findNodeByIndexKey(n1a, true) : node;
        Node node2 = n2 = n2a != null ? graph.findNodeByIndexKey(n2a, true) : node;
        if (n1a != null) {
            n1.updateOthers(this.otherAttributes(this.evaluateValues(this.node1Attributes, event, n1, graph)));
        }
        if (n2a != null) {
            n2.updateOthers(this.otherAttributes(this.evaluateValues(this.node2Attributes, event, n2, graph)));
        }
        n1.connect(n2, ea);
        return Check.Status.MATCHED;
    }
}

