/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.shape;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class Sphere
extends Mesh {
    protected int vertCount;
    protected int triCount;
    protected int zSamples;
    protected int radialSamples;
    protected boolean useEvenSlices;
    protected boolean interior;
    public float radius;
    protected TextureMode textureMode = TextureMode.Original;

    public Sphere() {
    }

    public Sphere(int zSamples, int radialSamples, float radius) {
        this(zSamples, radialSamples, radius, false, false);
    }

    public Sphere(int zSamples, int radialSamples, float radius, boolean useEvenSlices, boolean interior) {
        this.updateGeometry(zSamples, radialSamples, radius, useEvenSlices, interior);
    }

    public int getRadialSamples() {
        return this.radialSamples;
    }

    public float getRadius() {
        return this.radius;
    }

    public TextureMode getTextureMode() {
        return this.textureMode;
    }

    public int getZSamples() {
        return this.zSamples;
    }

    private void setGeometryData() {
        this.vertCount = (this.zSamples - 2) * (this.radialSamples + 1) + 2;
        FloatBuffer posBuf = BufferUtils.createVector3Buffer(this.vertCount);
        FloatBuffer normBuf = BufferUtils.createVector3Buffer(this.vertCount);
        FloatBuffer texBuf = BufferUtils.createVector2Buffer(this.vertCount);
        this.setBuffer(VertexBuffer.Type.Position, 3, posBuf);
        this.setBuffer(VertexBuffer.Type.Normal, 3, normBuf);
        this.setBuffer(VertexBuffer.Type.TexCoord, 2, texBuf);
        float fInvRS = 1.0f / (float)this.radialSamples;
        float fZFactor = 2.0f / (float)(this.zSamples - 1);
        float[] afSin = new float[this.radialSamples + 1];
        float[] afCos = new float[this.radialSamples + 1];
        for (int iR = 0; iR < this.radialSamples; ++iR) {
            float fAngle = (float)Math.PI * 2 * fInvRS * (float)iR;
            afCos[iR] = FastMath.cos(fAngle);
            afSin[iR] = FastMath.sin(fAngle);
        }
        afSin[this.radialSamples] = afSin[0];
        afCos[this.radialSamples] = afCos[0];
        TempVars vars = TempVars.get();
        Vector3f tempVa = vars.vect1;
        Vector3f tempVb = vars.vect2;
        Vector3f tempVc = vars.vect3;
        int i = 0;
        for (int iZ = 1; iZ < this.zSamples - 1; ++iZ) {
            float fAFraction = 1.5707964f * (-1.0f + fZFactor * (float)iZ);
            float fZFraction = this.useEvenSlices ? -1.0f + fZFactor * (float)iZ : FastMath.sin(fAFraction);
            float fZ = this.radius * fZFraction;
            Vector3f kSliceCenter = tempVb.set(Vector3f.ZERO);
            kSliceCenter.z += fZ;
            float fSliceRadius = FastMath.sqrt(FastMath.abs(this.radius * this.radius - fZ * fZ));
            int iSave = i;
            for (int iR = 0; iR < this.radialSamples; ++iR) {
                float fRadialFraction = (float)iR * fInvRS;
                Vector3f kRadial = tempVc.set(afCos[iR], afSin[iR], 0.0f);
                kRadial.mult(fSliceRadius, tempVa);
                posBuf.put(kSliceCenter.x + tempVa.x).put(kSliceCenter.y + tempVa.y).put(kSliceCenter.z + tempVa.z);
                BufferUtils.populateFromBuffer(tempVa, posBuf, i);
                Vector3f kNormal = tempVa;
                kNormal.normalizeLocal();
                if (!this.interior) {
                    normBuf.put(kNormal.x).put(kNormal.y).put(kNormal.z);
                } else {
                    normBuf.put(-kNormal.x).put(-kNormal.y).put(-kNormal.z);
                }
                if (this.textureMode == TextureMode.Original) {
                    texBuf.put(fRadialFraction).put(0.5f * (fZFraction + 1.0f));
                } else if (this.textureMode == TextureMode.Projected) {
                    texBuf.put(fRadialFraction).put(0.31830987f * (1.5707964f + FastMath.asin(fZFraction)));
                } else if (this.textureMode == TextureMode.Polar) {
                    float r = (1.5707964f - FastMath.abs(fAFraction)) / (float)Math.PI;
                    float u = r * afCos[iR] + 0.5f;
                    float v = r * afSin[iR] + 0.5f;
                    texBuf.put(u).put(v);
                }
                ++i;
            }
            BufferUtils.copyInternalVector3(posBuf, iSave, i);
            BufferUtils.copyInternalVector3(normBuf, iSave, i);
            if (this.textureMode == TextureMode.Original) {
                texBuf.put(1.0f).put(0.5f * (fZFraction + 1.0f));
            } else if (this.textureMode == TextureMode.Projected) {
                texBuf.put(1.0f).put(0.31830987f * (1.5707964f + FastMath.asin(fZFraction)));
            } else if (this.textureMode == TextureMode.Polar) {
                float r = (1.5707964f - FastMath.abs(fAFraction)) / (float)Math.PI;
                texBuf.put(r + 0.5f).put(0.5f);
            }
            ++i;
        }
        vars.release();
        posBuf.position(i * 3);
        posBuf.put(0.0f).put(0.0f).put(-this.radius);
        normBuf.position(i * 3);
        if (!this.interior) {
            normBuf.put(0.0f).put(0.0f).put(-1.0f);
        } else {
            normBuf.put(0.0f).put(0.0f).put(1.0f);
        }
        texBuf.position(i * 2);
        if (this.textureMode == TextureMode.Polar) {
            texBuf.put(0.5f).put(0.5f);
        } else {
            texBuf.put(0.5f).put(0.0f);
        }
        ++i;
        posBuf.put(0.0f).put(0.0f).put(this.radius);
        if (!this.interior) {
            normBuf.put(0.0f).put(0.0f).put(1.0f);
        } else {
            normBuf.put(0.0f).put(0.0f).put(-1.0f);
        }
        if (this.textureMode == TextureMode.Polar) {
            texBuf.put(0.5f).put(0.5f);
        } else {
            texBuf.put(0.5f).put(1.0f);
        }
        this.updateBound();
    }

    private void setIndexData() {
        this.triCount = 2 * (this.zSamples - 2) * this.radialSamples;
        ShortBuffer idxBuf = BufferUtils.createShortBuffer(3 * this.triCount);
        this.setBuffer(VertexBuffer.Type.Index, 3, idxBuf);
        int index = 0;
        int iZStart = 0;
        for (int iZ = 0; iZ < this.zSamples - 3; ++iZ) {
            int i0 = iZStart;
            int i1 = i0 + 1;
            int i2 = iZStart += this.radialSamples + 1;
            int i3 = i2 + 1;
            int i = 0;
            while (i < this.radialSamples) {
                if (!this.interior) {
                    idxBuf.put((short)i0++);
                    idxBuf.put((short)i1);
                    idxBuf.put((short)i2);
                    idxBuf.put((short)i1++);
                    idxBuf.put((short)i3++);
                    idxBuf.put((short)i2++);
                } else {
                    idxBuf.put((short)i0++);
                    idxBuf.put((short)i2);
                    idxBuf.put((short)i1);
                    idxBuf.put((short)i1++);
                    idxBuf.put((short)i2++);
                    idxBuf.put((short)i3++);
                }
                ++i;
                index += 6;
            }
        }
        int i = 0;
        while (i < this.radialSamples) {
            if (!this.interior) {
                idxBuf.put((short)i);
                idxBuf.put((short)(this.vertCount - 2));
                idxBuf.put((short)(i + 1));
            } else {
                idxBuf.put((short)i);
                idxBuf.put((short)(i + 1));
                idxBuf.put((short)(this.vertCount - 2));
            }
            ++i;
            index += 3;
        }
        int iOffset = (this.zSamples - 3) * (this.radialSamples + 1);
        int i2 = 0;
        while (i2 < this.radialSamples) {
            if (!this.interior) {
                idxBuf.put((short)(i2 + iOffset));
                idxBuf.put((short)(i2 + 1 + iOffset));
                idxBuf.put((short)(this.vertCount - 1));
            } else {
                idxBuf.put((short)(i2 + iOffset));
                idxBuf.put((short)(this.vertCount - 1));
                idxBuf.put((short)(i2 + 1 + iOffset));
            }
            ++i2;
            index += 3;
        }
    }

    public void setTextureMode(TextureMode textureMode) {
        this.textureMode = textureMode;
        this.setGeometryData();
    }

    public void updateGeometry(int zSamples, int radialSamples, float radius) {
        if (zSamples < 3) {
            throw new IllegalArgumentException("zSamples cannot be smaller than 3");
        }
        this.updateGeometry(zSamples, radialSamples, radius, false, false);
    }

    public void updateGeometry(int zSamples, int radialSamples, float radius, boolean useEvenSlices, boolean interior) {
        if (zSamples < 3) {
            throw new IllegalArgumentException("zSamples cannot be smaller than 3");
        }
        this.zSamples = zSamples;
        this.radialSamples = radialSamples;
        this.radius = radius;
        this.useEvenSlices = useEvenSlices;
        this.interior = interior;
        this.setGeometryData();
        this.setIndexData();
        this.setStatic();
    }

    @Override
    public void read(JmeImporter e) throws IOException {
        super.read(e);
        InputCapsule capsule = e.getCapsule(this);
        this.zSamples = capsule.readInt("zSamples", 0);
        this.radialSamples = capsule.readInt("radialSamples", 0);
        this.radius = capsule.readFloat("radius", 0.0f);
        this.useEvenSlices = capsule.readBoolean("useEvenSlices", false);
        this.textureMode = capsule.readEnum("textureMode", TextureMode.class, TextureMode.Original);
        this.interior = capsule.readBoolean("interior", false);
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.zSamples, "zSamples", 0);
        capsule.write(this.radialSamples, "radialSamples", 0);
        capsule.write(this.radius, "radius", 0.0f);
        capsule.write(this.useEvenSlices, "useEvenSlices", false);
        capsule.write(this.textureMode, "textureMode", TextureMode.Original);
        capsule.write(this.interior, "interior", false);
    }

    public static enum TextureMode {
        Original,
        Projected,
        Polar;

    }
}

