/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures.generating;

import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.ColorBand;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.generating.NoiseGenerator;
import com.jme3.texture.Image;

public abstract class TextureGenerator {
    protected NoiseGenerator noiseGenerator;
    protected int flag;
    protected float[][] colorBand;
    protected BrightnessAndContrastData bacd;
    protected Image.Format imageFormat;

    public TextureGenerator(NoiseGenerator noiseGenerator, Image.Format imageFormat) {
        this.noiseGenerator = noiseGenerator;
        this.imageFormat = imageFormat;
    }

    public Image.Format getImageFormat() {
        return this.imageFormat;
    }

    public void readData(Structure tex, BlenderContext blenderContext) {
        this.flag = ((Number)tex.getFieldValue("flag")).intValue();
        this.colorBand = new ColorBand(tex, blenderContext).computeValues();
        this.bacd = new BrightnessAndContrastData(tex);
        if (this.colorBand != null) {
            this.imageFormat = Image.Format.RGBA8;
        }
    }

    public abstract void getPixel(TexturePixel var1, float var2, float var3, float var4);

    protected void applyBrightnessAndContrast(BrightnessAndContrastData bacd, TexturePixel texres) {
        texres.red = (texres.red - 0.5f) * bacd.contrast + bacd.brightness;
        if (texres.red < 0.0f) {
            texres.red = 0.0f;
        }
        texres.green = (texres.green - 0.5f) * bacd.contrast + bacd.brightness;
        if (texres.green < 0.0f) {
            texres.green = 0.0f;
        }
        texres.blue = (texres.blue - 0.5f) * bacd.contrast + bacd.brightness;
        if (texres.blue < 0.0f) {
            texres.blue = 0.0f;
        }
    }

    protected void applyBrightnessAndContrast(TexturePixel texres, float contrast, float brightness) {
        texres.intensity = (texres.intensity - 0.5f) * contrast + brightness;
        if (texres.intensity < 0.0f) {
            texres.intensity = 0.0f;
        } else if (texres.intensity > 1.0f) {
            texres.intensity = 1.0f;
        }
    }

    protected static class BrightnessAndContrastData {
        public final float contrast;
        public final float brightness;
        public final float rFactor;
        public final float gFactor;
        public final float bFactor;

        public BrightnessAndContrastData(Structure tex) {
            this.contrast = ((Number)tex.getFieldValue("contrast")).floatValue();
            this.brightness = ((Number)tex.getFieldValue("bright")).floatValue() - 0.5f;
            this.rFactor = ((Number)tex.getFieldValue("rfac")).floatValue();
            this.gFactor = ((Number)tex.getFieldValue("gfac")).floatValue();
            this.bFactor = ((Number)tex.getFieldValue("bfac")).floatValue();
        }
    }
}

