/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures.blending;

import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.blending.AbstractTextureBlender;
import com.jme3.scene.plugins.blender.textures.io.PixelIOFactory;
import com.jme3.scene.plugins.blender.textures.io.PixelInputOutput;
import com.jme3.texture.Image;
import com.jme3.texture.image.ColorSpace;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class TextureBlenderAWT
extends AbstractTextureBlender {
    public TextureBlenderAWT(int flag, boolean negateTexture, int blendType, float[] materialColor, float[] color, float blendFactor) {
        super(flag, negateTexture, blendType, materialColor, color, blendFactor);
    }

    @Override
    public Image blend(Image image, Image baseImage, BlenderContext blenderContext) {
        Image result;
        this.prepareImagesForBlending(image, baseImage);
        float[] pixelColor = new float[]{this.color[0], this.color[1], this.color[2], 1.0f};
        Image.Format format = image.getFormat();
        PixelInputOutput basePixelIO = null;
        PixelInputOutput pixelReader = PixelIOFactory.getPixelIO(format);
        TexturePixel basePixel = null;
        TexturePixel pixel = new TexturePixel();
        float[] materialColor = this.materialColor;
        if (baseImage != null) {
            basePixelIO = PixelIOFactory.getPixelIO(baseImage.getFormat());
            materialColor = new float[this.materialColor.length];
            basePixel = new TexturePixel();
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int depth = image.getDepth();
        if (depth == 0) {
            depth = 1;
        }
        int bytesPerPixel = image.getFormat().getBitsPerPixel() >> 3;
        ArrayList<ByteBuffer> dataArray = new ArrayList<ByteBuffer>(depth);
        float[] resultPixel = new float[4];
        for (int dataLayerIndex = 0; dataLayerIndex < depth; ++dataLayerIndex) {
            ByteBuffer data = image.getData(dataLayerIndex);
            data.rewind();
            int imagePixelCount = data.limit() / bytesPerPixel;
            ByteBuffer newData = BufferUtils.createByteBuffer((int)(imagePixelCount * 4));
            int dataIndex = 0;
            int x = 0;
            int y = 0;
            int index = 0;
            while (index < data.limit()) {
                if (basePixelIO != null) {
                    basePixelIO.read(baseImage, dataLayerIndex, basePixel, x, y);
                    basePixel.toRGBA(materialColor);
                    if (++x >= width) {
                        x = 0;
                        ++y;
                    }
                }
                pixelReader.read(image, dataLayerIndex, pixel, index);
                index += bytesPerPixel;
                pixel.toRGBA(pixelColor);
                if (this.negateTexture) {
                    pixel.negate();
                }
                this.blendPixel(resultPixel, materialColor, pixelColor, blenderContext);
                newData.put(dataIndex++, (byte)(resultPixel[0] * 255.0f));
                newData.put(dataIndex++, (byte)(resultPixel[1] * 255.0f));
                newData.put(dataIndex++, (byte)(resultPixel[2] * 255.0f));
                newData.put(dataIndex++, (byte)(pixelColor[3] * 255.0f));
            }
            dataArray.add(newData);
        }
        Image image2 = result = depth > 1 ? new Image(Image.Format.RGBA8, width, height, depth, dataArray, ColorSpace.Linear) : new Image(Image.Format.RGBA8, width, height, (ByteBuffer)dataArray.get(0), ColorSpace.Linear);
        if (image.getMipMapSizes() != null) {
            result.setMipMapSizes((int[])image.getMipMapSizes().clone());
        }
        return result;
    }

    protected void blendPixel(float[] result, float[] materialColor, float[] pixelColor, BlenderContext blenderContext) {
        float blendFactor = this.blendFactor * pixelColor[3];
        float oneMinusFactor = (1.0f - blendFactor) * materialColor[3];
        blendFactor = 1.0f - oneMinusFactor;
        switch (this.blendType) {
            case 0: {
                result[0] = blendFactor * pixelColor[0] + oneMinusFactor * materialColor[0];
                result[1] = blendFactor * pixelColor[1] + oneMinusFactor * materialColor[1];
                result[2] = blendFactor * pixelColor[2] + oneMinusFactor * materialColor[2];
                break;
            }
            case 1: {
                result[0] = (oneMinusFactor + blendFactor * materialColor[0]) * pixelColor[0];
                result[1] = (oneMinusFactor + blendFactor * materialColor[1]) * pixelColor[1];
                result[2] = (oneMinusFactor + blendFactor * materialColor[2]) * pixelColor[2];
                break;
            }
            case 4: {
                if ((double)pixelColor[0] != 0.0) {
                    result[0] = (oneMinusFactor * materialColor[0] + blendFactor * materialColor[0] / pixelColor[0]) * 0.5f;
                }
                if ((double)pixelColor[1] != 0.0) {
                    result[1] = (oneMinusFactor * materialColor[1] + blendFactor * materialColor[1] / pixelColor[1]) * 0.5f;
                }
                if ((double)pixelColor[2] == 0.0) break;
                result[2] = (oneMinusFactor * materialColor[2] + blendFactor * materialColor[2] / pixelColor[2]) * 0.5f;
                break;
            }
            case 8: {
                result[0] = 1.0f - (oneMinusFactor + blendFactor * (1.0f - materialColor[0])) * (1.0f - pixelColor[0]);
                result[1] = 1.0f - (oneMinusFactor + blendFactor * (1.0f - materialColor[1])) * (1.0f - pixelColor[1]);
                result[2] = 1.0f - (oneMinusFactor + blendFactor * (1.0f - materialColor[2])) * (1.0f - pixelColor[2]);
                break;
            }
            case 9: {
                result[0] = materialColor[0] < 0.5f ? pixelColor[0] * (oneMinusFactor + 2.0f * blendFactor * materialColor[0]) : 1.0f - (oneMinusFactor + 2.0f * blendFactor * (1.0f - materialColor[0])) * (1.0f - pixelColor[0]);
                result[1] = materialColor[1] < 0.5f ? pixelColor[1] * (oneMinusFactor + 2.0f * blendFactor * materialColor[1]) : 1.0f - (oneMinusFactor + 2.0f * blendFactor * (1.0f - materialColor[1])) * (1.0f - pixelColor[1]);
                if (materialColor[2] < 0.5f) {
                    result[2] = pixelColor[2] * (oneMinusFactor + 2.0f * blendFactor * materialColor[2]);
                    break;
                }
                result[2] = 1.0f - (oneMinusFactor + 2.0f * blendFactor * (1.0f - materialColor[2])) * (1.0f - pixelColor[2]);
                break;
            }
            case 3: {
                result[0] = materialColor[0] - blendFactor * pixelColor[0];
                result[1] = materialColor[1] - blendFactor * pixelColor[1];
                result[2] = materialColor[2] - blendFactor * pixelColor[2];
                result[0] = FastMath.clamp((float)result[0], (float)0.0f, (float)1.0f);
                result[1] = FastMath.clamp((float)result[1], (float)0.0f, (float)1.0f);
                result[2] = FastMath.clamp((float)result[2], (float)0.0f, (float)1.0f);
                break;
            }
            case 2: {
                result[0] = (blendFactor * pixelColor[0] + materialColor[0]) * 0.5f;
                result[1] = (blendFactor * pixelColor[1] + materialColor[1]) * 0.5f;
                result[2] = (blendFactor * pixelColor[2] + materialColor[2]) * 0.5f;
                break;
            }
            case 6: {
                result[0] = oneMinusFactor * materialColor[0] + blendFactor * Math.abs(materialColor[0] - pixelColor[0]);
                result[1] = oneMinusFactor * materialColor[1] + blendFactor * Math.abs(materialColor[1] - pixelColor[1]);
                result[2] = oneMinusFactor * materialColor[2] + blendFactor * Math.abs(materialColor[2] - pixelColor[2]);
                break;
            }
            case 5: {
                float col = blendFactor * pixelColor[0];
                result[0] = col < materialColor[0] ? col : materialColor[0];
                col = blendFactor * pixelColor[1];
                result[1] = col < materialColor[1] ? col : materialColor[1];
                col = blendFactor * pixelColor[2];
                result[2] = col < materialColor[2] ? col : materialColor[2];
                break;
            }
            case 7: {
                float col = blendFactor * pixelColor[0];
                result[0] = col > materialColor[0] ? col : materialColor[0];
                col = blendFactor * pixelColor[1];
                result[1] = col > materialColor[1] ? col : materialColor[1];
                col = blendFactor * pixelColor[2];
                result[2] = col > materialColor[2] ? col : materialColor[2];
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                System.arraycopy(materialColor, 0, result, 0, 3);
                this.blendHSV(this.blendType, result, blendFactor, pixelColor, blenderContext);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown blend type: " + this.blendType);
            }
        }
    }
}

