/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.meshes;

import com.jme3.scene.plugins.blender.file.BlenderFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IndexesLoop
implements Comparator<Integer>,
Iterable<Integer> {
    public static final IndexPredicate INDEX_PREDICATE_USE_ALL = new IndexPredicate(){

        @Override
        public boolean execute(Integer index) {
            return true;
        }
    };
    private List<Integer> nodes;
    private Map<Integer, List<Integer>> edges = new HashMap<Integer, List<Integer>>();

    public IndexesLoop(Integer[] nodes) {
        this.nodes = new ArrayList<Integer>(Arrays.asList(nodes));
        this.prepareEdges(this.nodes);
    }

    public IndexesLoop clone() {
        return new IndexesLoop(this.nodes.toArray(new Integer[this.nodes.size()]));
    }

    private void prepareEdges(List<Integer> nodes) {
        for (int i = 0; i < nodes.size() - 1; ++i) {
            if (this.edges.containsKey(nodes.get(i))) {
                this.edges.get(nodes.get(i)).add(nodes.get(i + 1));
                continue;
            }
            this.edges.put(nodes.get(i), new ArrayList<Integer>(Arrays.asList(nodes.get(i + 1))));
        }
        this.edges.put(nodes.get(nodes.size() - 1), new ArrayList<Integer>(Arrays.asList(nodes.get(0))));
    }

    public int size() {
        return this.nodes.size();
    }

    public void addEdge(Integer from, Integer to) {
        if (this.nodes.contains(from) && this.nodes.contains(to) && this.edges.containsKey(from) && !this.edges.get(from).contains(to)) {
            this.edges.get(from).add(to);
        }
    }

    public boolean removeEdge(Integer node1, Integer node2) {
        boolean edgeRemoved = false;
        if (this.nodes.contains(node1) && this.nodes.contains(node2)) {
            if (this.edges.containsKey(node1)) {
                edgeRemoved |= this.edges.get(node1).remove(node2);
            }
            if (this.edges.containsKey(node2)) {
                edgeRemoved |= this.edges.get(node2).remove(node1);
            }
            if (edgeRemoved) {
                if (this.getNeighbourCount(node1) == 0) {
                    this.removeIndexes(node1);
                }
                if (this.getNeighbourCount(node2) == 0) {
                    this.removeIndexes(node2);
                }
            }
        }
        return edgeRemoved;
    }

    public boolean areNeighbours(Integer index1, Integer index2) {
        if (index1.equals(index2) || !this.edges.containsKey(index1) || !this.edges.containsKey(index2)) {
            return false;
        }
        return this.edges.get(index1).contains(index2) || this.edges.get(index2).contains(index1);
    }

    public Integer getNextIndex(Integer index) {
        int i = this.nodes.indexOf(index);
        return i == this.nodes.size() - 1 ? this.nodes.get(0) : this.nodes.get(i + 1);
    }

    public Integer getPreviousIndex(Integer index) {
        int i = this.nodes.indexOf(index);
        return i == 0 ? this.nodes.get(this.nodes.size() - 1) : this.nodes.get(i - 1);
    }

    public void shiftIndexes(int shift, IndexPredicate predicate) {
        if (predicate == null) {
            predicate = INDEX_PREDICATE_USE_ALL;
        }
        ArrayList<Integer> nodes = new ArrayList<Integer>(this.nodes.size());
        for (Integer node : this.nodes) {
            nodes.add(node + (predicate.execute(node) ? shift : 0));
        }
        HashMap<Integer, List<Integer>> edges = new HashMap<Integer, List<Integer>>();
        for (Map.Entry<Integer, List<Integer>> entry : this.edges.entrySet()) {
            ArrayList<Integer> neighbours = new ArrayList<Integer>(entry.getValue().size());
            for (Integer neighbour : entry.getValue()) {
                neighbours.add(neighbour + (predicate.execute(neighbour) ? shift : 0));
            }
            edges.put(entry.getKey() + shift, neighbours);
        }
        this.nodes = nodes;
        this.edges = edges;
    }

    public void reverse() {
        Collections.reverse(this.nodes);
        this.edges.clear();
        this.prepareEdges(this.nodes);
    }

    private int getNeighbourCount(Integer index) {
        int result = 0;
        if (this.edges.containsKey(index)) {
            result = this.edges.get(index).size();
            for (List<Integer> neighbours : this.edges.values()) {
                if (!neighbours.contains(index)) continue;
                ++result;
            }
        }
        return result;
    }

    public int indexOf(Integer index) {
        return this.nodes.indexOf(index);
    }

    public Integer get(int indexPosition) {
        return this.nodes.get(indexPosition);
    }

    public List<Integer> getAll() {
        return new ArrayList<Integer>(this.nodes);
    }

    public void removeIndexes(Integer ... indexes) {
        for (Integer index : indexes) {
            this.nodes.remove(index);
            this.edges.remove(index);
            for (List<Integer> neighbours : this.edges.values()) {
                neighbours.remove(index);
            }
        }
    }

    public void findPath(Integer start, Integer end, List<Integer> result) throws BlenderFileException {
        result.clear();
        Integer node = start;
        while (!node.equals(end)) {
            if (result.contains(node)) {
                throw new BlenderFileException("Indexes of face have infinite loops!");
            }
            result.add(node);
            List<Integer> nextSteps = this.edges.get(node);
            if (nextSteps == null || nextSteps.size() == 0) {
                result.clear();
                return;
            }
            if (nextSteps.size() == 1) {
                node = nextSteps.get(0);
                continue;
            }
            throw new BlenderFileException("Triangulation failed. Face has ambiguous indexes loop. Please triangulate your model in Blender as a workaround.");
        }
        result.add(end);
    }

    public String toString() {
        return "IndexesLoop " + this.nodes.toString();
    }

    @Override
    public int compare(Integer i1, Integer i2) {
        return this.nodes.indexOf(i1) - this.nodes.indexOf(i2);
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.nodes.iterator();
    }

    public static interface IndexPredicate {
        public boolean execute(Integer var1);
    }
}

