/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util.blockparser;

import java.util.ArrayList;
import java.util.List;

public class Statement {
    protected int lineNumber;
    protected String line;
    protected List<Statement> contents = new ArrayList<Statement>();

    protected Statement(int lineNumber, String line) {
        this.lineNumber = lineNumber;
        this.line = line;
    }

    protected void addStatement(Statement statement) {
        this.contents.add(statement);
    }

    protected void addStatement(int index, Statement statement) {
        this.contents.add(index, statement);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getLine() {
        return this.line;
    }

    public List<Statement> getContents() {
        return this.contents;
    }

    protected String getIndent(int indent) {
        return "                               ".substring(0, indent);
    }

    protected String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getIndent(indent));
        sb.append(this.line);
        if (this.contents != null) {
            sb.append(" {\n");
            for (Statement statement : this.contents) {
                sb.append(statement.toString(indent + 4));
                sb.append("\n");
            }
            sb.append(this.getIndent(indent));
            sb.append("}");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(0);
    }
}

