/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix4f;
import com.jme3.math.Plane;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Camera
implements Savable,
Cloneable {
    private static final Logger logger = Logger.getLogger(Camera.class.getName());
    private static final int LEFT_PLANE = 0;
    private static final int RIGHT_PLANE = 1;
    private static final int BOTTOM_PLANE = 2;
    private static final int TOP_PLANE = 3;
    private static final int FAR_PLANE = 4;
    private static final int NEAR_PLANE = 5;
    private static final int FRUSTUM_PLANES = 6;
    private static final int MAX_WORLD_PLANES = 6;
    protected Vector3f location;
    protected Quaternion rotation;
    protected float frustumNear;
    protected float frustumFar;
    protected float frustumLeft;
    protected float frustumRight;
    protected float frustumTop;
    protected float frustumBottom;
    protected float[] coeffLeft;
    protected float[] coeffRight;
    protected float[] coeffBottom;
    protected float[] coeffTop;
    protected float viewPortLeft;
    protected float viewPortRight;
    protected float viewPortTop;
    protected float viewPortBottom;
    protected Plane[] worldPlane;
    private int planeState;
    protected int width;
    protected int height;
    protected boolean viewportChanged = true;
    private boolean parallelProjection = true;
    protected Matrix4f projectionMatrixOverride = new Matrix4f();
    private boolean overrideProjection;
    protected Matrix4f viewMatrix = new Matrix4f();
    protected Matrix4f projectionMatrix = new Matrix4f();
    protected Matrix4f viewProjectionMatrix = new Matrix4f();
    private BoundingBox guiBounding = new BoundingBox();
    protected String name;

    public Camera() {
        this.worldPlane = new Plane[6];
        for (int i = 0; i < 6; ++i) {
            this.worldPlane[i] = new Plane();
        }
    }

    public Camera(int width, int height) {
        this();
        this.location = new Vector3f();
        this.rotation = new Quaternion();
        this.frustumNear = 1.0f;
        this.frustumFar = 2.0f;
        this.frustumLeft = -0.5f;
        this.frustumRight = 0.5f;
        this.frustumTop = 0.5f;
        this.frustumBottom = -0.5f;
        this.coeffLeft = new float[2];
        this.coeffRight = new float[2];
        this.coeffBottom = new float[2];
        this.coeffTop = new float[2];
        this.viewPortLeft = 0.0f;
        this.viewPortRight = 1.0f;
        this.viewPortTop = 1.0f;
        this.viewPortBottom = 0.0f;
        this.width = width;
        this.height = height;
        this.onFrustumChange();
        this.onViewPortChange();
        this.onFrameChange();
        logger.log(Level.FINE, "Camera created (W: {0}, H: {1})", new Object[]{width, height});
    }

    public Camera clone() {
        try {
            Camera cam = (Camera)super.clone();
            cam.viewportChanged = true;
            cam.planeState = 0;
            cam.worldPlane = new Plane[6];
            for (int i = 0; i < this.worldPlane.length; ++i) {
                cam.worldPlane[i] = this.worldPlane[i].clone();
            }
            cam.coeffLeft = new float[2];
            cam.coeffRight = new float[2];
            cam.coeffBottom = new float[2];
            cam.coeffTop = new float[2];
            cam.location = this.location.clone();
            cam.rotation = this.rotation.clone();
            if (this.projectionMatrixOverride != null) {
                cam.projectionMatrixOverride = this.projectionMatrixOverride.clone();
            }
            cam.viewMatrix = this.viewMatrix.clone();
            cam.projectionMatrix = this.projectionMatrix.clone();
            cam.viewProjectionMatrix = this.viewProjectionMatrix.clone();
            cam.guiBounding = (BoundingBox)this.guiBounding.clone();
            cam.update();
            return cam;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public void copyFrom(Camera cam) {
        this.location.set(cam.location);
        this.rotation.set(cam.rotation);
        this.frustumNear = cam.frustumNear;
        this.frustumFar = cam.frustumFar;
        this.frustumLeft = cam.frustumLeft;
        this.frustumRight = cam.frustumRight;
        this.frustumTop = cam.frustumTop;
        this.frustumBottom = cam.frustumBottom;
        this.coeffLeft[0] = cam.coeffLeft[0];
        this.coeffLeft[1] = cam.coeffLeft[1];
        this.coeffRight[0] = cam.coeffRight[0];
        this.coeffRight[1] = cam.coeffRight[1];
        this.coeffBottom[0] = cam.coeffBottom[0];
        this.coeffBottom[1] = cam.coeffBottom[1];
        this.coeffTop[0] = cam.coeffTop[0];
        this.coeffTop[1] = cam.coeffTop[1];
        this.viewPortLeft = cam.viewPortLeft;
        this.viewPortRight = cam.viewPortRight;
        this.viewPortTop = cam.viewPortTop;
        this.viewPortBottom = cam.viewPortBottom;
        this.width = cam.width;
        this.height = cam.height;
        this.planeState = 0;
        this.viewportChanged = true;
        for (int i = 0; i < 6; ++i) {
            this.worldPlane[i].setNormal(cam.worldPlane[i].getNormal());
            this.worldPlane[i].setConstant(cam.worldPlane[i].getConstant());
        }
        this.parallelProjection = cam.parallelProjection;
        this.overrideProjection = cam.overrideProjection;
        this.projectionMatrixOverride.set(cam.projectionMatrixOverride);
        this.viewMatrix.set(cam.viewMatrix);
        this.projectionMatrix.set(cam.projectionMatrix);
        this.viewProjectionMatrix.set(cam.viewProjectionMatrix);
        this.guiBounding.setXExtent(cam.guiBounding.getXExtent());
        this.guiBounding.setYExtent(cam.guiBounding.getYExtent());
        this.guiBounding.setZExtent(cam.guiBounding.getZExtent());
        this.guiBounding.setCenter(cam.guiBounding.getCenter());
        this.guiBounding.setCheckPlane(cam.guiBounding.getCheckPlane());
        this.name = cam.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClipPlane(Plane clipPlane, Plane.Side side) {
        float sideFactor = 1.0f;
        if (side == Plane.Side.Negative) {
            sideFactor = -1.0f;
        }
        if (clipPlane.whichSide(this.location) == side) {
            return;
        }
        TempVars vars = TempVars.get();
        try {
            Matrix4f p = this.projectionMatrixOverride.set(this.projectionMatrix);
            Matrix4f ivm = this.viewMatrix;
            Vector3f point = clipPlane.getNormal().mult(clipPlane.getConstant(), vars.vect1);
            Vector3f pp = ivm.mult(point, vars.vect2);
            Vector3f pn = ivm.multNormal(clipPlane.getNormal(), vars.vect3);
            Vector4f clipPlaneV = vars.vect4f1.set(pn.x * sideFactor, pn.y * sideFactor, pn.z * sideFactor, -pp.dot(pn) * sideFactor);
            Vector4f v = vars.vect4f2.set(0.0f, 0.0f, 0.0f, 0.0f);
            v.x = (Math.signum(clipPlaneV.x) + p.m02) / p.m00;
            v.y = (Math.signum(clipPlaneV.y) + p.m12) / p.m11;
            v.z = -1.0f;
            v.w = (1.0f + p.m22) / p.m23;
            float dot = clipPlaneV.dot(v);
            Vector4f c = clipPlaneV.multLocal(2.0f / dot);
            p.m20 = c.x - p.m30;
            p.m21 = c.y - p.m31;
            p.m22 = c.z - p.m32;
            p.m23 = c.w - p.m33;
            this.setProjectionMatrix(p);
        }
        finally {
            vars.release();
        }
    }

    public void setClipPlane(Plane clipPlane) {
        this.setClipPlane(clipPlane, clipPlane.whichSide(this.location));
    }

    public void resize(int width, int height, boolean fixAspect) {
        this.width = width;
        this.height = height;
        this.onViewPortChange();
        if (fixAspect) {
            float h = (float)height * (this.viewPortTop - this.viewPortBottom);
            float w = (float)width * (this.viewPortRight - this.viewPortLeft);
            float aspectRatio = w / h;
            this.frustumRight = this.frustumTop * aspectRatio;
            this.frustumLeft = -this.frustumRight;
            this.onFrustumChange();
        }
    }

    public float getFrustumBottom() {
        return this.frustumBottom;
    }

    public void setFrustumBottom(float frustumBottom) {
        this.frustumBottom = frustumBottom;
        this.onFrustumChange();
    }

    public float getFrustumFar() {
        return this.frustumFar;
    }

    public void setFrustumFar(float frustumFar) {
        this.frustumFar = frustumFar;
        this.onFrustumChange();
    }

    public float getFrustumLeft() {
        return this.frustumLeft;
    }

    public void setFrustumLeft(float frustumLeft) {
        this.frustumLeft = frustumLeft;
        this.onFrustumChange();
    }

    public float getFrustumNear() {
        return this.frustumNear;
    }

    public void setFrustumNear(float frustumNear) {
        this.frustumNear = frustumNear;
        this.onFrustumChange();
    }

    public float getFrustumRight() {
        return this.frustumRight;
    }

    public void setFrustumRight(float frustumRight) {
        this.frustumRight = frustumRight;
        this.onFrustumChange();
    }

    public float getFrustumTop() {
        return this.frustumTop;
    }

    public void setFrustumTop(float frustumTop) {
        this.frustumTop = frustumTop;
        this.onFrustumChange();
    }

    public Vector3f getLocation() {
        return this.location;
    }

    public Quaternion getRotation() {
        return this.rotation;
    }

    public Vector3f getDirection() {
        return this.rotation.getRotationColumn(2);
    }

    public Vector3f getLeft() {
        return this.rotation.getRotationColumn(0);
    }

    public Vector3f getUp() {
        return this.rotation.getRotationColumn(1);
    }

    public Vector3f getDirection(Vector3f store) {
        return this.rotation.getRotationColumn(2, store);
    }

    public Vector3f getLeft(Vector3f store) {
        return this.rotation.getRotationColumn(0, store);
    }

    public Vector3f getUp(Vector3f store) {
        return this.rotation.getRotationColumn(1, store);
    }

    public void setLocation(Vector3f location) {
        this.location.set(location);
        this.onFrameChange();
    }

    public void setRotation(Quaternion rotation) {
        this.rotation.set(rotation);
        this.onFrameChange();
    }

    public void lookAtDirection(Vector3f direction, Vector3f up) {
        this.rotation.lookAt(direction, up);
        this.onFrameChange();
    }

    public void setAxes(Vector3f left, Vector3f up, Vector3f direction) {
        this.rotation.fromAxes(left, up, direction);
        this.onFrameChange();
    }

    public void setAxes(Quaternion axes) {
        this.rotation.set(axes);
        this.onFrameChange();
    }

    public void normalize() {
        this.rotation.normalizeLocal();
        this.onFrameChange();
    }

    public void setFrustum(float near, float far, float left, float right, float top, float bottom) {
        this.frustumNear = near;
        this.frustumFar = far;
        this.frustumLeft = left;
        this.frustumRight = right;
        this.frustumTop = top;
        this.frustumBottom = bottom;
        this.onFrustumChange();
    }

    public void setFrustumPerspective(float fovY, float aspect, float near, float far) {
        if (Float.isNaN(aspect) || Float.isInfinite(aspect)) {
            logger.log(Level.WARNING, "Invalid aspect given to setFrustumPerspective: {0}", Float.valueOf(aspect));
            return;
        }
        float h = FastMath.tan(fovY * ((float)Math.PI / 180) * 0.5f) * near;
        float w = h * aspect;
        this.frustumLeft = -w;
        this.frustumRight = w;
        this.frustumBottom = -h;
        this.frustumTop = h;
        this.frustumNear = near;
        this.frustumFar = far;
        this.parallelProjection = false;
        this.onFrustumChange();
    }

    public void setFrame(Vector3f location, Vector3f left, Vector3f up, Vector3f direction) {
        this.location = location;
        this.rotation.fromAxes(left, up, direction);
        this.onFrameChange();
    }

    public void lookAt(Vector3f pos, Vector3f worldUpVector) {
        TempVars vars = TempVars.get();
        Vector3f newDirection = vars.vect1;
        Vector3f newUp = vars.vect2;
        Vector3f newLeft = vars.vect3;
        newDirection.set(pos).subtractLocal(this.location).normalizeLocal();
        newUp.set(worldUpVector).normalizeLocal();
        if (newUp.equals(Vector3f.ZERO)) {
            newUp.set(Vector3f.UNIT_Y);
        }
        newLeft.set(newUp).crossLocal(newDirection).normalizeLocal();
        if (newLeft.equals(Vector3f.ZERO)) {
            if (newDirection.x != 0.0f) {
                newLeft.set(newDirection.y, -newDirection.x, 0.0f);
            } else {
                newLeft.set(0.0f, newDirection.z, -newDirection.y);
            }
        }
        newUp.set(newDirection).crossLocal(newLeft).normalizeLocal();
        this.rotation.fromAxes(newLeft, newUp, newDirection);
        this.rotation.normalizeLocal();
        vars.release();
        this.onFrameChange();
    }

    public void setFrame(Vector3f location, Quaternion axes) {
        this.location = location;
        this.rotation.set(axes);
        this.onFrameChange();
    }

    public void update() {
        this.onFrustumChange();
        this.onViewPortChange();
    }

    public int getPlaneState() {
        return this.planeState;
    }

    public void setPlaneState(int planeState) {
        this.planeState = planeState;
    }

    public float getViewPortLeft() {
        return this.viewPortLeft;
    }

    public void setViewPortLeft(float left) {
        this.viewPortLeft = left;
        this.onViewPortChange();
    }

    public float getViewPortRight() {
        return this.viewPortRight;
    }

    public void setViewPortRight(float right) {
        this.viewPortRight = right;
        this.onViewPortChange();
    }

    public float getViewPortTop() {
        return this.viewPortTop;
    }

    public void setViewPortTop(float top) {
        this.viewPortTop = top;
        this.onViewPortChange();
    }

    public float getViewPortBottom() {
        return this.viewPortBottom;
    }

    public void setViewPortBottom(float bottom) {
        this.viewPortBottom = bottom;
        this.onViewPortChange();
    }

    public void setViewPort(float left, float right, float bottom, float top) {
        this.viewPortLeft = left;
        this.viewPortRight = right;
        this.viewPortBottom = bottom;
        this.viewPortTop = top;
        this.onViewPortChange();
    }

    public float distanceToNearPlane(Vector3f pos) {
        return this.worldPlane[5].pseudoDistance(pos);
    }

    public FrustumIntersect contains(BoundingVolume bound) {
        if (bound == null) {
            return FrustumIntersect.Inside;
        }
        FrustumIntersect rVal = FrustumIntersect.Inside;
        for (int planeCounter = 6; planeCounter >= 0; --planeCounter) {
            int planeId;
            int mask;
            if (planeCounter == bound.getCheckPlane() || (this.planeState & (mask = 1 << (planeId = planeCounter == 6 ? bound.getCheckPlane() : planeCounter))) != 0) continue;
            Plane.Side side = bound.whichSide(this.worldPlane[planeId]);
            if (side == Plane.Side.Negative) {
                bound.setCheckPlane(planeId);
                return FrustumIntersect.Outside;
            }
            if (side == Plane.Side.Positive) {
                this.planeState |= mask;
                continue;
            }
            rVal = FrustumIntersect.Intersects;
        }
        return rVal;
    }

    public Plane getWorldPlane(int planeId) {
        return this.worldPlane[planeId];
    }

    public boolean containsGui(BoundingVolume bound) {
        if (bound == null) {
            return true;
        }
        return this.guiBounding.intersects(bound);
    }

    public Matrix4f getViewMatrix() {
        return this.viewMatrix;
    }

    public void setProjectionMatrix(Matrix4f projMatrix) {
        if (projMatrix == null) {
            this.overrideProjection = false;
            this.projectionMatrixOverride.loadIdentity();
        } else {
            this.overrideProjection = true;
            this.projectionMatrixOverride.set(projMatrix);
        }
        this.updateViewProjection();
    }

    public Matrix4f getProjectionMatrix() {
        if (this.overrideProjection) {
            return this.projectionMatrixOverride;
        }
        return this.projectionMatrix;
    }

    public void updateViewProjection() {
        if (this.overrideProjection) {
            this.viewProjectionMatrix.set(this.projectionMatrixOverride).multLocal(this.viewMatrix);
        } else {
            this.viewProjectionMatrix.set(this.projectionMatrix).multLocal(this.viewMatrix);
        }
    }

    public Matrix4f getViewProjectionMatrix() {
        return this.viewProjectionMatrix;
    }

    public boolean isViewportChanged() {
        return this.viewportChanged;
    }

    public void clearViewportChanged() {
        this.viewportChanged = false;
    }

    public void onViewPortChange() {
        this.viewportChanged = true;
        this.setGuiBounding();
    }

    private void setGuiBounding() {
        float sx = (float)this.width * this.viewPortLeft;
        float ex = (float)this.width * this.viewPortRight;
        float sy = (float)this.height * this.viewPortBottom;
        float ey = (float)this.height * this.viewPortTop;
        float xExtent = Math.max(0.0f, (ex - sx) / 2.0f);
        float yExtent = Math.max(0.0f, (ey - sy) / 2.0f);
        this.guiBounding.setCenter(sx + xExtent, sy + yExtent, 0.0f);
        this.guiBounding.setXExtent(xExtent);
        this.guiBounding.setYExtent(yExtent);
        this.guiBounding.setZExtent(Float.MAX_VALUE);
    }

    public void onFrustumChange() {
        if (!this.isParallelProjection()) {
            float nearSquared = this.frustumNear * this.frustumNear;
            float leftSquared = this.frustumLeft * this.frustumLeft;
            float rightSquared = this.frustumRight * this.frustumRight;
            float bottomSquared = this.frustumBottom * this.frustumBottom;
            float topSquared = this.frustumTop * this.frustumTop;
            float inverseLength = FastMath.invSqrt(nearSquared + leftSquared);
            this.coeffLeft[0] = -this.frustumNear * inverseLength;
            this.coeffLeft[1] = -this.frustumLeft * inverseLength;
            inverseLength = FastMath.invSqrt(nearSquared + rightSquared);
            this.coeffRight[0] = this.frustumNear * inverseLength;
            this.coeffRight[1] = this.frustumRight * inverseLength;
            inverseLength = FastMath.invSqrt(nearSquared + bottomSquared);
            this.coeffBottom[0] = this.frustumNear * inverseLength;
            this.coeffBottom[1] = -this.frustumBottom * inverseLength;
            inverseLength = FastMath.invSqrt(nearSquared + topSquared);
            this.coeffTop[0] = -this.frustumNear * inverseLength;
            this.coeffTop[1] = this.frustumTop * inverseLength;
        } else {
            this.coeffLeft[0] = 1.0f;
            this.coeffLeft[1] = 0.0f;
            this.coeffRight[0] = -1.0f;
            this.coeffRight[1] = 0.0f;
            this.coeffBottom[0] = 1.0f;
            this.coeffBottom[1] = 0.0f;
            this.coeffTop[0] = -1.0f;
            this.coeffTop[1] = 0.0f;
        }
        this.projectionMatrix.fromFrustum(this.frustumNear, this.frustumFar, this.frustumLeft, this.frustumRight, this.frustumTop, this.frustumBottom, this.parallelProjection);
        this.onFrameChange();
    }

    public void onFrameChange() {
        TempVars vars = TempVars.get();
        Vector3f left = this.getLeft(vars.vect1);
        Vector3f direction = this.getDirection(vars.vect2);
        Vector3f up = this.getUp(vars.vect3);
        float dirDotLocation = direction.dot(this.location);
        Vector3f leftPlaneNormal = this.worldPlane[0].getNormal();
        leftPlaneNormal.x = left.x * this.coeffLeft[0];
        leftPlaneNormal.y = left.y * this.coeffLeft[0];
        leftPlaneNormal.z = left.z * this.coeffLeft[0];
        leftPlaneNormal.addLocal(direction.x * this.coeffLeft[1], direction.y * this.coeffLeft[1], direction.z * this.coeffLeft[1]);
        this.worldPlane[0].setConstant(this.location.dot(leftPlaneNormal));
        Vector3f rightPlaneNormal = this.worldPlane[1].getNormal();
        rightPlaneNormal.x = left.x * this.coeffRight[0];
        rightPlaneNormal.y = left.y * this.coeffRight[0];
        rightPlaneNormal.z = left.z * this.coeffRight[0];
        rightPlaneNormal.addLocal(direction.x * this.coeffRight[1], direction.y * this.coeffRight[1], direction.z * this.coeffRight[1]);
        this.worldPlane[1].setConstant(this.location.dot(rightPlaneNormal));
        Vector3f bottomPlaneNormal = this.worldPlane[2].getNormal();
        bottomPlaneNormal.x = up.x * this.coeffBottom[0];
        bottomPlaneNormal.y = up.y * this.coeffBottom[0];
        bottomPlaneNormal.z = up.z * this.coeffBottom[0];
        bottomPlaneNormal.addLocal(direction.x * this.coeffBottom[1], direction.y * this.coeffBottom[1], direction.z * this.coeffBottom[1]);
        this.worldPlane[2].setConstant(this.location.dot(bottomPlaneNormal));
        Vector3f topPlaneNormal = this.worldPlane[3].getNormal();
        topPlaneNormal.x = up.x * this.coeffTop[0];
        topPlaneNormal.y = up.y * this.coeffTop[0];
        topPlaneNormal.z = up.z * this.coeffTop[0];
        topPlaneNormal.addLocal(direction.x * this.coeffTop[1], direction.y * this.coeffTop[1], direction.z * this.coeffTop[1]);
        this.worldPlane[3].setConstant(this.location.dot(topPlaneNormal));
        if (this.isParallelProjection()) {
            this.worldPlane[0].setConstant(this.worldPlane[0].getConstant() + this.frustumLeft);
            this.worldPlane[1].setConstant(this.worldPlane[1].getConstant() - this.frustumRight);
            this.worldPlane[3].setConstant(this.worldPlane[3].getConstant() - this.frustumTop);
            this.worldPlane[2].setConstant(this.worldPlane[2].getConstant() + this.frustumBottom);
        }
        this.worldPlane[4].setNormal(left);
        this.worldPlane[4].setNormal(-direction.x, -direction.y, -direction.z);
        this.worldPlane[4].setConstant(-(dirDotLocation + this.frustumFar));
        this.worldPlane[5].setNormal(direction.x, direction.y, direction.z);
        this.worldPlane[5].setConstant(dirDotLocation + this.frustumNear);
        this.viewMatrix.fromFrame(this.location, direction, up, left);
        vars.release();
        this.updateViewProjection();
    }

    public boolean isParallelProjection() {
        return this.parallelProjection;
    }

    public void setParallelProjection(boolean value) {
        this.parallelProjection = value;
        this.onFrustumChange();
    }

    public float getViewToProjectionZ(float viewZPos) {
        float far = this.getFrustumFar();
        float near = this.getFrustumNear();
        float a = far / (far - near);
        float b = far * near / (near - far);
        return a + b / viewZPos;
    }

    public Vector3f getWorldCoordinates(Vector2f screenPos, float projectionZPos) {
        return this.getWorldCoordinates(screenPos, projectionZPos, null);
    }

    public Vector3f getWorldCoordinates(Vector2f screenPosition, float projectionZPos, Vector3f store) {
        if (store == null) {
            store = new Vector3f();
        }
        Matrix4f inverseMat = new Matrix4f(this.viewProjectionMatrix);
        inverseMat.invertLocal();
        store.set((screenPosition.x / (float)this.getWidth() - this.viewPortLeft) / (this.viewPortRight - this.viewPortLeft) * 2.0f - 1.0f, (screenPosition.y / (float)this.getHeight() - this.viewPortBottom) / (this.viewPortTop - this.viewPortBottom) * 2.0f - 1.0f, projectionZPos * 2.0f - 1.0f);
        float w = inverseMat.multProj(store, store);
        store.multLocal(1.0f / w);
        return store;
    }

    public Vector3f getScreenCoordinates(Vector3f worldPos) {
        return this.getScreenCoordinates(worldPos, null);
    }

    public Vector3f getScreenCoordinates(Vector3f worldPosition, Vector3f store) {
        if (store == null) {
            store = new Vector3f();
        }
        float w = this.viewProjectionMatrix.multProj(worldPosition, store);
        store.divideLocal(w);
        store.x = ((store.x + 1.0f) * (this.viewPortRight - this.viewPortLeft) / 2.0f + this.viewPortLeft) * (float)this.getWidth();
        store.y = ((store.y + 1.0f) * (this.viewPortTop - this.viewPortBottom) / 2.0f + this.viewPortBottom) * (float)this.getHeight();
        store.z = (store.z + 1.0f) / 2.0f;
        return store;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        return "Camera[location=" + this.location + "\n, direction=" + this.getDirection() + "\nres=" + this.width + "x" + this.height + ", parallel=" + this.parallelProjection + "\nnear=" + this.frustumNear + ", far=" + this.frustumFar + "]";
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.location, "location", Vector3f.ZERO);
        capsule.write(this.rotation, "rotation", Quaternion.DIRECTION_Z);
        capsule.write(this.frustumNear, "frustumNear", 1.0f);
        capsule.write(this.frustumFar, "frustumFar", 2.0f);
        capsule.write(this.frustumLeft, "frustumLeft", -0.5f);
        capsule.write(this.frustumRight, "frustumRight", 0.5f);
        capsule.write(this.frustumTop, "frustumTop", 0.5f);
        capsule.write(this.frustumBottom, "frustumBottom", -0.5f);
        capsule.write(this.coeffLeft, "coeffLeft", new float[2]);
        capsule.write(this.coeffRight, "coeffRight", new float[2]);
        capsule.write(this.coeffBottom, "coeffBottom", new float[2]);
        capsule.write(this.coeffTop, "coeffTop", new float[2]);
        capsule.write(this.viewPortLeft, "viewPortLeft", 0.0f);
        capsule.write(this.viewPortRight, "viewPortRight", 1.0f);
        capsule.write(this.viewPortTop, "viewPortTop", 1.0f);
        capsule.write(this.viewPortBottom, "viewPortBottom", 0.0f);
        capsule.write(this.width, "width", 0);
        capsule.write(this.height, "height", 0);
        capsule.write(this.name, "name", null);
    }

    @Override
    public void read(JmeImporter e) throws IOException {
        InputCapsule capsule = e.getCapsule(this);
        this.location = (Vector3f)capsule.readSavable("location", Vector3f.ZERO.clone());
        this.rotation = (Quaternion)capsule.readSavable("rotation", Quaternion.DIRECTION_Z.clone());
        this.frustumNear = capsule.readFloat("frustumNear", 1.0f);
        this.frustumFar = capsule.readFloat("frustumFar", 2.0f);
        this.frustumLeft = capsule.readFloat("frustumLeft", -0.5f);
        this.frustumRight = capsule.readFloat("frustumRight", 0.5f);
        this.frustumTop = capsule.readFloat("frustumTop", 0.5f);
        this.frustumBottom = capsule.readFloat("frustumBottom", -0.5f);
        this.coeffLeft = capsule.readFloatArray("coeffLeft", new float[2]);
        this.coeffRight = capsule.readFloatArray("coeffRight", new float[2]);
        this.coeffBottom = capsule.readFloatArray("coeffBottom", new float[2]);
        this.coeffTop = capsule.readFloatArray("coeffTop", new float[2]);
        this.viewPortLeft = capsule.readFloat("viewPortLeft", 0.0f);
        this.viewPortRight = capsule.readFloat("viewPortRight", 1.0f);
        this.viewPortTop = capsule.readFloat("viewPortTop", 1.0f);
        this.viewPortBottom = capsule.readFloat("viewPortBottom", 0.0f);
        this.width = capsule.readInt("width", 1);
        this.height = capsule.readInt("height", 1);
        this.name = capsule.readString("name", null);
        this.onFrustumChange();
        this.onViewPortChange();
        this.onFrameChange();
    }

    public static enum FrustumIntersect {
        Outside,
        Inside,
        Intersects;

    }
}

