/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.Vector2f;
import com.jme3.post.SceneProcessor;
import com.jme3.profile.AppProfiler;
import com.jme3.renderer.Camera;
import com.jme3.renderer.Caps;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.ui.Picture;
import java.util.EnumSet;
import java.util.logging.Logger;

@Deprecated
public class HDRRenderer
implements SceneProcessor {
    private static final int LUMMODE_NONE = 1;
    private static final int LUMMODE_ENCODE_LUM = 2;
    private static final int LUMMODE_DECODE_LUM = 3;
    private Renderer renderer;
    private RenderManager renderManager;
    private ViewPort viewPort;
    private static final Logger logger = Logger.getLogger(HDRRenderer.class.getName());
    private AppProfiler prof;
    private Camera fbCam = new Camera(1, 1);
    private FrameBuffer msFB;
    private FrameBuffer mainSceneFB;
    private Texture2D mainScene;
    private FrameBuffer scene64FB;
    private Texture2D scene64;
    private FrameBuffer scene8FB;
    private Texture2D scene8;
    private FrameBuffer[] scene1FB = new FrameBuffer[2];
    private Texture2D[] scene1 = new Texture2D[2];
    private Material hdr64;
    private Material hdr8;
    private Material hdr1;
    private Material tone;
    private Picture fsQuad;
    private float time = 0.0f;
    private int curSrc = -1;
    private int oppSrc = -1;
    private float blendFactor = 0.0f;
    private int numSamples = 0;
    private float exposure = 0.18f;
    private float whiteLevel = 100.0f;
    private float throttle = -1.0f;
    private int maxIterations = -1;
    private Image.Format bufFormat = Image.Format.RGB16F;
    private Texture.MinFilter fbMinFilter = Texture.MinFilter.BilinearNoMipMaps;
    private Texture.MagFilter fbMagFilter = Texture.MagFilter.Bilinear;
    private AssetManager manager;
    private boolean enabled = true;

    public HDRRenderer(AssetManager manager, Renderer renderer) {
        this.manager = manager;
        this.renderer = renderer;
        EnumSet<Caps> caps = renderer.getCaps();
        if (caps.contains((Object)Caps.PackedFloatColorBuffer)) {
            this.bufFormat = Image.Format.RGB111110F;
        } else if (caps.contains((Object)Caps.FloatColorBuffer)) {
            this.bufFormat = Image.Format.RGB16F;
        } else {
            this.enabled = false;
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setSamples(int samples) {
        this.numSamples = samples;
    }

    public void setExposure(float exp) {
        this.exposure = exp;
    }

    public void setWhiteLevel(float whiteLevel) {
        this.whiteLevel = whiteLevel;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
        if (this.hdr64 != null) {
            this.createLumShaders();
        }
    }

    public void setThrottle(float throttle) {
        this.throttle = throttle;
    }

    public void setUseFastFilter(boolean fastFilter) {
        if (fastFilter) {
            this.fbMagFilter = Texture.MagFilter.Nearest;
            this.fbMinFilter = Texture.MinFilter.NearestNoMipMaps;
        } else {
            this.fbMagFilter = Texture.MagFilter.Bilinear;
            this.fbMinFilter = Texture.MinFilter.BilinearNoMipMaps;
        }
    }

    public Picture createDisplayQuad() {
        if (this.scene64 == null) {
            return null;
        }
        Material mat = new Material(this.manager, "Common/MatDefs/Hdr/LogLum.j3md");
        mat.setBoolean("DecodeLum", true);
        mat.setTexture("Texture", this.scene64);
        Picture dispQuad = new Picture("Luminance Display");
        dispQuad.setMaterial(mat);
        return dispQuad;
    }

    private Material createLumShader(int srcW, int srcH, int bufW, int bufH, int mode, int iters, Texture tex) {
        Material mat = new Material(this.manager, "Common/MatDefs/Hdr/LogLum.j3md");
        Vector2f blockSize = new Vector2f(1.0f / (float)bufW, 1.0f / (float)bufH);
        Vector2f pixelSize = new Vector2f(1.0f / (float)srcW, 1.0f / (float)srcH);
        Vector2f blocks = new Vector2f();
        float numPixels = Float.POSITIVE_INFINITY;
        if (iters != -1) {
            do {
                pixelSize.multLocal(2.0f);
                blocks.set(blockSize.x / pixelSize.x, blockSize.y / pixelSize.y);
            } while ((numPixels = blocks.x * blocks.y) > (float)iters);
        } else {
            blocks.set(blockSize.x / pixelSize.x, blockSize.y / pixelSize.y);
            numPixels = blocks.x * blocks.y;
        }
        mat.setBoolean("Blocks", true);
        if (mode == 2) {
            mat.setBoolean("EncodeLum", true);
        } else if (mode == 3) {
            mat.setBoolean("DecodeLum", true);
        }
        mat.setTexture("Texture", tex);
        mat.setVector2("BlockSize", blockSize);
        mat.setVector2("PixelSize", pixelSize);
        mat.setFloat("NumPixels", numPixels);
        return mat;
    }

    private void createLumShaders() {
        int w = this.mainSceneFB.getWidth();
        int h = this.mainSceneFB.getHeight();
        this.hdr64 = this.createLumShader(w, h, 64, 64, 2, this.maxIterations, this.mainScene);
        this.hdr8 = this.createLumShader(64, 64, 8, 8, 1, this.maxIterations, this.scene64);
        this.hdr1 = this.createLumShader(8, 8, 1, 1, 1, this.maxIterations, this.scene8);
    }

    private int opposite(int i) {
        return i == 1 ? 0 : 1;
    }

    private void renderProcessing(Renderer r, FrameBuffer dst, Material mat) {
        if (dst == null) {
            this.fsQuad.setWidth(this.mainSceneFB.getWidth());
            this.fsQuad.setHeight(this.mainSceneFB.getHeight());
            this.fbCam.resize(this.mainSceneFB.getWidth(), this.mainSceneFB.getHeight(), true);
        } else {
            this.fsQuad.setWidth(dst.getWidth());
            this.fsQuad.setHeight(dst.getHeight());
            this.fbCam.resize(dst.getWidth(), dst.getHeight(), true);
        }
        this.fsQuad.setMaterial(mat);
        this.fsQuad.updateGeometricState();
        this.renderManager.setCamera(this.fbCam, true);
        r.setFrameBuffer(dst);
        r.clearBuffers(true, true, true);
        this.renderManager.renderGeometry(this.fsQuad);
    }

    private void renderToneMap(Renderer r, FrameBuffer out) {
        this.tone.setFloat("A", this.exposure);
        this.tone.setFloat("White", this.whiteLevel);
        this.tone.setTexture("Lum", this.scene1[this.oppSrc]);
        this.tone.setTexture("Lum2", this.scene1[this.curSrc]);
        this.tone.setFloat("BlendFactor", this.blendFactor);
        this.renderProcessing(r, out, this.tone);
    }

    private void updateAverageLuminance(Renderer r) {
        this.renderProcessing(r, this.scene64FB, this.hdr64);
        this.renderProcessing(r, this.scene8FB, this.hdr8);
        this.renderProcessing(r, this.scene1FB[this.curSrc], this.hdr1);
    }

    @Override
    public boolean isInitialized() {
        return this.viewPort != null;
    }

    @Override
    public void reshape(ViewPort vp, int w, int h) {
        if (this.mainSceneFB != null) {
            this.renderer.deleteFrameBuffer(this.mainSceneFB);
        }
        this.mainSceneFB = new FrameBuffer(w, h, 1);
        this.mainScene = new Texture2D(w, h, this.bufFormat);
        this.mainSceneFB.setDepthBuffer(Image.Format.Depth);
        this.mainSceneFB.setColorTexture(this.mainScene);
        this.mainScene.setMagFilter(this.fbMagFilter);
        this.mainScene.setMinFilter(this.fbMinFilter);
        if (this.msFB != null) {
            this.renderer.deleteFrameBuffer(this.msFB);
        }
        this.tone.setTexture("Texture", this.mainScene);
        EnumSet<Caps> caps = this.renderer.getCaps();
        if (this.numSamples > 1 && caps.contains((Object)Caps.FrameBufferMultisample)) {
            this.msFB = new FrameBuffer(w, h, this.numSamples);
            this.msFB.setDepthBuffer(Image.Format.Depth);
            this.msFB.setColorBuffer(this.bufFormat);
            vp.setOutputFrameBuffer(this.msFB);
        } else {
            if (this.numSamples > 1) {
                logger.warning("FBO multisampling not supported on this GPU, request ignored.");
            }
            vp.setOutputFrameBuffer(this.mainSceneFB);
        }
        this.createLumShaders();
    }

    @Override
    public void initialize(RenderManager rm, ViewPort vp) {
        if (!this.enabled) {
            return;
        }
        this.renderer = rm.getRenderer();
        this.renderManager = rm;
        this.viewPort = vp;
        this.fsQuad = new Picture("HDR Fullscreen Quad");
        Image.Format lumFmt = Image.Format.RGB8;
        this.scene64FB = new FrameBuffer(64, 64, 1);
        this.scene64 = new Texture2D(64, 64, lumFmt);
        this.scene64FB.setColorTexture(this.scene64);
        this.scene64.setMagFilter(this.fbMagFilter);
        this.scene64.setMinFilter(this.fbMinFilter);
        this.scene8FB = new FrameBuffer(8, 8, 1);
        this.scene8 = new Texture2D(8, 8, lumFmt);
        this.scene8FB.setColorTexture(this.scene8);
        this.scene8.setMagFilter(this.fbMagFilter);
        this.scene8.setMinFilter(this.fbMinFilter);
        this.scene1FB[0] = new FrameBuffer(1, 1, 1);
        this.scene1[0] = new Texture2D(1, 1, lumFmt);
        this.scene1FB[0].setColorTexture(this.scene1[0]);
        this.scene1FB[1] = new FrameBuffer(1, 1, 1);
        this.scene1[1] = new Texture2D(1, 1, lumFmt);
        this.scene1FB[1].setColorTexture(this.scene1[1]);
        this.tone = new Material(this.manager, "Common/MatDefs/Hdr/ToneMap.j3md");
        this.tone.setFloat("A", 0.18f);
        this.tone.setFloat("White", 100.0f);
        int w = vp.getCamera().getWidth();
        int h = vp.getCamera().getHeight();
        this.reshape(vp, w, h);
    }

    @Override
    public void preFrame(float tpf) {
        if (!this.enabled) {
            return;
        }
        this.time += tpf;
        this.blendFactor = this.time / this.throttle;
    }

    @Override
    public void postQueue(RenderQueue rq) {
    }

    @Override
    public void postFrame(FrameBuffer out) {
        if (!this.enabled) {
            return;
        }
        if (this.msFB != null) {
            this.renderer.copyFrameBuffer(this.msFB, this.mainSceneFB, true);
        }
        if (this.throttle == -1.0f) {
            this.curSrc = 0;
            this.oppSrc = 0;
            this.blendFactor = 0.0f;
            this.time = 0.0f;
            this.updateAverageLuminance(this.renderer);
        } else if (this.curSrc == -1) {
            this.curSrc = 0;
            this.oppSrc = 0;
            this.updateAverageLuminance(this.renderer);
            this.blendFactor = 0.0f;
            this.time = 0.0f;
        } else if (this.time > this.throttle) {
            this.oppSrc = this.curSrc;
            this.curSrc = this.opposite(this.curSrc);
            this.updateAverageLuminance(this.renderer);
            this.blendFactor = 0.0f;
            this.time = 0.0f;
        }
        this.renderToneMap(this.renderer, null);
        this.renderManager.setCamera(this.viewPort.getCamera(), false);
    }

    @Override
    public void cleanup() {
        if (!this.enabled) {
            return;
        }
        if (this.msFB != null) {
            this.renderer.deleteFrameBuffer(this.msFB);
        }
        if (this.mainSceneFB != null) {
            this.renderer.deleteFrameBuffer(this.mainSceneFB);
        }
        if (this.scene64FB != null) {
            this.renderer.deleteFrameBuffer(this.scene64FB);
            this.renderer.deleteFrameBuffer(this.scene8FB);
            this.renderer.deleteFrameBuffer(this.scene1FB[0]);
            this.renderer.deleteFrameBuffer(this.scene1FB[1]);
        }
    }

    @Override
    public void setProfiler(AppProfiler profiler) {
        this.prof = profiler;
    }
}

