/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import java.util.Random;
import org.ejml.alg.dense.linsol.LinearSolverSafe;
import org.ejml.alg.dense.misc.UnrolledInverseFromMinor;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.ops.CovarianceRandomDraw;
import org.ejml.ops.MatrixFeatures;

public class CovarianceOps {
    public static double TOL = 1.0E-9;

    public static boolean isValidFast(DenseMatrix64F cov) {
        return MatrixFeatures.isDiagonalPositive(cov);
    }

    public static int isValid(DenseMatrix64F cov) {
        if (!MatrixFeatures.isDiagonalPositive(cov)) {
            return 1;
        }
        if (!MatrixFeatures.isSymmetric(cov, TOL)) {
            return 2;
        }
        if (!MatrixFeatures.isPositiveSemidefinite(cov)) {
            return 3;
        }
        return 0;
    }

    public static boolean invert(DenseMatrix64F cov) {
        return CovarianceOps.invert(cov, cov);
    }

    public static boolean invert(DenseMatrix64F cov, DenseMatrix64F cov_inv) {
        if (cov.numCols <= 4) {
            if (cov.numCols != cov.numRows) {
                throw new IllegalArgumentException("Must be a square matrix.");
            }
            if (cov.numCols >= 2) {
                UnrolledInverseFromMinor.inv(cov, cov_inv);
            } else {
                cov_inv.data[0] = 1.0 / cov_inv.data[0];
            }
        } else {
            LinearSolverSafe solver = LinearSolverFactory.symmPosDef(cov.numRows);
            if (!(solver = new LinearSolverSafe(solver)).setA((Matrix)cov)) {
                return false;
            }
            solver.invert((Matrix)cov_inv);
        }
        return true;
    }

    public static void randomVector(DenseMatrix64F cov, DenseMatrix64F vector, Random rand) {
        CovarianceRandomDraw rng = new CovarianceRandomDraw(rand, cov);
        rng.next(vector);
    }
}

