/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.phys;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import rs.co.ast.aspen.gui.module.vis.threed.phys.PhysicsBody;

public class FieldMatrix {
    private final Map<ChargePair, Integer> pairs = new HashMap<ChargePair, Integer>();

    public FieldMatrix(int sameSign, int differentSign) {
        if (sameSign != 1 && sameSign != -1) {
            throw new IllegalArgumentException("sign must be 1 or -1");
        }
        if (differentSign != 1 && differentSign != -1) {
            throw new IllegalArgumentException("sign must be 1 or -1");
        }
        for (int i = 0; i < PhysicsBody.Charge.values().length; ++i) {
            for (int j = i; j < PhysicsBody.Charge.values().length; ++j) {
                PhysicsBody.Charge a = PhysicsBody.Charge.values()[i];
                PhysicsBody.Charge b = PhysicsBody.Charge.values()[j];
                this.pairs.put(this.makePair(a, b), a == b ? sameSign : differentSign);
            }
        }
    }

    public int get(PhysicsBody.Charge a, PhysicsBody.Charge b) {
        if (a == PhysicsBody.Charge._0 || b == PhysicsBody.Charge._0) {
            return 0;
        }
        return this.pairs.get(this.makePair(a, b));
    }

    public void set(PhysicsBody.Charge a, PhysicsBody.Charge b, int sign) {
        if (sign != 1 && sign != -1) {
            throw new IllegalArgumentException("sign must be 1 or -1");
        }
        this.pairs.put(new ChargePair(a, b), sign);
    }

    public void setAll(PhysicsBody.Charge a, int sign) {
        if (sign != 1 && sign != -1) {
            throw new IllegalArgumentException("sign must be 1 or -1");
        }
        for (PhysicsBody.Charge b : PhysicsBody.Charge.values()) {
            this.pairs.put(this.makePair(a, b), sign);
        }
    }

    public String toString() {
        return this.pairs.entrySet().toString();
    }

    private ChargePair makePair(PhysicsBody.Charge a, PhysicsBody.Charge b) {
        ArrayList<PhysicsBody.Charge> l = new ArrayList<PhysicsBody.Charge>();
        l.add(a);
        l.add(b);
        Collections.sort(l);
        return new ChargePair((PhysicsBody.Charge)((Object)l.get(0)), (PhysicsBody.Charge)((Object)l.get(1)));
    }

    private class ChargePair {
        public PhysicsBody.Charge first;
        public PhysicsBody.Charge second;

        ChargePair(PhysicsBody.Charge first, PhysicsBody.Charge second) {
            this.first = first;
            this.second = second;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChargePair other = (ChargePair)obj;
            if (this.first != other.first) {
                return false;
            }
            return this.second == other.second;
        }

        public int hashCode() {
            int hash = 3;
            hash = 89 * hash + Objects.hashCode((Object)this.first);
            hash = 89 * hash + Objects.hashCode((Object)this.second);
            return hash;
        }

        public String toString() {
            return (Object)((Object)this.first) + "," + (Object)((Object)this.second);
        }
    }
}

