/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.login.actions;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class LanguageChangerHelper {
    private static LanguageChangerHelper instance;
    private static final String DEFAULT_OPTIONS = "default_options";
    private static final String ASPEN_CONSOLECONF = "aspen_console.conf";
    private static final String LOCALE = " --locale ";
    private static final String LINUX_UP_FOLDER = "..";
    private static final String ETC = "etc";
    private static final String QUOTES = "\"";
    private static final String OS;
    private boolean success = true;

    private LanguageChangerHelper() {
    }

    public static LanguageChangerHelper getInstance() {
        if (instance == null) {
            instance = new LanguageChangerHelper();
        }
        return instance;
    }

    public void changeLanguage(String local) {
        Properties props = new Properties();
        Path path = LanguageChangerHelper.isWindows() ? Paths.get(ETC, ASPEN_CONSOLECONF) : Paths.get(LINUX_UP_FOLDER, ETC, ASPEN_CONSOLECONF);
        this.loadProperties(path, props);
        String changed_def_options = this.changeLocal(props, local);
        this.writePropertiesToFile(props, changed_def_options, path);
        if (this.success) {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(LanguageChangerHelper.class, (String)"languageChangerHelperMessage"));
        }
    }

    private String changeLocal(Properties props, String local) {
        String def_options = props.getProperty(DEFAULT_OPTIONS);
        Matcher matcher = Pattern.compile(".*([a-z]{2}:[A-Z]{2}).*").matcher(def_options);
        Object changed_def_options = matcher.matches() ? def_options.replaceAll("([a-z]{2}:[A-Z]{2})", local) : def_options.substring(0, def_options.lastIndexOf(QUOTES)) + LOCALE + local + QUOTES;
        return changed_def_options;
    }

    private void writePropertiesToFile(Properties props, String changed_def_options, Path path) {
        props.setProperty(DEFAULT_OPTIONS, changed_def_options);
        try (PrintWriter pw = new PrintWriter(path.toFile().getCanonicalPath());){
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                pw.append(k.toString());
                pw.append("=");
                pw.append(v.toString());
                pw.append(System.lineSeparator());
            }));
            pw.flush();
        }
        catch (IOException ex) {
            this.success = false;
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void loadProperties(Path path, Properties props) {
        try (FileInputStream in = new FileInputStream(path.toFile().getCanonicalPath());){
            props.load(in);
        }
        catch (IOException ex) {
            this.success = false;
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static boolean isWindows() {
        return OS.contains("win");
    }

    private static boolean isMac() {
        return OS.contains("mac");
    }

    private static boolean isUnix() {
        return OS.contains("nux");
    }

    static {
        OS = System.getProperty("os.name").toLowerCase();
    }
}

