/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.pus;

import java.util.List;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.lookup.Lookups;
import rs.co.ast.aspen.api.service.PusProcess;
import rs.co.ast.aspen.api.service.PusReport;
import rs.co.ast.aspen.gui.module.pus.Constants;
import rs.co.ast.aspen.gui.module.pus.HasId;
import rs.co.ast.aspen.gui.module.pus.PusProcessWrapper;

public class ProcessNode
extends AbstractNode
implements HasId {
    private PusProcessWrapper process;

    public ProcessNode(PusProcessWrapper process) {
        super(Children.LEAF, Lookups.singleton((Object)process));
        this.setDisplayName(process.getName());
        List<PusReport> reports = process.getReports();
        PusReport r = reports.get(reports.size() - 1);
        if (null != r.getStatus()) {
            switch (r.getStatus()) {
                case STARTING_UP: {
                    this.setIconBaseWithExtension(Constants.ICON_STARTING_UP);
                    break;
                }
                case STANDING_BY: {
                    this.setIconBaseWithExtension(Constants.ICON_STANDING_BY);
                    break;
                }
                case SHUTTING_DOWN: {
                    this.setIconBaseWithExtension(Constants.ICON_SHUTTING_DOWN);
                    break;
                }
                case TERMINATED: {
                    this.setIconBaseWithExtension(Constants.ICON_TERMINATED);
                    break;
                }
                case ACTIVE: {
                    long time = System.currentTimeMillis();
                    if (time - r.getFinish() >= (long)(Constants.CYCLE * Constants.THIRD_CYCLE)) {
                        this.setIconBaseWithExtension(Constants.ICON_ACTIVE_RED);
                        break;
                    }
                    if (time - r.getFinish() >= (long)(Constants.CYCLE * Constants.FIRST_CYCLE)) {
                        this.setIconBaseWithExtension(Constants.ICON_ACTIVE_YELLOW);
                        break;
                    }
                    this.setIconBaseWithExtension(Constants.ICON_ACTIVE_GREEN);
                    break;
                }
                case WARNING: {
                    this.setIconBaseWithExtension(Constants.ICON_ACTIVE_YELLOW);
                    break;
                }
                default: {
                    this.setIconBaseWithExtension(Constants.ICON_UNKNOWN);
                }
            }
        }
        this.process = process;
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    @Override
    public String getId() {
        return this.process.getName();
    }

    public PusProcess getPusProcess() {
        return this.process.getPusProcess();
    }

    public boolean isSelected() {
        return this.process.isVisible();
    }
}

