/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.api.service;

import java.io.IOException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.FIStaxInInterceptor;
import org.apache.cxf.interceptor.FIStaxOutInterceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.ConnectionType;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.openide.util.Exceptions;
import rs.co.ast.aspen.api.service.AggregationSearchResults;
import rs.co.ast.aspen.api.service.ApiAccount;
import rs.co.ast.aspen.api.service.ApiKeyResponse;
import rs.co.ast.aspen.api.service.ApiResponse;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.AspenApiService;
import rs.co.ast.aspen.api.service.ClientScriptsUpdateReport;
import rs.co.ast.aspen.api.service.ComplexityViolation;
import rs.co.ast.aspen.api.service.ConsoleUser;
import rs.co.ast.aspen.api.service.CreateScriptDTO;
import rs.co.ast.aspen.api.service.DataMapAggValue;
import rs.co.ast.aspen.api.service.DataMapValue;
import rs.co.ast.aspen.api.service.DeleteAllSavedScriptsResponse;
import rs.co.ast.aspen.api.service.DeliveryPoint;
import rs.co.ast.aspen.api.service.Destination;
import rs.co.ast.aspen.api.service.EnrichedHostStatsGuiReport;
import rs.co.ast.aspen.api.service.HostStatsCsvReport;
import rs.co.ast.aspen.api.service.IndexDateRange;
import rs.co.ast.aspen.api.service.JsonTransformPattern;
import rs.co.ast.aspen.api.service.ListAccountsResponse;
import rs.co.ast.aspen.api.service.ListSavedScriptsResponse;
import rs.co.ast.aspen.api.service.ListScriptsResponse;
import rs.co.ast.aspen.api.service.ListThreatIndicators;
import rs.co.ast.aspen.api.service.LogFile;
import rs.co.ast.aspen.api.service.MappingObjectDTO;
import rs.co.ast.aspen.api.service.MethodExecutor;
import rs.co.ast.aspen.api.service.ParsingDebugInfo;
import rs.co.ast.aspen.api.service.ParsingRuleDTO;
import rs.co.ast.aspen.api.service.ParsingRuleSetDTO;
import rs.co.ast.aspen.api.service.ParsingRulesGroupDTO;
import rs.co.ast.aspen.api.service.ParsingUpdateObjectDTO;
import rs.co.ast.aspen.api.service.PasswordPolicySettings;
import rs.co.ast.aspen.api.service.PusReports;
import rs.co.ast.aspen.api.service.RawLog;
import rs.co.ast.aspen.api.service.RawLogsCountContainer;
import rs.co.ast.aspen.api.service.RawLogsSearchResults;
import rs.co.ast.aspen.api.service.RuleSetBackupContainerDTO;
import rs.co.ast.aspen.api.service.SavedQueryData;
import rs.co.ast.aspen.api.service.ScheduledTask;
import rs.co.ast.aspen.api.service.Script;
import rs.co.ast.aspen.api.service.ScriptType;
import rs.co.ast.aspen.api.service.ScriptsUpdateReport;
import rs.co.ast.aspen.api.service.SearchState;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.api.service.SecurityEventsCountContainer;
import rs.co.ast.aspen.api.service.SecurityEventsSearchResults;
import rs.co.ast.aspen.api.service.TermTimeHistogram;
import rs.co.ast.aspen.api.service.UpdateAccountResponse;

public class AspenApiServiceWsImpl
implements ApiService {
    private static final Logger LOGGER = Logger.getLogger(AspenApiServiceWsImpl.class.getName());
    private static final int MIN_GZIP_RESP_SIZE = 2048;
    private static final long CACHE_DURATION = 18000000L;
    private static final long TIMEOUT = 120000L;
    private AspenApiService aspenApiService;
    private String sid;
    private MethodExecutor exec;
    private Map<String, List<String>> mappingsCache;
    private long mappingsTimestamp;

    private AspenApiService getApiService(String serviceUrl) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        if (this.aspenApiService == null) {
            URL url = new URL(serviceUrl);
            String protocol = url.getProtocol() != null ? url.getProtocol() : "http";
            String hostname = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                port = protocol.equalsIgnoreCase("https") ? 8443 : 8080;
            }
            JaxWsProxyFactoryBean f = new JaxWsProxyFactoryBean();
            f.setServiceClass(AspenApiService.class);
            f.setAddress(String.format("%s://%s:%d/aspen-api-service/services/ApiService", protocol, hostname, port));
            f.getInInterceptors().add(new FIStaxInInterceptor());
            f.getOutInterceptors().add(new FIStaxOutInterceptor());
            f.getInInterceptors().add(new GZIPInInterceptor());
            f.getOutInterceptors().add(new GZIPOutInterceptor(2048));
            this.aspenApiService = (AspenApiService)f.create();
            KeyStore ks = KeyStore.getInstance("JKS");
            char[] password = "keystorepassword".toCharArray();
            ks.load(this.getClass().getClassLoader().getResourceAsStream("keystore"), password);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, password);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            Client client = ClientProxy.getClient((Object)this.aspenApiService);
            HTTPConduit http = (HTTPConduit)client.getConduit();
            TLSClientParameters tls = new TLSClientParameters();
            tls.setKeyManagers(kmf.getKeyManagers());
            tls.setTrustManagers(tmf.getTrustManagers());
            tls.setDisableCNCheck(true);
            http.setTlsClientParameters(tls);
            HTTPClientPolicy policy = http.getClient();
            policy.setReceiveTimeout(120000L);
            policy.setConnectionRequestTimeout(120000L);
            policy.setConnectionTimeout(120000L);
            policy.setConnection(ConnectionType.KEEP_ALIVE);
            http.setClient(policy);
        }
        return this.aspenApiService;
    }

    @Override
    public List<Byte> ping(int numberOfBytes) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.ping(sessionId, numberOfBytes));
    }

    @Override
    public void login(String host, String username, String password) throws ApiServiceException_Exception {
        try {
            this.sid = this.getApiService(host).login(username, password);
            this.exec = new MethodExecutor(this.sid, this.aspenApiService);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            LOGGER.log(Level.SEVERE, "Login error", ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void logoff() throws ApiServiceException_Exception {
        this.aspenApiService = null;
    }

    @Override
    public SecurityEventsSearchResults searchSecurityEvents(String search, SearchState state, int pageLength, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.searchSecurityEvents(this.sid, search, state, pageLength, timeStart, timeFinish));
    }

    @Override
    public SecurityEventsSearchResults searchSecurityEventsAsc(String search, SearchState state, int pageLength, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.searchSecurityEventsAsc(this.sid, search, state, pageLength, timeStart, timeFinish));
    }

    @Override
    public SecurityEventsSearchResults fetchSecurityEventsWithOffset(String search, SearchState state, int pageLength, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.fetchSecurityEventsWithOffset(this.sid, search, state, pageLength, timeStart, timeFinish));
    }

    @Override
    public SecurityEventsSearchResults fetchSecurityEventsAscWithOffset(String search, SearchState state, int pageLength, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.fetchSecurityEventsAscWithOffset(this.sid, search, state, pageLength, timeStart, timeFinish));
    }

    @Override
    public SecurityEventsCountContainer securityEventsCountSearch(String search, SearchState state, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.securityEventsCountSearch(sessionId, search, state, timeStart, timeFinish));
    }

    @Override
    public SecurityEventsSearchResults fetchSecurityEvents(String search, SearchState state, int pageLength, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.fetchSecurityEvents(sessionId, search, state, pageLength, timeStart, timeFinish));
    }

    @Override
    public SecurityEventsSearchResults fetchSecurityEventsAsc(String search, SearchState state, int pageLength, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.fetchSecurityEventsAsc(sessionId, search, state, pageLength, timeStart, timeFinish));
    }

    @Override
    public SecurityEvent getSecurityEvent(String securityEventId, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.getSecurityEvent(this.sid, securityEventId, timeStart, timeFinish));
    }

    @Override
    public RawLogsCountContainer rawLogsCountSearch(String search, SearchState state, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.rawLogsCountSearch(sessionId, search, state, timeStart, timeFinish));
    }

    @Override
    public RawLogsSearchResults fetchRawLogsWithOffset(String search, SearchState state, int pageLength, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.fetchRawLogsWithOffset(this.sid, search, state, pageLength, timeStart, timeFinish));
    }

    @Override
    public RawLogsSearchResults fetchRawLogsAscWithOffset(String search, SearchState state, int pageLength, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.fetchRawLogsAscWithOffset(this.sid, search, state, pageLength, timeStart, timeFinish));
    }

    @Override
    public RawLogsSearchResults searchRawLogs(String search, SearchState state, int pageLength, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.searchRawLogs(this.sid, search, state, pageLength, timeStart, timeFinish));
    }

    @Override
    public RawLogsSearchResults searchRawLogsAsc(String search, SearchState state, int pageLength, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.searchRawLogsAsc(this.sid, search, state, pageLength, timeStart, timeFinish));
    }

    @Override
    public RawLog getRawLog(String RawLogId, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.getRawLog(this.sid, RawLogId, timeStart, timeFinish));
    }

    @Override
    public List<String> getDataMapNames() throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getDataMapNames(sessionId));
    }

    @Override
    public List<String> getKeysForDataMap(String mapName) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getKeysForDataMap(sessionId, mapName));
    }

    @Override
    public List<DataMapValue> getDataMapKeysWithLastUpdatedForDataMap(String mapName) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getDataMapKeysWithLastUpdatedForDataMap(sessionId, mapName));
    }

    @Override
    public List<DataMapValue> getKeysWithLastUpdatedForDataMap(String mapName, String keyRegex) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getKeysWithLastUpdatedForDataMap(sessionId, mapName, keyRegex));
    }

    @Override
    public DataMapValue getValueForDataMapKey(String mapName, String key) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getValueForDataMapKey(sessionId, mapName, key));
    }

    @Override
    public void setValueForDataMapKey(String mapName, String key, String value) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.setValueForDataMapKey(sessionId, mapName, key, value);
            return null;
        });
    }

    @Override
    public void deleteDataMapKey(String mapName, String key) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.deleteDataMapKey(sessionId, mapName, key);
            return null;
        });
    }

    @Override
    public void renameDataMapKey(String mapName, String oldKey, String newKey) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.renameDataMapKey(sessionId, mapName, oldKey, newKey);
            return null;
        });
    }

    @Override
    public void deleteDataMap(String mapName) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.deleteDataMap(sessionId, mapName);
            return null;
        });
    }

    @Override
    public Script createScript(String scriptName, String scriptLang, String scriptDesc, ScriptType scriptType) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.createScript(sessionId, scriptName, scriptLang, scriptDesc, scriptType));
    }

    @Override
    public void createScriptWithText(String scriptName, String scriptText, String scriptLang, String scriptDesc, ScriptType scriptType) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.createScriptWithText(sessionId, scriptName, scriptText, scriptLang, scriptDesc, scriptType);
            return null;
        });
    }

    @Override
    public Script renameScript(Script script) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.renameScript(sessionId, script));
    }

    @Override
    public void deleteScript(String scriptId) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.deleteScript(sessionId, scriptId);
            return null;
        });
    }

    @Override
    public void deleteScripts(List<Script> scripts) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.deleteScripts(sessionId, scripts);
            return null;
        });
    }

    @Override
    public void updateScript(Script script) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.updateScript(sessionId, script);
            return null;
        });
    }

    @Override
    public void updateScripts(List<Script> scripts) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.updateScripts(sessionId, scripts);
            return null;
        });
    }

    @Override
    public void enableScript(Script script, boolean enable) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.enableScript(sessionId, script, enable);
            return null;
        });
    }

    @Override
    public void enableScripts(List<Script> scripts, boolean enable) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.enableScripts(sessionId, scripts, enable);
            return null;
        });
    }

    @Override
    public Collection<Script> getAllScripts() throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getAllScripts(sessionId));
    }

    @Override
    public Script getVisualizationRuleSetByName(String scriptName) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getVisualizationRuleSetByName(sessionId, scriptName));
    }

    @Override
    public List<Script> getScriptsByType(ScriptType scriptType) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getScriptsByType(sessionId, scriptType));
    }

    @Override
    public List<ConsoleUser> getConsoleUsers() throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.getConsoleUsers(sessionId));
    }

    @Override
    public ConsoleUser createConsoleUser(String username) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.createConsoleUser(sessionId, username));
    }

    @Override
    public void deleteConsoleUser(String username) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            this.aspenApiService.deleteConsoleUser(sessionId, username);
            return null;
        });
    }

    @Override
    public void setConsoleUserPassword(String username, String password) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            this.aspenApiService.setConsoleUserPassword(sessionId, username, password);
            return null;
        });
    }

    @Override
    public void updateConsoleUser(ConsoleUser user) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            this.aspenApiService.updateConsoleUser(sessionId, user);
            return null;
        });
    }

    @Override
    public PusReports getPUSReports() throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getPUSReports(sessionId));
    }

    @Override
    public List<Destination> getDestinations() throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getDestinations(sessionId));
    }

    @Override
    public List<DeliveryPoint> getDeliveryPoints(String destinationName) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getDeliveryPoints(sessionId, destinationName));
    }

    @Override
    public boolean addNewDestination(String destinationName) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.addNewDestination(sessionId, destinationName));
    }

    @Override
    public boolean deleteDestination(String destinationName) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.deleteDestination(sessionId, destinationName));
    }

    @Override
    public boolean updateDestination(Destination destination) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.updateDestination(sessionId, destination));
    }

    @Override
    public List<ScheduledTask> getAllTasks() throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getAllTasks(sessionId));
    }

    @Override
    public void updateTask(String id, String scriptName, String cronSpec, boolean enabled) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.updateTask(sessionId, id, scriptName, cronSpec, enabled);
            return null;
        });
    }

    @Override
    public void deleteTask(String id) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.deleteTask(sessionId, id);
            return null;
        });
    }

    @Override
    public void deleteTasks(List<ScheduledTask> tasks) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.deleteTasks(sessionId, tasks);
            return null;
        });
    }

    @Override
    public boolean addTask(String scriptName, String cronSpec, boolean enabled) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.addTask(sessionId, scriptName, cronSpec, enabled));
    }

    @Override
    public List<ParsingRuleSetDTO> getParsingRuleSets() throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getParsingRuleSets(sessionId));
    }

    @Override
    public ParsingRuleSetDTO getParsingRuleSet(String ruleSetId) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getParsingRuleSet(sessionId, ruleSetId));
    }

    @Override
    public void importRuleSets(RuleSetBackupContainerDTO rsbc) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.importRuleSets(sessionId, rsbc);
            return null;
        });
    }

    @Override
    public List<ParsingRulesGroupDTO> getParsingRulesGroupsForParent(String parentId) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getParsingRulesGroupsForParent(sessionId, parentId));
    }

    @Override
    public ParsingRulesGroupDTO getParsingRulesGroup(String groupId) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getParsingRulesGroup(sessionId, groupId));
    }

    @Override
    public List<ParsingRuleDTO> getParsingRulesForGroup(String parsingRulesGroupId) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getParsingRulesForGroup(sessionId, parsingRulesGroupId));
    }

    @Override
    public ParsingRuleDTO getParsingRule(String ruleId) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getParsingRule(sessionId, ruleId));
    }

    @Override
    public void saveChanges(ParsingUpdateObjectDTO puo) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.saveChanges(sessionId, puo);
            return null;
        });
    }

    @Override
    public List<ParsingRulesGroupDTO> getAllParsingRulesGroups() throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getAllParsingRulesGroups(sessionId));
    }

    @Override
    public List<ParsingRuleDTO> getAllParsingRules() throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getAllParsingRules(sessionId));
    }

    @Override
    public Map<String, List<String>> getMappings() throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> {
            if (System.currentTimeMillis() - this.mappingsTimestamp > 18000000L) {
                HashMap<String, List<String>> map = new HashMap<String, List<String>>();
                try {
                    List<MappingObjectDTO> mappings = apiService.getMappings(sessionId);
                    for (MappingObjectDTO mo : mappings) {
                        List<String> list;
                        if (!map.containsKey(mo.getCategory())) {
                            list = new ArrayList();
                            if (mo.getKey() != null) {
                                list.add(mo.getKey());
                            }
                            map.put(mo.getCategory(), list);
                            continue;
                        }
                        list = (List)map.get(mo.getCategory());
                        list.add(mo.getKey());
                        map.put(mo.getCategory(), list);
                    }
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    this.mappingsTimestamp = System.currentTimeMillis();
                    this.mappingsCache = map;
                }
                return map;
            }
            return this.mappingsCache;
        });
    }

    @Override
    public List<String> getMappingsForCategory(String category) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.getMappings().get(category));
    }

    @Override
    public ParsingDebugInfo simulateParsing(String rawlogId, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.simulateParsing(sessionId, rawlogId, timeStart, timeFinish));
    }

    @Override
    public List<SavedQueryData> getSecurityEventQueries() throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getSecurityEventQueries(sessionId));
    }

    @Override
    public List<SavedQueryData> getRawLogQueries() throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getRawLogQueries(sessionId));
    }

    @Override
    public String getSavedQueryName(String query) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getSavedQueryName(sessionId, query));
    }

    @Override
    public void deleteSavedQuery(String queryId) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.deleteSavedQuery(sessionId, queryId);
            return null;
        });
    }

    @Override
    public void saveSavedQuery(SavedQueryData query) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.saveSavedQuery(sessionId, query);
            return null;
        });
    }

    @Override
    public void resendEvent(RawLog rawLog) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.resendEvent(sessionId, rawLog);
            return null;
        });
    }

    @Override
    public List<TermTimeHistogram> getRLTermTimeHistogram(String query, String field, long timeStart, long timeFinish, int noOfTerms, String interval, boolean sortAsc) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.getRLTermTimeHistogram(sessionId, query, field, timeStart, timeFinish, noOfTerms, interval, sortAsc));
    }

    @Override
    public List<TermTimeHistogram> getSETermTimeHistogram(String query, String field, long timeStart, long timeFinish, int noOfTerms, String interval, boolean sortAsc) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.getSETermTimeHistogram(sessionId, query, field, timeStart, timeFinish, noOfTerms, interval, sortAsc));
    }

    @Override
    public AggregationSearchResults getAggregationCount(SearchState searchState, String query, String field, int topN, Integer timeout, long timeStart, long timeFinish, boolean sortAsc) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.getAggregationCount(sessionId, query, field, searchState, topN, timeStart, timeFinish, sortAsc));
    }

    @Override
    public LogFile getServerLog(int lastNLines) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.getServerLog(sessionId, lastNLines));
    }

    @Override
    public LogFile getTomcatLog(int lastNLines) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.getTomcatLog(sessionId, lastNLines));
    }

    @Override
    public LogFile getScriptsLog(int lastNLines) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.getScriptsLog(sessionId, lastNLines));
    }

    @Override
    public List<IndexDateRange> getSecurityEventDateRangeByIndex(long timeStart, long timeFinish, boolean sortAsc) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getSecurityEventDateRangeByIndex(sessionId, timeStart, timeFinish, sortAsc));
    }

    @Override
    public List<IndexDateRange> getRawLogDateRangeByIndex(long timeStart, long timeFinish, boolean sortAsc) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getRawLogDateRangeByIndex(sessionId, timeStart, timeFinish, sortAsc));
    }

    @Override
    public List<IndexDateRange> getCustomSecurityEventDateRangeByIndex(long timeStart, long timeFinish, long split, boolean sortAsc) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getCustomSecurityEventDateRangeByIndex(sessionId, timeStart, timeFinish, split, sortAsc));
    }

    @Override
    public List<IndexDateRange> getCustomRawLogDateRangeByIndex(long timeStart, long timeFinish, long split, boolean sortAsc) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getCustomRawLogDateRangeByIndex(sessionId, timeStart, timeFinish, split, sortAsc));
    }

    @Override
    public List<ComplexityViolation> checkPasswordComplexity(String password) throws ApiServiceException_Exception {
        return this.exec.execute((sesionId, apiService) -> this.aspenApiService.checkPasswordComplexity(sesionId, password));
    }

    @Override
    public void disableConsoleUser(String username) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.disableConsoleUser(sessionId, username);
            return null;
        });
    }

    @Override
    public void enableConsoleUser(String username) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.enableConsoleUser(sessionId, username);
            return null;
        });
    }

    @Override
    public void unlockConsoleUser(String username) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.unlockConsoleUser(sessionId, username);
            return null;
        });
    }

    @Override
    public void setConsoleUserPasswordForSelf(String username, String oldPassword, String newPassword) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            this.aspenApiService.setConsoleUserPasswordForSelf(sessionId, oldPassword, newPassword);
            return null;
        });
    }

    @Override
    public PasswordPolicySettings getPasswordPolicySettings() throws ApiServiceException_Exception {
        return this.exec.execute((sesionId, apiSerivce) -> apiSerivce.getPasswordPolicySettings(sesionId));
    }

    @Override
    public void setPasswordPolicySettings(PasswordPolicySettings passwordPolicySettings) throws ApiServiceException_Exception {
        this.exec.execute((sesionId, apiService) -> {
            apiService.setPasswordPolicySettings(sesionId, passwordPolicySettings);
            return null;
        });
    }

    @Override
    public boolean heartbeat() throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.heartbeat(sessionId));
    }

    @Override
    public ScriptsUpdateReport checkScriptsForUpdate(ClientScriptsUpdateReport clientScriptUpdateReport) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.checkScriptsForUpdate(sessionId, clientScriptUpdateReport));
    }

    @Override
    public ListScriptsResponse apiGetAllScripts() throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.apiGetAllScripts(sessionId));
    }

    @Override
    public ApiResponse apiCreateScript(CreateScriptDTO dto) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.apiCreateScript(sessionId, dto));
    }

    @Override
    public ApiResponse apiDeleteScript(String id) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.apiDeleteScript(sessionId, id));
    }

    @Override
    public ApiResponse apiUpdateScriptText(String id, String scriptText) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.apiUpdateScriptText(sessionId, id, scriptText));
    }

    @Override
    public ApiResponse apiUpdateScript(Script script) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.apiUpdateScript(sessionId, script));
    }

    @Override
    public ApiResponse apiRenameScript(String id, String scriptName) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.apiRenameScript(sessionId, id, scriptName));
    }

    @Override
    public ListAccountsResponse apiGetAllAccounts() throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.apiGetAllAccounts(sessionId));
    }

    @Override
    public ApiKeyResponse apiCreateAccount(ApiAccount account) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.apiCreateAccount(sessionId, account));
    }

    @Override
    public ApiResponse apiDeleteAccount(String id) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.apiDeleteAccount(sessionId, id));
    }

    @Override
    public UpdateAccountResponse apiUpdateAccount(String id, ApiAccount account) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.apiUpdateAccount(sessionId, id, account));
    }

    @Override
    public ApiResponse apiRenameAccount(String id, String accountName) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.apiRenameAccount(sessionId, id, accountName));
    }

    @Override
    public ApiKeyResponse apiGenerateNewApiKeyForAccount(String id) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.apiGenerateNewApiKeyForAccount(sessionId, id));
    }

    @Override
    public ListSavedScriptsResponse apiGetAllSavedScripts() throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.apiGetAllSavedScripts(sessionId));
    }

    @Override
    public ApiResponse apiDeleteSavedScript(String id) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.apiDeleteSavedScript(sessionId, id));
    }

    @Override
    public DeleteAllSavedScriptsResponse apiDeleteAllSavedScripts() throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.apiDeleteAllSavedScripts(sessionId));
    }

    @Override
    public JsonTransformPattern getJsonParserRules() throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getJsonParserRules(sessionId));
    }

    @Override
    public void updateJsonParserRules(String jsonRules) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.updateJsonParserRules(sessionId, jsonRules);
            return null;
        });
    }

    @Override
    public HostStatsCsvReport hostCsvReport(String hostRegex, String domainRegex, long start, long finish, String delimeter) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.hostCsvReport(sessionId, hostRegex, domainRegex, start, finish, delimeter));
    }

    @Override
    public EnrichedHostStatsGuiReport hostStatGuiReport(String hostRegex, String domainRegex, long start, long finish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.hostStatGuiReport(sessionId, hostRegex, domainRegex, start, finish));
    }

    @Override
    public EnrichedHostStatsGuiReport hostGuiReport(String hostRegex, String domainRegex, String ipRegex, String tagRegex, long start, long finish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.hostGuiReport(sessionId, hostRegex, domainRegex, ipRegex, tagRegex, start, finish));
    }

    @Override
    public SecurityEventsSearchResults searchAlertEvents(String search, SearchState state, int pageLength, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.searchAlertEvents(this.sid, search, state, pageLength, timeStart, timeFinish));
    }

    @Override
    public SecurityEventsSearchResults searchAlertEventsAsc(String search, SearchState state, int pageLength, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.searchAlertEventsAsc(this.sid, search, state, pageLength, timeStart, timeFinish));
    }

    @Override
    public SecurityEventsSearchResults fetchAlertEventsWithOffset(String search, SearchState state, int pageLength, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.fetchAlertEventsWithOffset(this.sid, search, state, pageLength, timeStart, timeFinish));
    }

    @Override
    public SecurityEventsSearchResults fetchAlertEventsAscWithOffset(String search, SearchState state, int pageLength, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.fetchAlertEventsAscWithOffset(this.sid, search, state, pageLength, timeStart, timeFinish));
    }

    @Override
    public SecurityEventsCountContainer alertEventsCountSearch(String search, SearchState state, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.alertEventsCountSearch(sessionId, search, state, timeStart, timeFinish));
    }

    @Override
    public SecurityEventsSearchResults fetchAlertEvents(String search, SearchState state, int pageLength, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.fetchAlertEvents(sessionId, search, state, pageLength, timeStart, timeFinish));
    }

    @Override
    public SecurityEventsSearchResults fetchAlertEventsAsc(String search, SearchState state, int pageLength, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.fetchAlertEventsAsc(sessionId, search, state, pageLength, timeStart, timeFinish));
    }

    @Override
    public SecurityEvent getAlertEvent(String securityEventId, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.getAlertEvent(this.sid, securityEventId, timeStart, timeFinish));
    }

    @Override
    public List<SavedQueryData> getAlertEventQueries() throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getAlertEventQueries(sessionId));
    }

    @Override
    public List<IndexDateRange> getAlertEventDateRangeByIndex(long timeStart, long timeFinish, boolean sortAsc) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getAlertEventDateRangeByIndex(sessionId, timeStart, timeFinish, sortAsc));
    }

    @Override
    public List<IndexDateRange> getCustomAlertEventDateRangeByIndex(long timeStart, long timeFinish, long split, boolean sortAsc) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getCustomAlertEventDateRangeByIndex(sessionId, timeStart, timeFinish, split, sortAsc));
    }

    @Override
    public List<TermTimeHistogram> getALTermTimeHistogram(String query, String field, long timeStart, long timeFinish, int noOfTerms, String interval, boolean sortAsc) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.getALTermTimeHistogram(sessionId, query, field, timeStart, timeFinish, noOfTerms, interval, sortAsc));
    }

    @Override
    public List<String> getDataMapNamesWithRegex(String regexKey) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getDataMapNamesWithRegex(sessionId, regexKey));
    }

    @Override
    public DataMapAggValue getKeysWithLastUpdatedForDataMapAgg(String mapName, String regex, int skip, int pageSize) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getKeysWithLastUpdatedForDataMapAgg(sessionId, mapName, regex, skip, pageSize));
    }

    @Override
    public String getServerApiVersion() throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getServerApiVersion(sessionId));
    }

    @Override
    public ListThreatIndicators getThreatIndicatorsBy(String type, String source, String tag, String confidenceLevel, long from, long to, int index, int size) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getThreatIndicatorsBy(sessionId, type, source, tag, confidenceLevel, from, to, index, size));
    }
}

