/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ParsingDebugInfoStep;
import rs.co.ast.aspen.gui.rawlogs.AssignmentsPanel;
import rs.co.ast.aspen.gui.rawlogs.MatchingPanel;
import rs.co.ast.aspen.gui.rawlogs.MetaRulesPanel;
import rs.co.ast.aspen.gui.rawlogs.RegexpMatchedGroupsPanel;

public class SimulationResultPanel
extends JPanel {
    private ParsingDebugInfoStep debugInfo;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lRulePath;
    private JPanel pList;
    private JTextArea taRegexp;

    public SimulationResultPanel(ParsingDebugInfoStep debugInfo) {
        this.debugInfo = debugInfo;
        this.initComponents();
        this.pList.setLayout(new BoxLayout(this.pList, 3));
        this.updateDisplay();
    }

    private void updateDisplay() {
        MatchingPanel mp = new MatchingPanel(this.debugInfo);
        this.pList.add(mp);
        this.lRulePath.setText(this.debugInfo.getRuleSetName() + " -> " + this.debugInfo.getGroupName() + " -> " + this.debugInfo.getRuleName());
        if (this.debugInfo.getRegexp() != null) {
            this.taRegexp.setText(this.debugInfo.getRegexp());
        }
        if (this.debugInfo.isRegexpMatched()) {
            RegexpMatchedGroupsPanel pMatchedGroups = new RegexpMatchedGroupsPanel(this.debugInfo.getRegexpGroups());
            this.pList.add(pMatchedGroups);
        }
        if (!this.debugInfo.getMetaRules().isEmpty()) {
            MetaRulesPanel mrp = new MetaRulesPanel(this.debugInfo.getMetaRules());
            this.pList.add(mrp);
        }
        AssignmentsPanel ap = new AssignmentsPanel(this.debugInfo.getAssignments());
        this.pList.add(ap);
        this.pList.validate();
        this.pList.repaint();
        this.validate();
        this.repaint();
    }

    private void initComponents() {
        this.lRulePath = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.pList = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.taRegexp = new JTextArea();
        this.jLabel2 = new JLabel();
        this.lRulePath.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.lRulePath, (String)NbBundle.getMessage(SimulationResultPanel.class, (String)"SimulationResultPanel.lRulePath.text"));
        this.pList.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout pListLayout = new GroupLayout(this.pList);
        this.pList.setLayout(pListLayout);
        pListLayout.setHorizontalGroup(pListLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 553, Short.MAX_VALUE));
        pListLayout.setVerticalGroup(pListLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 134, Short.MAX_VALUE));
        this.taRegexp.setEditable(false);
        this.taRegexp.setColumns(20);
        this.taRegexp.setLineWrap(true);
        this.taRegexp.setRows(3);
        this.taRegexp.setTabSize(4);
        this.taRegexp.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.taRegexp);
        this.jLabel2.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SimulationResultPanel.class, (String)"SimulationResultPanel.jLabel2.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lRulePath, -1, -1, Short.MAX_VALUE).addComponent(this.pList, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lRulePath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pList, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }
}

