/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.model;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import org.openide.util.Lookup;
import rs.co.ast.aspen.gui.module.datamaps.model.DataMapTableModel;

public class DataMapResultsTableModel
extends DefaultTableModel {
    private List<String> columnNames = new ArrayList<String>();
    private List<Map<String, String>> data = new ArrayList<Map<String, String>>();
    private DataMapTableModel tableModel = (DataMapTableModel)Lookup.getDefault().lookup(DataMapTableModel.class);

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0 && this.columnNames.get(columnIndex).contains("func.")) {
            return Integer.class;
        }
        return String.class;
    }

    public int getColumnIndexByColumnName(String columnName) {
        return this.columnNames.indexOf(columnName);
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames != null ? this.columnNames.get(column) : "unknown";
    }

    @Override
    public int getColumnCount() {
        return this.columnNames != null ? this.columnNames.size() : 0;
    }

    public void addColumn(String columnName) {
        if (columnName != null) {
            this.columnNames.add(columnName);
            this.fireTableStructureChanged();
        }
    }

    public void removeColumn(String columnName) {
        if (columnName != null) {
            this.columnNames.remove(columnName);
            this.fireTableStructureChanged();
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        String col = this.columnNames.get(column);
        String val = this.data.get(row).get(col);
        if (col.toLowerCase().equals("func")) {
            return Integer.valueOf(val);
        }
        return val;
    }

    @Override
    public int getRowCount() {
        return this.data != null ? this.data.size() : 0;
    }

    public void setData(List<Map<String, String>> data) {
        if (data != null) {
            List<String> columnNames1 = this.tableModel.getColumnNames();
            LinkedHashSet<String> cols = new LinkedHashSet<String>();
            cols.add("func.count");
            Map<String, String> get = data.get(0);
            for (String s : columnNames1) {
                for (Map.Entry<String, String> entrySet : get.entrySet()) {
                    if (!s.equals(entrySet.getKey())) continue;
                    cols.add(entrySet.getKey());
                }
            }
            this.columnNames = new ArrayList<String>(cols);
            this.fireTableStructureChanged();
            this.data = data;
            this.fireTableDataChanged();
        }
    }

    public List<Map<String, String>> getData() {
        return this.data;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public boolean isColumnVisible(String columnName) {
        for (String col : this.columnNames) {
            if (!col.equalsIgnoreCase(columnName)) continue;
            return true;
        }
        return false;
    }

    public void resetData() {
        this.columnNames.clear();
        this.data.clear();
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    public void resetDataKeepColumns() {
        this.data.clear();
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }
}

